/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.report.local;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.Date;
import kd.bos.entity.report.ReportCotent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.report.local.DeleteYesterdayFile;
import kd.bos.service.report.local.QueueConsumer;
import kd.bos.service.report.local.QueueProducer;
import kd.bos.service.report.local.ReportQueue;
import kd.bos.service.report.regist.ReportRegistService;
import kd.bos.service.report.util.ReportUtil;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.xdb.util.ConcurrentHashSet;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.lucene.util.RamUsageEstimator;

public class PutQueueSync
implements Runnable {
    private static final Log log = LogFactory.getLog(PutQueueSync.class);
    private static int queueLength = 100;
    private ReportCotent reportCotent;
    private static ConcurrentHashSet<String> DeleteYesterdayFileSet = new ConcurrentHashSet(2);
    private static ThreadPool threadPools = ThreadPools.newCachedThreadPool((String)"ReportQueueConsumerPoll", (int)0, (int)1);
    private boolean syncExecute = false;

    public boolean isSyncExecute() {
        return this.syncExecute;
    }

    public void setSyncExecute(boolean syncExecute) {
        this.syncExecute = syncExecute;
    }

    public PutQueueSync(ReportCotent reportCotent) {
        this.reportCotent = reportCotent;
    }

    @Override
    public void run() {
        this.produce(this.reportCotent);
    }

    public void produce(ReportCotent reportCotent) {
        try {
            if (!ReportRegistService.getMoudleStatus(reportCotent.getMoudleKey())) {
                return;
            }
            String key = reportCotent.getMoudleKey() + reportCotent.getUniqueKey();
            if (PutQueueSync.isObjectSizeTooBig(reportCotent)) {
                return;
            }
            if (!PutQueueSync.addReportQueue(key, reportCotent)) {
                return;
            }
            this.deleteYesterdayFile();
            log.info("\u672c\u5730\u961f\u5217\u751f\u4ea7\u8005\uff0c\u6dfb\u52a0\u5bf9\u8c61\uff0c\u552f\u4e00\u6807\u8bc6\uff1a" + reportCotent.getUniqueKey());
            if (!QueueConsumer.isWorking) {
                threadPools.execute((Runnable)new QueueConsumer());
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void deleteYesterdayFile() {
        String yesterday = new SimpleDateFormat("yyyyMMdd").format(DateUtils.addDays((Date)new Date(), (int)-1));
        LocalTime time = LocalTime.now();
        if (time.getHour() < 1) {
            return;
        }
        if (DeleteYesterdayFileSet.add((Object)yesterday)) {
            DeleteYesterdayFileSet.removeIf(a -> !a.equals(yesterday));
            ThreadPools.executeOnce((String)"DeleteYesterdayFile", (Runnable)new DeleteYesterdayFile());
        }
    }

    private static synchronized boolean addReportQueue(String key, ReportCotent reportCotent) {
        try {
            if (ReportQueue.queue.size() == queueLength && !QueueProducer.reportDateMap.containsKey(key)) {
                return false;
            }
            if (ReportQueue.queue.size() < queueLength) {
                ReportQueue.queue.put(ReportUtil.copyReportBean(reportCotent));
            } else if (QueueProducer.reportDateMap.containsKey(key)) {
                ReportQueue.queue.put(ReportUtil.copyReportBean(reportCotent));
            }
            QueueProducer.reportDateMap.put(key, new Date());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean isObjectSizeTooBig(ReportCotent reportCotent) {
        long maxSize;
        long size = RamUsageEstimator.sizeOf((byte[])JSON.toJSONString((Object)reportCotent).getBytes());
        if (size > (maxSize = 209715L)) {
            log.info("\u653e\u5165\u5bf9\u8c61\u8fc7\u5927\uff0c\u552f\u4e00\u6807\u8bc6\uff1a" + reportCotent.getUniqueKey());
            return true;
        }
        return false;
    }
}

