/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.report.local;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.entity.report.ReportCotent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.report.local.ReportQueue;
import kd.bos.service.report.local.SyncLocalReport;
import kd.bos.service.report.util.ReportUtil;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class QueueConsumer
implements Runnable {
    private static ThreadPool threadPools = ThreadPools.newCachedThreadPool((String)"ReportQueueConsumer", (int)1, (int)5);
    private static final Log log = LogFactory.getLog(QueueConsumer.class);
    public static volatile boolean isWorking = false;
    private ReentrantLock reentrantLock = new ReentrantLock();
    public static ConcurrentHashMap<String, LongAdder> consumerCountMap = new ConcurrentHashMap();

    @Override
    public void run() {
        this.consumer();
    }

    public void consumer() {
        try {
            if (this.reentrantLock.isLocked()) {
                return;
            }
            if (!this.reentrantLock.tryLock()) {
                return;
            }
            isWorking = true;
            ReportCotent message = null;
            log.info("\u672c\u5730\u961f\u5217\u4efb\u52a1\u6d88\u8d39.....");
            while ((message = (ReportCotent)ReportQueue.queue.poll()) != null) {
                log.info("\u5f53\u524d\u6709\u4efb\u52a1\u5728\u6d88\u8d39.....");
                log.info("\u552f\u4e00\u6807\u8bc6\uff1a" + message.getUniqueKey());
                this.syncCreateLocalReport(ReportUtil.copyReportBean(message));
            }
            isWorking = false;
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
        finally {
            if (!isWorking) {
                this.reentrantLock.unlock();
            }
        }
    }

    private ReportCotent copyReportBean(ReportCotent message) {
        ReportCotent reportCotent = new ReportCotent();
        reportCotent.setUniqueKey(message.getUniqueKey());
        reportCotent.setMoudleKey(message.getMoudleKey());
        reportCotent.setMoudleCount(message.getMoudleCount());
        reportCotent.setData(message.getData());
        return reportCotent;
    }

    private void syncCreateLocalReport(ReportCotent message) {
        threadPools.execute((Runnable)new SyncLocalReport(message));
    }
}

