/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.report.local;

import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import kd.bos.entity.constant.StatusEnum;
import kd.bos.entity.registcenter.ReportRecord;
import kd.bos.entity.report.ReportCotent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.report.ReportMessage;
import kd.bos.service.report.ReportMessagePublisher;
import kd.bos.service.report.WordReport;
import kd.bos.service.report.attachfileservice.AttachFileService;
import kd.bos.service.report.local.LogcalReportImpl;
import kd.bos.service.report.local.QueueConsumer;
import kd.bos.service.report.local.QueueProducer;
import kd.bos.service.report.regist.ReportRecordService;

public class SyncLocalReport
implements Runnable {
    private static Log log = LogFactory.getLog(SyncLocalReport.class);
    public static HashSet<String> firstConsumer = new HashSet();
    public static ConcurrentHashMap<String, Object> doAfterMap = new ConcurrentHashMap();
    private ReportCotent reportCotent;

    public SyncLocalReport(ReportCotent reportCotent) {
        this.reportCotent = reportCotent;
    }

    @Override
    public void run() {
        LogcalReportImpl iLocalReport = new LogcalReportImpl();
        iLocalReport.creLocalReport(this.reportCotent);
        String mapKey = this.reportCotent.getMoudleKey() + this.reportCotent.getUniqueKey();
        SyncLocalReport.addFirstReportRecord(this.reportCotent, mapKey, iLocalReport);
        QueueConsumer.consumerCountMap.computeIfAbsent(mapKey, key -> new LongAdder()).increment();
        log.info("key:" + mapKey + ",\u6d88\u8d39\u6b21\u6570\uff1a" + QueueConsumer.consumerCountMap.get(mapKey).intValue());
        if (this.reportCotent.getMoudleCount().intValue() == QueueConsumer.consumerCountMap.get(mapKey).intValue() && QueueConsumer.consumerCountMap.containsKey(mapKey) && doAfterMap.putIfAbsent(mapKey, 1) == null) {
            log.info("key:" + mapKey + "\uff0c\u5f00\u59cb\u6267\u884c\u540e\u7eed\u903b\u8f91");
            ReportRecordService.updateStatusAndUrl(StatusEnum.B.name(), this.reportCotent.getMoudleKey(), this.reportCotent.getUniqueKey(), null, null);
            this.doAfter(iLocalReport, mapKey);
        }
    }

    private static synchronized void addFirstReportRecord(ReportCotent reportCotent, String mapKey, LogcalReportImpl iLocalReport) {
        if (!firstConsumer.contains(mapKey)) {
            firstConsumer.add(mapKey);
            if (!ReportRecordService.isExistReportRecord(reportCotent.getMoudleKey(), reportCotent.getUniqueKey())) {
                SyncLocalReport.addReportRecord(reportCotent, iLocalReport);
            }
        }
    }

    private void doAfter(LogcalReportImpl iLocalReport, String mapKey) {
        String path = AttachFileService.upLoadFile(this.reportCotent, iLocalReport);
        ReportRecordService.updateStatusAndUrl(StatusEnum.C.name(), this.reportCotent.getMoudleKey(), this.reportCotent.getUniqueKey(), null, path);
        QueueConsumer.consumerCountMap.remove(mapKey);
        firstConsumer.remove(mapKey);
        doAfterMap.remove(mapKey);
        QueueProducer.reportDateMap.remove(mapKey);
        iLocalReport.deleteFile(this.reportCotent.getMoudleKey(), this.reportCotent.getUniqueKey());
        ReportMessagePublisher.publishMessage(new ReportMessage(this.reportCotent.getMoudleKey(), this.reportCotent.getUniqueKey()));
    }

    private void createWordReport(String path) {
        WordReport wordReport = new WordReport(this.reportCotent.getMoudleKey(), this.reportCotent.getUniqueKey());
        String url = wordReport.creteReport(path);
        ReportRecordService.updateStatusAndUrl(StatusEnum.S.name(), this.reportCotent.getMoudleKey(), this.reportCotent.getUniqueKey(), url, null);
    }

    private static void addReportRecord(ReportCotent reportCotent, LogcalReportImpl iLocalReport) {
        ReportRecord reportRecord = SyncLocalReport.buildReportRecord(reportCotent, iLocalReport);
        ReportRecordService.addReportRecord(reportRecord);
    }

    private static ReportRecord buildReportRecord(ReportCotent reportCotent, LogcalReportImpl iLocalReport) {
        ReportRecord reportRecord = new ReportRecord();
        reportRecord.setMoudleKey(reportCotent.getMoudleKey());
        reportRecord.setUniquekey(reportCotent.getUniqueKey());
        reportRecord.setStatus(StatusEnum.A.name());
        reportRecord.setCreateTime(new Date());
        reportRecord.setModifyTime(new Date());
        return reportRecord;
    }
}

