/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.report.regist;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.registcenter.ReportRecord;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ReportRecordService {
    private static final String BOS_REPORT_RECORD = "bos_report_record";

    public static void updateStatusAndUrl(String status, String moudleKey, String uniqueKey, String url, String urlTemp) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("update t_bos_report_record set ");
        sqlBuilder.append("fstatus = ?, fmodifytime = ?");
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            sqlBuilder.append(", furl = ?");
        }
        if (StringUtils.isNotEmpty((CharSequence)urlTemp)) {
            sqlBuilder.append(", furltemp = ?");
        }
        sqlBuilder.append(" where fmoudlekey = ? and funiquekey = ?");
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter("fstatus", 1, (Object)status));
        params.add(new SqlParameter("fmodifytime", 91, (Object)new Date()));
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            params.add(new SqlParameter("furl", 12, (Object)url));
        }
        if (StringUtils.isNotEmpty((CharSequence)urlTemp)) {
            params.add(new SqlParameter("furltemp", 12, (Object)urlTemp));
        }
        params.add(new SqlParameter("fmoudlekey", 12, (Object)moudleKey));
        params.add(new SqlParameter("funiquekey", 12, (Object)uniqueKey));
        try (TXHandle h = TX.requiresNew();){
            DB.update((DBRoute)DBRoute.meta, (String)sqlBuilder.toString(), (Object[])params.toArray(new SqlParameter[params.size()]));
        }
    }

    public static void addReportRecord(ReportRecord reportRecord) {
        DynamicObject dynamicObject = ReportRecordService.buildReportRecord(reportRecord);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public static ReportRecord getReportRecord(String moudleKey, String uniqueKey) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("select fid, fmoudlekey, funiquekey, fstatus, furl, furltemp, fmodifytime, fcreatetime ");
        sBuilder.append("from t_bos_report_record ");
        sBuilder.append("where fmoudlekey = ? and funiquekey = ? ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FMOUDLEKEY", 12, (Object)moudleKey), new SqlParameter(":FUNIQUEKEY", 12, (Object)uniqueKey)};
        ResultSetHandler<List<ReportRecord>> action = new ResultSetHandler<List<ReportRecord>>(){

            public List<ReportRecord> handle(ResultSet rs) throws Exception {
                ArrayList<ReportRecord> reportRecords = new ArrayList<ReportRecord>(10);
                while (rs.next()) {
                    ReportRecord reportRecord = new ReportRecord();
                    reportRecord.setId(Long.valueOf(rs.getLong("fid")));
                    reportRecord.setMoudleKey(rs.getString("fmoudlekey"));
                    reportRecord.setUniquekey(rs.getString("funiquekey"));
                    reportRecord.setStatus(rs.getString("fstatus"));
                    reportRecord.setUrl(rs.getString("furl"));
                    reportRecord.setUrltemp(rs.getString("furltemp"));
                    reportRecord.setModifyTime((Date)rs.getDate("fmodifytime"));
                    reportRecord.setCreateTime((Date)rs.getDate("fcreatetime"));
                    reportRecords.add(reportRecord);
                }
                return reportRecords;
            }
        };
        List reportRecords = (List)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        if (reportRecords.isEmpty()) {
            return null;
        }
        return (ReportRecord)reportRecords.get(0);
    }

    public static boolean isExistReportRecord(String moudleKey, String uniqueKey) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("select fid ");
        sBuilder.append("from t_bos_report_record ");
        sBuilder.append("where fmoudlekey = ? and funiquekey = ? ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FMOUDLEKEY", 12, (Object)moudleKey), new SqlParameter(":FUNIQUEKEY", 12, (Object)uniqueKey)};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                Boolean result = Boolean.FALSE;
                if (rs.next()) {
                    result = Boolean.TRUE;
                }
                return result;
            }
        };
        Boolean isExistReportRecord = (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        return isExistReportRecord;
    }

    public static List<ReportRecord> getReportRecords(List<Long> ids) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter("id", "in", ids));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)BOS_REPORT_RECORD, (String)"id,moudlekey,uniquekey,status,url,urltemp,createtime,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<ReportRecord> reportRecords = new ArrayList<ReportRecord>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            ReportRecord reportRecord = ReportRecordService.buildReportRecord(dynamicObject);
            reportRecords.add(reportRecord);
        }
        return reportRecords;
    }

    public static DynamicObject buildReportRecord(ReportRecord reportRecord) {
        DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)BOS_REPORT_RECORD);
        newObj.set("moudlekey", (Object)reportRecord.getMoudleKey());
        newObj.set("uniquekey", (Object)reportRecord.getUniquekey());
        newObj.set("status", (Object)reportRecord.getStatus());
        newObj.set("url", (Object)reportRecord.getUrl());
        newObj.set("urltemp", (Object)reportRecord.getUrltemp());
        newObj.set("createtime", (Object)reportRecord.getCreateTime());
        newObj.set("modifytime", (Object)reportRecord.getModifyTime());
        return newObj;
    }

    public static ReportRecord buildReportRecord(DynamicObject obj) {
        ReportRecord reportRecord = new ReportRecord();
        reportRecord.setId((Long)obj.getPkValue());
        reportRecord.setMoudleKey(obj.getString("moudlekey"));
        reportRecord.setUniquekey(obj.getString("uniquekey"));
        reportRecord.setStatus(obj.getString("status"));
        reportRecord.setUrl(obj.getString("url"));
        reportRecord.setUrltemp(obj.getString("urltemp"));
        reportRecord.setModifyTime(obj.getDate("modifytime"));
        reportRecord.setCreateTime(obj.getDate("createtime"));
        return reportRecord;
    }
}

