/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.report.regist;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.registcenter.ReportRegist;
import kd.bos.orm.query.QFilter;
import kd.bos.service.report.util.CacheUtil;
import kd.bos.service.report.util.ReportLocalCacheUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ReportRegistService {
    private static final String FORMID_REPORT_REGIST = "bos_report_regist";

    public static ReportRegist getRegistInfo(String moudleKey) {
        Object object = ReportLocalCacheUtils.get(moudleKey);
        if (object != null) {
            return (ReportRegist)object;
        }
        String value = CacheUtil.getValue(moudleKey);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            ReportLocalCacheUtils.put(moudleKey, SerializationUtils.fromJsonString((String)value, ReportRegist.class));
            return (ReportRegist)SerializationUtils.fromJsonString((String)value, ReportRegist.class);
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("moudlekey", "=", (Object)moudleKey));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)FORMID_REPORT_REGIST, (QFilter[])qFilters.toArray(new QFilter[0]));
        if (dynamicObject == null) {
            return new ReportRegist();
        }
        ReportRegist reportRegist = ReportRegistService.buildReportRegist(dynamicObject);
        if (reportRegist != null) {
            ReportLocalCacheUtils.put(moudleKey, reportRegist);
            CacheUtil.setValue(moudleKey, SerializationUtils.toJsonString((Object)reportRegist));
        }
        return reportRegist;
    }

    public static ReportRegist getRegistInfo(Long id) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "=", (Object)id));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)FORMID_REPORT_REGIST, (QFilter[])qFilters.toArray(new QFilter[0]));
        ReportRegist reportRegist = ReportRegistService.buildReportRegist(dynamicObject);
        return reportRegist;
    }

    public static List<ReportRegist> getAllRegistInfo() {
        ArrayList qFilters = new ArrayList();
        String fields = "moudlename,moudlekey,moudlestatus,callbackplugin,overtime,createtime";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)FORMID_REPORT_REGIST, (String)fields, (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<ReportRegist> reportRegists = new ArrayList<ReportRegist>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            reportRegists.add(ReportRegistService.buildReportRegist(dynamicObject));
        }
        return reportRegists;
    }

    public static Integer getOverTime(String moudleKey) {
        ReportRegist reportRegist = ReportRegistService.getRegistInfo(moudleKey);
        return reportRegist.getOverTime();
    }

    public static boolean getMoudleStatus(String moudleKey) {
        ReportRegist reportRegist = ReportRegistService.getRegistInfo(moudleKey);
        if (reportRegist.getMoudleStatus() == null) {
            return Boolean.FALSE;
        }
        return reportRegist.getMoudleStatus();
    }

    public static String getCallBackPlugin(String moudleKey) {
        ReportRegist reportRegist = ReportRegistService.getRegistInfo(moudleKey);
        return reportRegist.getCallBackPlugin();
    }

    public static ReportRegist buildReportRegist(DynamicObject obj) {
        ReportRegist reportRegist = new ReportRegist();
        reportRegist.setId((Long)obj.getPkValue());
        reportRegist.setMoudleName(obj.getString("moudlename"));
        reportRegist.setMoudleKey(obj.getString("moudlekey"));
        reportRegist.setMoudleStatus(Boolean.valueOf(obj.getBoolean("moudlestatus")));
        reportRegist.setCallBackPlugin(obj.getString("callbackplugin"));
        reportRegist.setOverTime(Integer.valueOf(obj.getInt("overtime")));
        reportRegist.setCreateTime(obj.getDate("createtime"));
        return reportRegist;
    }
}

