/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.report.util;

import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportCotent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;

public class ReportUtil {
    private static final Log log = LogFactory.getLog(ReportUtil.class);

    public static boolean checkReportCanUse(ReportCotent reportCotent, List<String> ignoreFields) {
        if (reportCotent == null) {
            log.info("\u62a5\u544a\u5bf9\u8c61reportCotent\u4e3a\u7a7a\u3002");
            return false;
        }
        boolean isHasIgnoreFields = CollectionUtils.isNotEmpty(ignoreFields);
        if (isHasIgnoreFields && !ignoreFields.contains("uniqueKey") && StringUtils.isEmpty((CharSequence)reportCotent.getUniqueKey())) {
            log.info("\u62a5\u544a\u5bf9\u8c61\u4e2d\u552f\u4e00\u6807\u8bc6\u4e3a\u7a7a\u3002");
            return false;
        }
        if (isHasIgnoreFields && !ignoreFields.contains("moudleKey") && StringUtils.isEmpty((CharSequence)reportCotent.getMoudleKey())) {
            log.info("\u62a5\u544a\u5bf9\u8c61\u4e2d\u6a21\u5757key\u4e3a\u7a7a\u3002");
            return false;
        }
        if (isHasIgnoreFields && !ignoreFields.contains("moudleCount") && (reportCotent.getMoudleCount() == null || reportCotent.getMoudleCount() == 0)) {
            log.info("\u62a5\u544a\u5bf9\u8c61\u4e2d\u653e\u5165\u6b21\u6570\u4e3a\u7a7a\u3002");
            return false;
        }
        if (isHasIgnoreFields && !ignoreFields.contains("data") && reportCotent.getData() == null) {
            log.info("\u62a5\u544a\u5bf9\u8c61\u4e2dgetData()\u4e3a\u7a7a\u3002");
            return false;
        }
        return true;
    }

    public static ReportCotent copyReportBean(ReportCotent reportCotent) {
        ReportCotent copy = new ReportCotent();
        copy.setUniqueKey(reportCotent.getUniqueKey());
        copy.setMoudleKey(reportCotent.getMoudleKey());
        copy.setMoudleCount(reportCotent.getMoudleCount());
        copy.setData(reportCotent.getData());
        return copy;
    }
}

