/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.attachment.extend.service;

import kd.bos.attachment.extend.service.IFileServiceExtension;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FileServiceExtensionFactory {
    private static Log logger = LogFactory.getLog(FileServiceExtensionFactory.class);
    private static final String CLASSNAME_KEY = "file.service.ext.impl.classname";

    public static IFileServiceExtension getFileServiceExtension() {
        String className = System.getProperty(CLASSNAME_KEY);
        if (StringUtils.isNotBlank((CharSequence)className)) {
            try {
                return (IFileServiceExtension)Class.forName(className).newInstance();
            }
            catch (Exception var2) {
                logger.error("init class " + className + " error:", (Throwable)var2);
            }
        }
        return FileServiceExtensionFactory.getDefaultFileServiceExtension();
    }

    public static IFileServiceExtension getDefaultFileServiceExtension() {
        return new DefaultFileServiceExtension();
    }

    static class DefaultFileServiceExtension
    implements IFileServiceExtension {
        DefaultFileServiceExtension() {
        }

        @Override
        public String getUploadDomainUrl() {
            return null;
        }

        @Override
        public String getDownloadUrl(String sourceUrl) {
            return sourceUrl;
        }
    }
}

