/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.attachment.util;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.web.actions.utils.FilePremissionUtil;

public class AttachExceptionHandler {
    public static Boolean dealException(KDException e, HttpServletResponse response) throws IOException {
        Boolean needReturn = Boolean.FALSE;
        if (AttachExceptionHandler.noPermissionException(e).booleanValue()) {
            String errorMessage = ResManager.loadKDString((String)"\u65e0\u8bbf\u95ee\u6743\u9650!", (String)"AttachmentAction_11", (String)"bos-webactions", (Object[])new Object[0]);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)errorMessage);
            needReturn = Boolean.TRUE;
        } else if (AttachExceptionHandler.illegalPathException(e).booleanValue()) {
            response.sendError(400, "ILLEGAL_PATH");
            needReturn = Boolean.TRUE;
        } else if (AttachExceptionHandler.csvErrorException(e).booleanValue() || AttachExceptionHandler.notSupportPictureFormatException(e).booleanValue() || AttachExceptionHandler.checkFileErrorException(e).booleanValue()) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("status", "error");
            result.put("description", e.getMessage());
            String jsonResult = SerializationUtils.toJsonString(result);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
            needReturn = Boolean.TRUE;
        } else if (AttachExceptionHandler.InvalidPathException(e).booleanValue() || AttachExceptionHandler.TimeOutException(e).booleanValue()) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)e.getMessage());
            needReturn = Boolean.TRUE;
        }
        return needReturn;
    }

    public static Boolean dealException(KDException e, IFormView view, String entityNum, String permItem) {
        Boolean needReturn = Boolean.FALSE;
        if (AttachExceptionHandler.noPermissionException(e).booleanValue()) {
            view.showErrorNotification(FilePremissionUtil.genNoPermissionTips(entityNum, permItem));
            needReturn = Boolean.TRUE;
        } else if (AttachExceptionHandler.illegalPathException(e).booleanValue()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u6d4b\u5230\u5220\u9664\u56fe\u7247\u7684\u8def\u5f84\u975e\u6cd5\uff0c\u7981\u6b62\u5220\u9664\u3002", (String)"AttachExceptionHandler_1", (String)"bos-svc-common", (Object[])new Object[0]));
            needReturn = Boolean.TRUE;
        }
        return needReturn;
    }

    public static Boolean noPermissionException(KDException e) {
        return e.getErrorCode() != null && "NO Permission!".equals(e.getErrorCode().getCode());
    }

    public static Boolean illegalPathException(KDException e) {
        return e.getErrorCode() != null && "ILLEGAL_PATH".equals(e.getErrorCode().getCode());
    }

    public static Boolean csvErrorException(KDException e) {
        return e.getErrorCode() != null && "CSVERROR".equals(e.getErrorCode().getCode());
    }

    public static Boolean checkFileErrorException(KDException e) {
        return e.getErrorCode() != null && "CHECK_FILE_ERROR".equals(e.getErrorCode().getCode());
    }

    public static Boolean notSupportPictureFormatException(KDException e) {
        return e.getErrorCode() != null && "NOSUPPORT_PICTURE_FORMAT".equals(e.getErrorCode().getCode());
    }

    public static Boolean InvalidPathException(KDException e) {
        return e.getErrorCode() != null && "Invalid Path!".equals(e.getErrorCode().getCode());
    }

    public static Boolean TimeOutException(KDException e) {
        return e.getErrorCode() != null && "timeout!".equals(e.getErrorCode().getCode());
    }
}

