/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.attachment.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.attachment.util.AttachmentJWT;
import kd.bos.attachment.util.AttachmentJWTCreator;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.attachment.util.ParamUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AttachmentCommonUtils {
    private static final Log log = LogFactory.getLog(AttachmentCommonUtils.class);
    private static final String JWT_SUBJECT = "kdjwt";
    private static final String JWT_ID = "kd";

    public static String generateJWTByMapParameters(Map<String, Object> parameters, String jwtKey, long expireTime, boolean useNormalType) {
        String jwtString = "";
        try {
            if (parameters != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)jwtKey)) {
                Algorithm algorithm = Algorithm.HMAC256((String)jwtKey);
                if (useNormalType) {
                    JWTCreator.Builder builder = JWT.create().withSubject(JWT_SUBJECT).withIssuer(JWT_ID).withIssuedAt(new Date()).withExpiresAt(new Date(expireTime));
                    for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                        if (parameter == null) continue;
                        String paramKey = parameter.getKey();
                        Object paramValue = Optional.ofNullable(parameter.getValue()).orElse("");
                        builder = builder.withClaim(paramKey, paramValue.toString());
                    }
                    jwtString = builder.sign(algorithm);
                } else {
                    AttachmentJWTCreator.Builder builder = AttachmentJWT.create().withSubject(JWT_SUBJECT).withIssuer(JWT_ID).withIssuedAt(new Date()).withExpiresAt(new Date(expireTime)).withClaims(parameters);
                    jwtString = builder.sign(algorithm);
                }
            }
        }
        catch (Exception e) {
            log.error("generateJWT failed:", (Throwable)e);
        }
        return jwtString;
    }

    public static boolean jwtVerify(String jwtKey, String token) {
        try {
            if (StringUtils.isBlank((CharSequence)jwtKey)) {
                log.error("jwt verify jwtKey is empty");
                return false;
            }
            if (StringUtils.isBlank((CharSequence)token)) {
                log.error("jwt verify token is empty");
                return false;
            }
            JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)jwtKey)).build();
            verifier.verify(token);
        }
        catch (JWTVerificationException e) {
            log.error("check token failed token is:" + token, (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.error("jwtVerify take error:", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getWpsJwtToken(boolean isPreview) {
        Map<String, String> config = ParamUtil.getWpsPrivateParam(isPreview);
        String accessKey = config.get("wpsPrivateAppId");
        String secretKey = config.get("wpsPrivateSecret");
        HashMap<String, Object> tokenMap = new HashMap<String, Object>(4);
        tokenMap.put("appId", accessKey);
        return AttachmentCommonUtils.generateJWTByMapParameters(tokenMap, secretKey, System.currentTimeMillis() + 86400000L, true);
    }
}

