/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.attachment.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentOpType;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.FieldType;
import org.apache.commons.lang3.math.NumberUtils;

public class AttachmentOpLogUtil {
    private static String BOS_SVC_COMMON = "bos-svc-common";
    private static final Log log = LogFactory.getLog(AttachmentOpLogUtil.class);

    @Deprecated
    public static String genOpDescription(AttachmentOpType opType) {
        return AttachmentOpLogUtil.genOpDescription(opType, "");
    }

    @Deprecated
    public static String genOpDescription(AttachmentOpType opType, String param) {
        String description = "";
        switch (opType) {
            case Save: {
                description = ResManager.loadKDString((String)"\u9644\u4ef6\u4fdd\u5b58\u6210\u529f\u3002", (String)"OpLog_Description_Save", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
                break;
            }
            case Upload: {
                description = ResManager.loadKDString((String)"\u4e0a\u4f20\u6210\u529f\u3002", (String)"OpLog_Description_Upload", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
                break;
            }
            case PreView: {
                description = ResManager.loadKDString((String)"\u9884\u89c8\u6210\u529f\u3002", (String)"OpLog_Description_Preview", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
                break;
            }
            case Download: {
                description = ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f\u3002", (String)"OpLog_Description_Download", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
                break;
            }
            case DownloadFromUrl: {
                description = ResManager.loadKDString((String)"\u901a\u8fc7\u94fe\u63a5\u4e0b\u8f7d\u6210\u529f\u3002", (String)"OpLog_Description_DownloadUrl", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
                break;
            }
            case Remove: {
                description = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OpLog_Description_Remove", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
                break;
            }
            case Mark: {
                description = String.format(ResManager.loadKDString((String)"\u5907\u6ce8\uff1a%s", (String)"OpLog_Description_Mark", (String)BOS_SVC_COMMON, (Object[])new Object[0]), param);
                break;
            }
            case Rename: {
                description = String.format(ResManager.loadKDString((String)"\u91cd\u547d\u540d\u4e3a\uff1a%s", (String)"OpLog_Description_Rename", (String)BOS_SVC_COMMON, (Object[])new Object[0]), param);
                break;
            }
        }
        return description;
    }

    public static String getPathFromUrl(String downloadUrl, String locationType) {
        if (!"1".equals(locationType)) {
            return downloadUrl;
        }
        String path = UrlUtil.getParam((String)downloadUrl, (String)"path");
        if (StringUtils.isNotBlank((CharSequence)path)) {
            try {
                downloadUrl = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException ignore) {
                log.warn("URLDecoder.decode path UnsupportedEncodingException : path = " + path, (Throwable)ignore);
            }
            while (downloadUrl.startsWith("//")) {
                downloadUrl = downloadUrl.replace("//", "/");
            }
        }
        return downloadUrl;
    }

    public static String converString(String targetString) {
        return targetString == null ? "" : targetString;
    }

    public static Long convertoLong(String targetString) {
        return NumberUtils.isParsable((String)targetString) ? Long.parseLong(targetString) : 0L;
    }

    public static String getLocationTypeByUrl(String url) {
        return AttachmentOpLogUtil.converString(url).contains("tempfile/download.do?configKey") ? "0" : "1";
    }

    public static String getLocationTypeByUrlV1(String url) {
        return (url = AttachmentOpLogUtil.converString(url)).contains("tempfile/download.do?configKey") ? "0" : (url.contains("export.do?templateid") ? "2" : "1");
    }

    public static String getExtFromFileName(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName) || !fileName.contains(".")) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(46) + 1);
    }

    public static String getRealPath(String path, FieldType fieldType) {
        String realPath = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(path);
        if (fieldType != FieldType.AttachmentPanel && fieldType != FieldType.AttachmentEdit) {
            realPath = FileServiceFactory.getImageFileService().getFileServiceExt().getRealPath(path);
        }
        return realPath;
    }

    public static AttachmentInfo packageAttachmentInfo(IFormView view, String imageKey, FieldType filedType, AttachmentType attType, String path) {
        Date now = new Date();
        RequestContext rc = RequestContext.get();
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)view.getModel().getDataEntityType().getName());
        String entityNum = formConfig.getEntityTypeId();
        String appId = formConfig.getAppId();
        AttachmentInfo attachmentInfo = new AttachmentInfo();
        attachmentInfo.setAttSourceType(attType);
        attachmentInfo.setFieldType(filedType);
        attachmentInfo.setFieldKey(imageKey);
        attachmentInfo.setFileName(AttachmentOpLogUtil.getFileName(path));
        attachmentInfo.setExt(AttachmentOpLogUtil.getFileExt(path));
        attachmentInfo.setEntityNum(entityNum);
        attachmentInfo.setAppId(appId);
        attachmentInfo.setAttKey(imageKey);
        attachmentInfo.setBillPkId(String.valueOf(view.getModel().getDataEntity().getPkValue()));
        attachmentInfo.setDownloadUrl(path);
        attachmentInfo.setCreateTime(now);
        attachmentInfo.setCreateUserId(rc.getUserId());
        attachmentInfo.setModifyTime(now);
        String billno = "";
        MainEntityType dataEntityType = view.getModel().getDataEntityType();
        if (dataEntityType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)dataEntityType).getBillNo())) {
            billno = view.getModel().getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
        }
        attachmentInfo.setBillno(billno);
        boolean isWeb = !"mobile".equals(RequestContext.get().getClient()) && !(view instanceof IMobileView);
        attachmentInfo.setClient(isWeb ? "web" : "mobile");
        return attachmentInfo;
    }

    public static String getFileName(String path) {
        path = FileServiceExtFactory.getImageFileServiceExt().getRealPath(path);
        String fileName = path.substring(path.lastIndexOf("/") + 1);
        return fileName;
    }

    public static String getFileExt(String path) {
        path = FileServiceExtFactory.getImageFileServiceExt().getRealPath(path);
        String ext = path.substring(path.lastIndexOf(".") + 1);
        return ext;
    }
}

