/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.attachment.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.attachment.util.AttachmentOpLogUtil;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.FieldType;
import kd.bos.mservice.attachment.SyncStatus;
import kd.bos.mservice.svc.attach.IAttachmentFieldModelProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class BillFileMappingWriter {
    private static String BOS_SVC_COMMON = "bos-svc-common";
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"BillFileMappingWriter", (int)5);
    private static final Log log = LogFactory.getLog(BillFileMappingWriter.class);
    public static final String ENTITY_BOS_BILL_FILE_MAPPING = "bos_bill_file_mapping";
    private static final String FIELD_FILENAME = "filename";
    private static final String FIELD_BIZOBJ = "bizobj";
    private static final String FIELD_FILELOCATION = "filelocation";
    private static final String FIELD_ATTPKID = "attpkid";
    private static final String FIELD_BILLPKID = "billpkid";
    private static final String FIELD_APPID = "appid";
    private static final String FIELD_FIELDTYPE = "fieldtype";
    private static final String FIELD_PATH = "path";
    private static final String FIELD_FIELDKEY = "fieldkey";
    private static final String FIELD_BILLENTRYPKID = "billentrypkid";
    private static final String FIELD_CREATOR = "creator";
    private static final String FIELD_CREATEDATE = "createdate";
    private static final String FIELD_SYNCSTATUS = "syncstatus";
    private static final String FIELD_SYNCDATE = "syncdate";

    public static void syncWriteFileBillMapping(String path) {
        threadPool.execute(() -> {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_BOS_BILL_FILE_MAPPING, (String)"id", (QFilter[])new QFilter[]{new QFilter(FIELD_PATH, "=", (Object)path)});
            if (dynamicObject != null) {
                return;
            }
            Object[] pkArray = BillFileMappingWriter.write(BillFileMappingWriter.createSyncingData(path));
            List<AttachmentInfo> attachmentInfoList = BillFileMappingWriter.getRefListByPath(path);
            BillFileMappingWriter.write(attachmentInfoList);
            MainEntityType billFileMapping = EntityMetadataCache.getDataEntityType((String)ENTITY_BOS_BILL_FILE_MAPPING);
            DeleteServiceHelper.delete((IDataEntityType)billFileMapping, (Object[])pkArray);
        });
    }

    private static List<AttachmentInfo> createSyncingData(String path) {
        ArrayList<AttachmentInfo> attachmentInfoList = new ArrayList<AttachmentInfo>(1);
        AttachmentInfo attachmentInfo = new AttachmentInfo();
        attachmentInfo.setDownloadUrl(path);
        attachmentInfo.setSyncStatus(SyncStatus.ING);
        attachmentInfo.setBillPkId("123");
        attachmentInfo.setFieldType(FieldType.AttachmentPanel);
        attachmentInfo.setAttPkId(Long.valueOf(0L));
        attachmentInfoList.add(attachmentInfo);
        return attachmentInfoList;
    }

    private static List<AttachmentInfo> getRefListByPath(String path) {
        String pathOrId = BillFileMappingWriter.tryQueryEncryptPath(path);
        pathOrId = pathOrId.replace("/", "");
        String urlFiledName = "ffileid";
        QFilter[] filters = new QFilter[]{new QFilter(urlFiledName, "=", (Object)path).or(new QFilter(urlFiledName, "=", (Object)pathOrId))};
        String selectFields = " FID ,FBILLTYPE ,FINTERID ,FFILEID ,FATTACHMENTNAME ,FATTACHMENTPANEL ";
        DynamicObject[] attachments = BusinessDataServiceHelper.load((String)"bos_attachment", (String)selectFields, (QFilter[])filters);
        ArrayList<AttachmentInfo> attachmentInfoList = new ArrayList<AttachmentInfo>(attachments.length);
        for (DynamicObject attachmentpanel : attachments) {
            String entityNum = attachmentpanel.getString("FBillType");
            String appId = EntityMetadataCache.getDataEntityType((String)entityNum).getAppId();
            AttachmentInfo attachmentInfo = new AttachmentInfo();
            attachmentInfo.setFieldType(FieldType.AttachmentPanel);
            attachmentInfo.setEntityNum(entityNum);
            attachmentInfo.setAppId(appId);
            attachmentInfo.setBillEntryPkId("0");
            attachmentInfo.setFieldKey(attachmentpanel.getString("FATTACHMENTPANEL"));
            attachmentInfo.setAttPkId((Long)attachmentpanel.getPkValue());
            attachmentInfo.setBillPkId(attachmentpanel.getString("FINTERID"));
            attachmentInfo.setDownloadUrl(path);
            attachmentInfoList.add(attachmentInfo);
        }
        IAttachmentFieldModelProxy attachmentFieldModel = (IAttachmentFieldModelProxy)ServiceFactory.getService(IAttachmentFieldModelProxy.class);
        urlFiledName = "url";
        filters = new QFilter[]{new QFilter(urlFiledName, "=", (Object)path).or(new QFilter(urlFiledName, "=", (Object)pathOrId))};
        Map attachmentFieldMap = BusinessDataServiceHelper.loadFromCache((String)"bd_attachment", (QFilter[])filters);
        for (Map.Entry it : attachmentFieldMap.entrySet()) {
            DynamicObject attachmentField = (DynamicObject)it.getValue();
            List refMapList = attachmentFieldModel.getAttachmentRefList(attachmentField.getPkValue());
            for (Map map : refMapList) {
                String entityNum = (String)map.get("refEntityKey");
                String appId = EntityMetadataCache.getDataEntityType((String)entityNum).getAppId();
                AttachmentInfo attachmentInfo = new AttachmentInfo();
                attachmentInfo.setFieldType(FieldType.AttachmentEdit);
                attachmentInfo.setEntityNum(entityNum);
                attachmentInfo.setAppId(appId);
                attachmentInfo.setFieldKey((String)map.get("attKey"));
                attachmentInfo.setAttPkId((Long)attachmentField.getPkValue());
                attachmentInfo.setBillPkId(map.get("billPkId").toString());
                attachmentInfo.setBillEntryPkId(map.get("entryPkId").toString());
                attachmentInfo.setDownloadUrl(path);
                attachmentInfoList.add(attachmentInfo);
            }
        }
        return attachmentInfoList;
    }

    private static String tryQueryEncryptPath(String pathOrId) {
        if (StringUtils.isBlank((CharSequence)pathOrId)) {
            return pathOrId;
        }
        if (!pathOrId.contains(".")) {
            return pathOrId;
        }
        String sql = "select FFILEID from t_bas_filepathmapping where FPATH = ? ";
        Object[] params = new SqlParameter[1];
        String path = pathOrId;
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Throwable)e);
        }
        while (path.startsWith("//")) {
            path = path.replaceFirst("//", "/");
        }
        params[0] = new SqlParameter(":FPATH", 12, (Object)path);
        String encryptPath = (String)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            String result = null;
            while (rs.next()) {
                result = rs.getString("FFILEID");
            }
            return result;
        });
        if (StringUtils.isBlank((CharSequence)encryptPath)) {
            return pathOrId;
        }
        return encryptPath;
    }

    public static void syncWriteFileBillMapping(List<AttachmentInfo> infos) {
        threadPool.execute(() -> BillFileMappingWriter.write(infos));
    }

    public static Object[] write(List<AttachmentInfo> infos) {
        RequestContext rc = RequestContext.get();
        Date now = new Date();
        ArrayList<DynamicObject> billFillMappings = new ArrayList<DynamicObject>(10);
        for (AttachmentInfo info : infos) {
            boolean attachFieldType;
            if (!info.isWriteMapping()) continue;
            String downloadUrl = AttachmentOpLogUtil.converString(info.getDownloadUrl());
            String locationType = AttachmentOpLogUtil.getLocationTypeByUrl(downloadUrl);
            Long billPkId = AttachmentOpLogUtil.convertoLong(info.getBillPkId());
            boolean bl = attachFieldType = FieldType.AttachmentPanel == info.getFieldType() || FieldType.AttachmentEdit == info.getFieldType() || FieldType.Button == info.getFieldType() || FieldType.ToolBar == info.getFieldType() || FieldType.Label == info.getFieldType() || FieldType.ReportExportButton == info.getFieldType();
            if ("0".equals(locationType) || !attachFieldType) continue;
            String path = BillFileMappingWriter.getPathFromUrl(downloadUrl, locationType);
            path = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(path);
            BillFileMappingWriter.deleteHistoryMappingRecord(path, info.getEntityNum(), info.getAppId());
            Boolean hasMappingRecord = BillFileMappingWriter.checkMappingRecord(path, info.getEntityNum(), info.getAppId());
            if (hasMappingRecord.booleanValue()) continue;
            DynamicObject billFillMapping = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_BOS_BILL_FILE_MAPPING);
            billFillMapping.set(FIELD_APPID, (Object)AttachmentOpLogUtil.converString(info.getAppId()));
            billFillMapping.set(FIELD_BIZOBJ, (Object)AttachmentOpLogUtil.converString(info.getEntityNum()));
            String fileName = StringUtils.isNotBlank((CharSequence)AttachmentOpLogUtil.converString(info.getFileName())) ? AttachmentOpLogUtil.converString(info.getFileName()) : BillFileMappingWriter.getFileNameFormPath(path);
            billFillMapping.set(FIELD_FILENAME, (Object)fileName);
            billFillMapping.set(FIELD_PATH, (Object)path);
            billFillMapping.set(FIELD_FILELOCATION, (Object)locationType);
            billFillMapping.set(FIELD_FIELDTYPE, (Object)AttachmentOpLogUtil.converString(info.getFieldType().getValue()));
            billFillMapping.set(FIELD_FIELDKEY, (Object)AttachmentOpLogUtil.converString(info.getFieldKey()));
            billFillMapping.set(FIELD_ATTPKID, (Object)info.getAttPkId());
            billFillMapping.set(FIELD_BILLPKID, (Object)billPkId);
            billFillMapping.set(FIELD_BILLENTRYPKID, (Object)AttachmentOpLogUtil.convertoLong(info.getBillEntryPkId()));
            billFillMapping.set(FIELD_CREATOR, (Object)rc.getCurrUserId());
            billFillMapping.set(FIELD_CREATEDATE, (Object)now);
            billFillMapping.set(FIELD_SYNCSTATUS, (Object)(info.getSyncStatus() != null ? info.getSyncStatus().getValue() : SyncStatus.Success.getValue()));
            billFillMapping.set(FIELD_SYNCDATE, (Object)now);
            billFillMappings.add(billFillMapping);
        }
        if (billFillMappings.size() == 0) {
            return new Object[0];
        }
        Object[] pkList = SaveServiceHelper.save((DynamicObject[])billFillMappings.toArray(new DynamicObject[0]));
        return pkList;
    }

    private static String getPathFromUrl(String downloadUrl, String locationType) {
        if (!"1".equals(locationType)) {
            return downloadUrl;
        }
        String path = UrlUtil.getParam((String)downloadUrl, (String)FIELD_PATH);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            try {
                downloadUrl = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException ignore) {
                log.warn("URLDecoder.decode path UnsupportedEncodingException : path = " + path, (Throwable)ignore);
            }
            while (downloadUrl.startsWith("//")) {
                downloadUrl = downloadUrl.replace("//", "/");
            }
        }
        return downloadUrl;
    }

    private static String getFileNameFormPath(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private static Boolean checkMappingRecord(String path, String entityNum, String appId) {
        QFilter pathEquals = new QFilter(FIELD_PATH, "=", (Object)path);
        QFilter entityNumEquals = new QFilter(FIELD_BIZOBJ, "=", (Object)entityNum);
        QFilter appIdEquals = new QFilter("appId", "=", (Object)appId);
        QFilter syncStatusEquals = new QFilter("syncStatus", "=", (Object)SyncStatus.Success.getValue());
        QFilter[] qFilters = new QFilter[]{pathEquals, entityNumEquals, appIdEquals, syncStatusEquals};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_BOS_BILL_FILE_MAPPING, (String)"id", (QFilter[])qFilters);
        return dynamicObject != null;
    }

    private static void deleteHistoryMappingRecord(String path, String entityNum, String appId) {
        QFilter pathEquals = new QFilter(FIELD_PATH, "=", (Object)path);
        QFilter entityNumEquals = new QFilter(FIELD_BIZOBJ, "=", (Object)entityNum);
        QFilter appIdEquals = new QFilter("appId", "=", (Object)appId);
        QFilter syncStatusEquals = new QFilter("syncStatus", "=", (Object)SyncStatus.Success.getValue());
        QFilter billPkId = new QFilter("billPkId", "=", (Object)0);
        QFilter[] qFilters = new QFilter[]{pathEquals, entityNumEquals, appIdEquals, syncStatusEquals, billPkId};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_BOS_BILL_FILE_MAPPING, (String)"id", (QFilter[])qFilters);
        if (dynamicObject != null) {
            BusinessDataWriter.delete((String)ENTITY_BOS_BILL_FILE_MAPPING, (QFilter[])qFilters);
        }
    }

    public static void removeMappingRecord(String path, String source) {
        path = "image".equals(source) ? FileServiceExtFactory.getImageFileServiceExt().getRealPath(path) : FileServiceExtFactory.getAttachFileServiceExt().getRealPath(path);
        QFilter pathEquals = new QFilter(FIELD_PATH, "=", (Object)path);
        QFilter[] qFilters = new QFilter[]{pathEquals};
        DeleteServiceHelper.delete((String)ENTITY_BOS_BILL_FILE_MAPPING, (QFilter[])qFilters);
    }

    public static AttachmentInfo createAttachInfoForPicture(IDataModel model, String fieldKey, FieldType fieldType, String path) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)model.getDataEntityType().getName());
        String entityNum = formConfig.getEntityTypeId();
        String appId = formConfig.getAppId();
        Object pkValue = model.getDataEntity().getPkValue();
        String billPkId = pkValue == null ? "" : pkValue.toString();
        AttachmentInfo attachmentInfo = new AttachmentInfo();
        attachmentInfo.setFieldType(fieldType);
        attachmentInfo.setEntityNum(entityNum);
        attachmentInfo.setAppId(appId);
        attachmentInfo.setBillEntryPkId("0");
        attachmentInfo.setFieldKey(fieldKey);
        attachmentInfo.setAttPkId(Long.valueOf(0L));
        attachmentInfo.setBillPkId(billPkId);
        attachmentInfo.setDownloadUrl(path);
        return attachmentInfo;
    }
}

