/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.attachment.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FileSecurityUtil {
    private static final String regex = "[/\\*\"?:<>|]";
    private static final Log log = LogFactory.getLog(FileSecurityUtil.class);

    public static String getSecurityHeader(String sourceHeader) {
        if (sourceHeader == null) {
            return sourceHeader;
        }
        Pattern pa = Pattern.compile(regex);
        Matcher matcher = pa.matcher(sourceHeader);
        if (matcher.find()) {
            sourceHeader = matcher.replaceAll("");
        }
        return sourceHeader;
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    public static void safeDeleteFile(File file) {
        if (file != null) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    public static void safeDeleteFileWithOutException(File file) {
        if (file != null) {
            file.deleteOnExit();
        }
    }
}

