/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.earlywarn.kit;

import java.util.function.Function;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.earlywarn.kit.CharUtil;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;

public class StringTemplateParser {
    private static final String BOS_ENTITY_CORE = "bos-entity-core";
    protected boolean replaceMissingKey = true;
    protected String missingKeyReplacement;
    protected boolean resolveEscapes = true;
    protected String macroPrefix = null;
    protected String macroStart = "{";
    protected String macroEnd = "}";
    protected char escapeChar = (char)92;
    protected boolean parseValues;

    public StringTemplateParser setReplaceMissingKey(boolean replaceMissingKey) {
        this.replaceMissingKey = replaceMissingKey;
        return this;
    }

    public StringTemplateParser setMissingKeyReplacement(String missingKeyReplacement) {
        this.missingKeyReplacement = missingKeyReplacement;
        return this;
    }

    public StringTemplateParser setResolveEscapes(boolean resolveEscapes) {
        this.resolveEscapes = resolveEscapes;
        return this;
    }

    public StringTemplateParser setMacroStart(String macroStart) {
        this.macroStart = macroStart;
        return this;
    }

    public StringTemplateParser setMacroPrefix(String macroPrefix) {
        this.macroPrefix = macroPrefix;
        return this;
    }

    public StringTemplateParser setMacroEnd(String macroEnd) {
        this.macroEnd = macroEnd;
        return this;
    }

    public StringTemplateParser setStrictFormat() {
        this.macroPrefix = null;
        return this;
    }

    public StringTemplateParser setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
        return this;
    }

    public StringTemplateParser setParseValues(boolean parseValues) {
        this.parseValues = parseValues;
        return this;
    }

    public String parse(String template, Function<String, String> macroResolver) {
        boolean strict;
        StringBuilder result = new StringBuilder(template.length());
        int i = 0;
        int len = template.length();
        if (this.macroPrefix == null) {
            this.macroPrefix = this.macroStart;
            strict = true;
        } else {
            strict = false;
        }
        int prefixLen = this.macroPrefix.length();
        int startLen = this.macroStart.length();
        int endLen = this.macroEnd.length();
        while (i < len) {
            String value;
            int ndx2;
            int ndx1;
            int ndx = template.indexOf(this.macroPrefix, i);
            if (ndx == -1) {
                result.append(i == 0 ? template : template.substring(i));
                break;
            }
            boolean escape = false;
            int count = 0;
            for (int j = ndx - 1; j >= 0 && template.charAt(j) == this.escapeChar; --j) {
                boolean bl = escape = !escape;
                if (!escape) continue;
                ++count;
            }
            if (this.resolveEscapes) {
                result.append(template.substring(i, ndx - count));
            } else {
                result.append(template.substring(i, ndx));
            }
            if (escape) {
                result.append(this.macroPrefix);
                i = ndx + prefixLen;
                continue;
            }
            boolean detectedStrictFormat = strict;
            if (!strict && StringUtil.isSubstringAt(template, this.macroStart, ndx)) {
                detectedStrictFormat = true;
            }
            if (!detectedStrictFormat) {
                ndx1 = ndx += prefixLen;
                for (ndx2 = ndx; ndx2 < len && CharUtil.isPropertyNameChar(template.charAt(ndx2)); ++ndx2) {
                }
                if (ndx2 == len) {
                    --ndx2;
                }
                while (ndx2 > ndx && !CharUtil.isAlphaOrDigit(template.charAt(ndx2))) {
                    --ndx2;
                }
                if (++ndx2 == ndx + 1) {
                    result.append(this.macroPrefix);
                    i = ndx;
                    continue;
                }
            } else {
                int n;
                ndx2 = template.indexOf(this.macroEnd, ndx += startLen);
                if (ndx2 == -1) {
                    String message = ResManager.loadKDString((String)"\u9884\u8b66\u5185\u5bb9\u4e2d\u8f93\u5165\u7684\u5173\u952e\u5b57\uff0c\u7cfb\u7edf\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"StringTemplateParser_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]);
                    throw new KDBizException(new ErrorCode("InvalidTemplate", message), new Object[]{"Invalid template, unclosed macro at: " + (ndx - startLen)});
                }
                ndx1 = ndx;
                while (ndx1 < ndx2 && (n = StringUtil.indexOf(template, this.macroStart, ndx1, ndx2)) != -1) {
                    ndx1 = n + startLen;
                }
            }
            String name = template.substring(ndx1, ndx2);
            if (this.missingKeyReplacement == null && this.replaceMissingKey) {
                value = macroResolver.apply(name);
                if (value == null) {
                    value = "";
                }
            } else {
                try {
                    value = macroResolver.apply(name);
                }
                catch (Exception var20) {
                    value = null;
                }
                if (value == null) {
                    value = this.replaceMissingKey ? this.missingKeyReplacement : (detectedStrictFormat ? template.substring(ndx1 - startLen, ndx2 + endLen) : template.substring(ndx1 - 1, ndx2));
                }
            }
            if (ndx == ndx1) {
                String stringValue = value.toString();
                if (this.parseValues && stringValue.contains(this.macroStart)) {
                    stringValue = this.parse(stringValue, macroResolver);
                }
                result.append(stringValue);
                i = ndx2;
                if (!detectedStrictFormat) continue;
                i = ndx2 + endLen;
                continue;
            }
            template = template.substring(0, ndx1 - startLen) + value + template.substring(ndx2 + endLen);
            len = template.length();
            i = ndx - startLen;
        }
        return result.toString();
    }
}

