/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.auth;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.facade.FacadeResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.auth.pojo.SecondAuthResult;
import kd.bos.login.cache.LoginCacheService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class OpSecondConfirmService {
    private static final String SECOND_CONFIRM_TYPE = "bas_auth_second_confirm";
    private static final String IS_SECOND_CONFIRM_KEY = "bas_auth_second_confirm_scheme";
    private static final String IS_SCHEME = "0";
    private LoginCacheService cacheService = new LoginCacheService("VERIFYINFO");
    private static Log logger = LogFactory.getLog(OpSecondConfirmService.class);
    private static final String USER_BIND_CONFIRM_TEXT = "userBindConfirmText";
    private static final String USER_BIND_PATH_TEXT = "userBindPathText";
    private static final String BOS_SVC_COMMON = "bos-svc-common";
    private static final String EMAIL = "email";
    private static final String VERIFYEMAIL_CONFIRM = "verifyemail_confirm";
    private static final String BOS_CONFIRM_BINDUSERINFO = "bos_confirm_binduserinfo";
    private static final String PHONE = "phone";
    private static final String VERIFYCODE_CONFIRM = "verifycode_confirm";
    private static final String PASSWORD_CONFIRM = "password_confirm";
    private static final String BOS_USER = "bos_user";
    private static final String BOS_CONFIRM_ORGENTITY = "bos_confirm_orgentity";
    public static final String BOS_CONFIRM_BINDUSER_M = "bos_confirm_binduser_m";

    public FacadeResult doFacadeResult(FormOperate formOperate) {
        DynamicObject dynamicObject = this.opConfirmAuth(formOperate);
        if (!ObjectUtils.isEmpty((Object)dynamicObject)) {
            FormShowParameter showConfirmForm = this.getShowConfirmForm(formOperate, dynamicObject, null);
            this.showConfirmForm(formOperate.getView(), null, showConfirmForm);
            FacadeResult facadeResult = new FacadeResult();
            facadeResult.setSuccess(true);
            facadeResult.setCode(6);
            return facadeResult;
        }
        return null;
    }

    private void showConfirmForm(IFormView billView, IFormView currentView, FormShowParameter showParameter) {
        billView.showForm(showParameter);
        if (currentView != null) {
            currentView.sendFormAction(billView);
        }
    }

    public SecondAuthResult doFacadeResult(FormOperate formOperate, IFormView currentView, Map<String, Object> params, boolean checkOperate) {
        DynamicObject dynamicObject = this.opConfirmAuth(formOperate, checkOperate);
        SecondAuthResult result = new SecondAuthResult();
        if (!ObjectUtils.isEmpty((Object)dynamicObject)) {
            this.showConfirmForm(formOperate.getView(), currentView, this.getShowConfirmForm(formOperate, dynamicObject, params));
            result.setSuccess(true);
            result.setNeedAuth(true);
            result.setSchemeId(dynamicObject.getString("id"));
            return result;
        }
        result.setSuccess(false);
        result.setErrorMsg("schemeId is null");
        result.setNeedAuth(false);
        return result;
    }

    public void clearType() {
        this.cacheService.remove(SECOND_CONFIRM_TYPE);
        this.cacheService.remove(IS_SECOND_CONFIRM_KEY);
    }

    public DynamicObject opConfirmAuth(FormOperate formOperate) {
        boolean need = this.isNeedAuth();
        if (need) {
            if (this.isVariableValue(formOperate)) {
                return null;
            }
            return this.needOpConfirmAuth(formOperate, true);
        }
        return null;
    }

    public DynamicObject opConfirmAuth(FormOperate formOperate, boolean checkOperate) {
        boolean need = this.isNeedAuth();
        if (need) {
            if (this.isVariableValue(formOperate)) {
                return null;
            }
            return this.needOpConfirmAuth(formOperate, checkOperate);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private FormShowParameter getShowConfirmForm(FormOperate formOperate, DynamicObject dynamicObject, Map<String, Object> params) {
        try {
            void var8_13;
            String verifyMode = dynamicObject.getString("verifymode");
            FormShowParameter lsp = new FormShowParameter();
            boolean isMobile = this.isMobileFormOp(formOperate);
            String string = verifyMode;
            int n = -1;
            switch (string.hashCode()) {
                case 48: {
                    if (!string.equals(IS_SCHEME)) break;
                    boolean bl = false;
                    break;
                }
                case 49: {
                    if (!string.equals("1")) break;
                    boolean bl = true;
                    break;
                }
                case 50: {
                    if (!string.equals("2")) break;
                    int n2 = 2;
                }
            }
            switch (var8_13) {
                case 0: {
                    this.showPasswordConfirm(formOperate, lsp, isMobile);
                    break;
                }
                case 1: {
                    this.showMessageConfirm(formOperate, lsp, isMobile);
                    break;
                }
                case 2: {
                    this.showEmailConfirm(formOperate, lsp, isMobile);
                    break;
                }
            }
            if (params != null) {
                for (Map.Entry entry : params.entrySet()) {
                    lsp.setCustomParam((String)entry.getKey(), entry.getValue());
                }
            }
            return lsp;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            formOperate.getView().showErrorNotification(ResManager.loadKDString((String)"\u6253\u5f00\u4e8c\u6b21\u8ba4\u8bc1\u754c\u9762\u5931\u8d25\u3002", (String)"OpSecondConfirmFacade_0", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
            return null;
        }
    }

    private boolean isMobileFormOp(FormOperate formOperate) {
        return formOperate.getView() instanceof IMobileView;
    }

    private void showEmailConfirm(FormOperate formOperate, FormShowParameter lsp, boolean isMobile) {
        DynamicObject userInfo = this.getUserInfo();
        if (StringUtils.isEmpty((String)userInfo.getString(EMAIL))) {
            String bindText = ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u9700\u4f7f\u7528\u90ae\u7bb1\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u60a8\u7684\u8eab\u4efd\uff0c\u8bf7\u7ed1\u5b9a\u90ae\u7bb1\u540e\u518d\u64cd\u4f5c\u3002", (String)"OpSecondConfirmFacade_3", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
            String pathText = ResManager.loadKDString((String)"\u8def\u5f84\uff1a\u70b9\u51fb\u3010\u5934\u50cf\u3011->\u3010\u4e2a\u4eba\u8bbe\u7f6e\u3011->\u3010\u8d26\u53f7\u4fe1\u606f\u3011->\u3010\u7ed1\u5b9a\u90ae\u7bb1\u3011", (String)"OpSecondConfirmFacade_4", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
            this.showBindInfo(formOperate, lsp, bindText, pathText, isMobile);
        } else {
            this.showFormById(isMobile ? "verifyemail_confirm_mobil" : VERIFYEMAIL_CONFIRM, formOperate, lsp);
        }
    }

    private void showBindInfo(FormOperate formOperate, FormShowParameter lsp, String bindText, String pathText, boolean isMobile) {
        lsp.setFormId(isMobile ? BOS_CONFIRM_BINDUSER_M : BOS_CONFIRM_BINDUSERINFO);
        lsp.setCustomParam(USER_BIND_CONFIRM_TEXT, (Object)bindText);
        lsp.setCustomParam(USER_BIND_PATH_TEXT, (Object)pathText);
        lsp.setShowTitle(false);
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        formOperate.getView().showForm(lsp);
    }

    private void showMessageConfirm(FormOperate formOperate, FormShowParameter lsp, boolean isMobile) {
        DynamicObject userInfo = this.getUserInfo();
        if (StringUtils.isEmpty((String)userInfo.getString(PHONE))) {
            String bindText = ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u9700\u4f7f\u7528\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u60a8\u7684\u8eab\u4efd\uff0c\u8bf7\u7ed1\u5b9a\u624b\u673a\u53f7\u540e\u518d\u64cd\u4f5c\u3002", (String)"OpSecondConfirmFacade_2", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
            String pathText = ResManager.loadKDString((String)"\u8def\u5f84\uff1a\u70b9\u51fb\u3010\u5934\u50cf\u3011->\u3010\u4e2a\u4eba\u8bbe\u7f6e\u3011->\u3010\u8d26\u53f7\u4fe1\u606f\u3011->\u3010\u7ed1\u5b9a\u624b\u673a\u53f7\u3011", (String)"OpSecondConfirmFacade_1", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
            this.showBindInfo(formOperate, lsp, bindText, pathText, isMobile);
        } else {
            this.showFormById(this.getFormNumber(VERIFYCODE_CONFIRM, isMobile), formOperate, lsp);
        }
    }

    private void showPasswordConfirm(FormOperate formOperate, FormShowParameter lsp, boolean isMobile) {
        this.showFormById(this.getFormNumber(PASSWORD_CONFIRM, isMobile), formOperate, lsp);
    }

    private String getFormNumber(String form, boolean isMobile) {
        return isMobile ? form + "_mobile" : form;
    }

    private void showFormById(String formId, FormOperate formOperate, FormShowParameter lsp) {
        lsp.setCustomParam("operationkey", (Object)formOperate.getOperateKey());
        lsp.setCustomParam("operateoption", (Object)SerializationUtils.toJsonString((Object)formOperate.getOption(), (boolean)true));
        String pageId = formOperate.getPageId();
        if (StringUtils.isEmpty((String)pageId)) {
            pageId = formOperate.getView().getPageId();
        }
        lsp.setCustomParam("pageid", (Object)pageId);
        lsp.setCustomParam("entityId", (Object)formOperate.getEntityId());
        lsp.setFormId(formId);
        lsp.setShowTitle(false);
        lsp.getOpenStyle().setShowType(ShowType.Modal);
    }

    private DynamicObject getUserInfo() {
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)BOS_USER);
        return user;
    }

    private void saveSchemeCache(Map<String, String> scheme) {
        this.cacheService.putMap(SECOND_CONFIRM_TYPE, scheme, 60, TimeUnit.DAYS);
        if (IS_SCHEME.equals(this.cacheService.get(IS_SECOND_CONFIRM_KEY))) {
            this.cacheService.remove(IS_SECOND_CONFIRM_KEY);
        }
    }

    private boolean containsKey() {
        return this.cacheService.contains(SECOND_CONFIRM_TYPE);
    }

    private String getValue(String key) {
        return this.cacheService.getMapValue(SECOND_CONFIRM_TYPE, key);
    }

    private void setFalseValue() {
        this.cacheService.put(IS_SECOND_CONFIRM_KEY, IS_SCHEME, 60, TimeUnit.DAYS);
    }

    private boolean isVariableValue(FormOperate formOperate) {
        try {
            OperateOption option = formOperate.getOption();
            return StringUtils.isNotEmpty((String)option.getVariableValue("confirmsource"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNeedAuth() {
        if (IS_SCHEME.equals(this.cacheService.get(IS_SECOND_CONFIRM_KEY))) {
            return false;
        }
        if (this.containsKey()) {
            return true;
        }
        Class<OpSecondConfirmService> clazz = OpSecondConfirmService.class;
        synchronized (OpSecondConfirmService.class) {
            if (IS_SCHEME.equals(this.cacheService.get(IS_SECOND_CONFIRM_KEY))) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            if (this.containsKey()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            this.opSaveCache();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.containsKey();
        }
    }

    private void opSaveCache() {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"operate_scheme", (String)"id,formnumber", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            this.setFalseValue();
            return;
        }
        HashMap<String, String> schemes = new HashMap<String, String>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            schemes.put(dynamicObject.getString("formnumber"), dynamicObject.getString("id"));
        }
        this.saveSchemeCache(schemes);
    }

    private DynamicObject needOpConfirmAuth(FormOperate formOperate, boolean checkOperate) {
        String pk = this.getValue(formOperate.getEntityId());
        if (StringUtils.isNotEmpty((String)pk)) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"operate_scheme", (String)"id,verifyoperate,verifymode,authonce", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(pk)).and("enable", "=", (Object)Boolean.TRUE)});
            if (dynamicObject == null) {
                this.clearType();
                return null;
            }
            if (!checkOperate) {
                return dynamicObject;
            }
            String operateKey = formOperate.getOperateKey();
            boolean confirmFlag = this.opConfirmOp(dynamicObject.getString("verifyoperate"), operateKey);
            if (confirmFlag) {
                return dynamicObject;
            }
        }
        return null;
    }

    private boolean opConfirmOp(String operate, String operateKey) {
        if (operate != null && operateKey != null && StringUtils.isNotEmpty((String)operate)) {
            String[] split;
            for (String s : split = operate.split(",")) {
                if (!operateKey.equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        LoginCacheService infoCacheService = new LoginCacheService("VERIFYINFO");
        infoCacheService.remove(SECOND_CONFIRM_TYPE);
        infoCacheService.remove(IS_SECOND_CONFIRM_KEY);
    }
}

