/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.auth.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.operate.Audit;
import kd.bos.form.IFormView;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.auth.OpSecondConfirmService;
import kd.bos.login.auth.pojo.SecondAuthParams;
import kd.bos.login.auth.pojo.SecondAuthResult;
import kd.bos.mvc.SessionManager;
import org.apache.commons.lang3.StringUtils;

public class OpSecondAuthServiceHelper {
    private static OpSecondConfirmService confirmService = new OpSecondConfirmService();
    private static Log logger = LogFactory.getLog(OpSecondAuthServiceHelper.class);

    public static SecondAuthResult invokeOperation(SecondAuthParams secondAuth) {
        IFormView view = SessionManager.getCurrent().getView(secondAuth.getPageId());
        SecondAuthResult result = new SecondAuthResult();
        result.setSuccess(false);
        if (view == null) {
            result.setErrorMsg("IFormView by billPageId is empty");
            return result;
        }
        try {
            OperateOption operationOption = OperateOption.create();
            Audit formOperate = new Audit();
            formOperate.setView(view);
            formOperate.setEntityId(secondAuth.getFormId());
            formOperate.setPageId(secondAuth.getPageId());
            formOperate.setOption(operationOption);
            formOperate.setOperateKey(secondAuth.getOperationKey());
            Map<String, Object> params = OpSecondAuthServiceHelper.initBusinessParams(secondAuth);
            return confirmService.doFacadeResult((FormOperate)formOperate, secondAuth.getCurrentView(), params, secondAuth.isCheckOperationKey());
        }
        catch (Exception e) {
            result.setErrorMsg(e.toString());
            return result;
        }
    }

    private static Map<String, Object> initBusinessParams(SecondAuthParams secondAuth) {
        String businessClass = secondAuth.getCallBackClass();
        String businessMethod = secondAuth.getCallBackMethod();
        if (StringUtils.isNotBlank((CharSequence)businessClass) && StringUtils.isNotBlank((CharSequence)businessMethod)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put("authCallBackClass", businessClass);
            hashMap.put("authCallBackMethod", businessMethod);
            hashMap.put("authCallBackParams", secondAuth.getCallBackParams());
            hashMap.put("billPageId", secondAuth.getPageId());
            return hashMap;
        }
        return null;
    }
}

