/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.cache;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LoginCacheService {
    private DistributeSessionlessCache cache;
    private static Log logger = LogFactory.getLog(LoginCacheService.class);

    public LoginCacheService(String region) {
        this.cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(region, new DistributeCacheHAPolicy(true, true));
    }

    public LoginCacheService() {
        this.cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("LOGIN_DATA", new DistributeCacheHAPolicy(true, true));
    }

    private String getAccountId() {
        try {
            return RequestContext.get().getAccountId();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return "";
        }
    }

    public void put(String key, String value, int timeout, TimeUnit timeUnit) {
        this.cache.put(this.getAccountId() + key, (Object)value, timeout, timeUnit);
    }

    public void put(String key, String value, int timeout) {
        this.cache.put(this.getAccountId() + key, (Object)value, timeout, TimeUnit.SECONDS);
    }

    public void put(String key, String value) {
        this.cache.put(this.getAccountId() + key, (Object)value);
    }

    public void expireAfter(String key, int time) {
        this.cache.expireAfter(this.getAccountId() + key, time);
    }

    public void expireAfter(String key, int time, TimeUnit timeUnit) {
        this.cache.expireAfter(this.getAccountId() + key, time, timeUnit);
    }

    public void put(String type, String key, String value, int timeout, TimeUnit timeUnit) {
        this.cache.put(this.getAccountId() + type, key, value, timeout, timeUnit);
    }

    public void putMap(String type, Map<String, String> value, int timeout, TimeUnit timeUnit) {
        this.cache.put(this.getAccountId() + type, value, timeout, timeUnit);
    }

    public void remove(String key) {
        this.cache.remove(this.getAccountId() + key);
    }

    public void remove(String type, String key) {
        this.cache.remove(this.getAccountId() + type, key);
    }

    public boolean contains(String key) {
        return this.cache.contains(this.getAccountId() + key);
    }

    public String get(String key) {
        return (String)this.cache.get(this.getAccountId() + key);
    }

    public String get(String type, String key) {
        return (String)this.cache.get(this.getAccountId() + type, key);
    }

    public String getMapValue(String type, String key) {
        return (String)this.cache.get(this.getAccountId() + type, key);
    }
}

