/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service.impl;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.encrypt.Encrypters;
import kd.bos.login.service.OnlineUserService;
import kd.bos.login.service.dto.MqSessionInfo;
import kd.bos.login.service.dto.SessionHistoryDTO;
import kd.bos.login.utils.DateUtils;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.util.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineUserServiceImpl
implements OnlineUserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineUserServiceImpl.class);

    public static SessionHistoryDTO saveSessionHistory(String sId, int timeOut) {
        SessionHistoryDTO historyDTO = new SessionHistoryDTO();
        String encode = Encrypters.encode((String)sId);
        historyDTO.setSessionId(encode);
        try {
            SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sId);
            Map dynamicObject = sessionDAO.getAttributesAsMap(new String[]{"modifierId", "language", "userId", "userName", "userOpenId", "orgId", "userType", "loginTime", "yzjAppId", "yzjAppTicket", "loginIP", "accountId", "uid", "accCompanyId", "kdCsrfToken", "api3rdAppId", "api3rdAppNum", "bizPartnerId", "loginOrg", "client"});
            MqSessionInfo sessionInfo = new MqSessionInfo();
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date loginTime = dateFormat.parse((String)dynamicObject.get("loginTime"));
            Date expDate = DateUtils.plusSecondsWithDate((Date)loginTime, (int)timeOut);
            sessionInfo.setLanguage((String)dynamicObject.get("language"));
            sessionInfo.setCreateTime(date);
            sessionInfo.setModifyTime(date);
            sessionInfo.setModifierId((String)dynamicObject.get("modifierId"));
            sessionInfo.setUserid((String)dynamicObject.get("userId"));
            sessionInfo.setUsername((String)dynamicObject.get("userName"));
            sessionInfo.setUserOpenid((String)dynamicObject.get("userOpenId"));
            sessionInfo.setUserType((String)dynamicObject.get("userType"));
            sessionInfo.setOrgId((String)dynamicObject.get("orgId"));
            sessionInfo.setLoginTime(loginTime);
            sessionInfo.setYzjAppId((String)dynamicObject.get("yzjAppId"));
            sessionInfo.setLoginIp((String)dynamicObject.get("loginIP"));
            sessionInfo.setYzjAppTicket((String)dynamicObject.get("yzjAppTicket"));
            sessionInfo.setLoginOrg((String)dynamicObject.get("loginOrg"));
            sessionInfo.setClient((String)dynamicObject.get("client"));
            sessionInfo.setAccCompanyId((String)dynamicObject.get("accCompanyId"));
            sessionInfo.setKdcsrfToken((String)dynamicObject.get("kdCsrfToken"));
            sessionInfo.setApi3rdAppId((String)dynamicObject.get("api3rdAppId"));
            sessionInfo.setApi3rdAppNum((String)dynamicObject.get("api3rdAppNum"));
            sessionInfo.setBizPartnerId((String)dynamicObject.get("bizPartnerId"));
            sessionInfo.setExpiredTime(expDate);
            sessionInfo.setSessionId(encode);
            sessionInfo.setDatetime(OnlineUserServiceImpl.getTime());
            historyDTO.setSessionInfo(sessionInfo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return historyDTO;
    }

    @Override
    public boolean login(String sessionId, String _type, int timeOut) {
        SessionHistoryDTO historyDTO = OnlineUserServiceImpl.saveSessionHistory(sessionId, timeOut);
        historyDTO.setType(_type);
        historyDTO.setLogin(true);
        historyDTO.setLogout(false);
        OnlineUserServiceImpl.sendMsg(historyDTO);
        return true;
    }

    @Override
    public boolean logout(String sessionId) {
        SessionHistoryDTO historyDTO = new SessionHistoryDTO();
        historyDTO.setSessionId(Encrypters.encode((String)sessionId));
        historyDTO.setLogout(true);
        historyDTO.setLogin(false);
        OnlineUserServiceImpl.sendMsg(historyDTO);
        return true;
    }

    private static Long getTime() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return Long.valueOf(format.format(date));
    }

    public static void sendMsg(SessionHistoryDTO historyDTO) {
        try (MessagePublisher publisher = MQFactory.get().createSimplePublisher("bos", "svc_onlineuser_queue");){
            if (historyDTO.isLogin()) {
                historyDTO.setLoginTime(new Date());
                historyDTO.setLogin(true);
            } else if (historyDTO.isLogout()) {
                historyDTO.setLogoutTime(new Date());
                historyDTO.setLogout(true);
            }
            String toString = JSONUtils.toString((Object)historyDTO);
            publisher.publish(toString);
        }
    }
}

