/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.cache.PromptWordCacheNew;
import kd.bos.instance.Instance;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.service.OnlineUserService;
import kd.bos.login.service.SessionComService;
import kd.bos.login.service.dto.SessionUserInfo;
import kd.bos.login.service.impl.OnlineUserServiceImpl;
import kd.bos.login.util.SessionComUtil;
import kd.bos.login.util.cache.CacheLoginUtils;
import kd.bos.login.utils.DateUtils;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionManager;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class SessionComServiceImpl
implements SessionComService {
    private static final String THIRD_APP = "THIRD_APP";
    private static final String CLIENT_TYPE = "CLIENT_TYPE";
    private static final String THIRD_APP_TYPE = "THIRD_APP_TYPE";
    private static final String BOS_SVC_COMMON = "bos-svc-common";
    private OnlineUserService onlineUserService = new OnlineUserServiceImpl();
    private static Log logger = LogFactory.getLog(SessionComServiceImpl.class);

    @Override
    public boolean removeSessionByUserId(List<String> userIds) {
        boolean flag = false;
        try {
            List<String> keys = this.getCacheKeyByUser(userIds);
            List<String> list = this.getCacheList(keys);
            for (String userInfo : list) {
                Map cast = (Map)JSONUtils.cast((String)userInfo, Map.class);
                String sessionId = (String)cast.get("sessionId");
                SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
                Lang lang = StringUtils.isEmpty((String)sessionDAO.getAttribute("language")) ? Lang.defaultLang() : Lang.valueOf((String)sessionDAO.getAttribute("language"));
                String loadI18nString = ResManager.loadKDString((Lang)lang, (String)"\u60a8\u7684\u8d26\u6237\u5df2\u4e8e%s\u88ab\u7ba1\u7406\u5458\u7981\u7528\uff0c\u88ab\u8feb\u4e0b\u7ebf\u3002\u5982\u9700\u5e2e\u52a9\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SessionComService_1", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
                if (sessionId == null) continue;
                SessionManager.removeSession((String)sessionId);
                this.setLoginExitMessage(sessionId, String.format(loadI18nString, DateUtils.getDateTime()), false, 6000);
                this.onlineUserService.logout(sessionId);
            }
            this.removeList(keys);
            flag = true;
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        return flag;
    }

    private void removeList(List<String> keys) {
        for (String key : keys) {
            CacheLoginUtils.removeList(key);
        }
    }

    private List<String> getCacheList(List<String> keys) {
        ArrayList<String> values = new ArrayList<String>(512);
        for (String key : keys) {
            String[] list = CacheLoginUtils.getList(key);
            if (null == list || list.length <= 0) continue;
            values.addAll(Arrays.asList(list));
        }
        return values;
    }

    private String loadI18nString(String sessionId, String description, String resourceID, String systemType, Object ... args) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        Lang lang = StringUtils.isEmpty((String)sessionDAO.getAttribute("language")) ? Lang.defaultLang() : Lang.valueOf((String)sessionDAO.getAttribute("language"));
        String promptWord = PromptWordCacheNew.getPromptWord((String)description, (String)resourceID, (Lang)lang, (String)systemType, (Object[])args);
        return promptWord;
    }

    @Override
    public boolean removeSessionByUserId(List<String> userIds, String msg, boolean showModifyPwd) {
        boolean flag = false;
        try {
            List<String> keys = this.getCacheKeyByUser(userIds);
            List<String> list = this.getCacheList(keys);
            for (String userInfo : list) {
                Map cast = (Map)JSONUtils.cast((String)userInfo, Map.class);
                String sessionId = (String)cast.get("sessionId");
                if (sessionId == null) continue;
                SessionManager.removeSession((String)sessionId);
                this.setLoginExitMessage(sessionId, msg, showModifyPwd, 6000);
                this.onlineUserService.logout(sessionId);
            }
            this.removeList(keys);
            flag = true;
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        return flag;
    }

    private List<String> getCacheKeyByUser(List<String> userIds) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        List<SessionUserInfo> userInfos = userIds.stream().map(v -> {
            SessionUserInfo sessionInfo = new SessionUserInfo();
            sessionInfo.setTenantId(tenantId);
            sessionInfo.setAccountId(accountId);
            sessionInfo.setUserId((String)v);
            return sessionInfo;
        }).collect(Collectors.toList());
        return SessionComUtil.getCacheKey(userInfos);
    }

    @Override
    public boolean removeSessionByClient(SessionUserInfo sessionInfo, String client) {
        boolean flag = false;
        try {
            Map<String, Map<String, String>> stringMap = SessionComUtil.getClients(CLIENT_TYPE);
            Set<String> clients = stringMap.keySet();
            if (client.equals(THIRD_APP)) {
                logger.info(clients.toString());
                List<String> thirdAppType = this.getThirdAppType(clients, false);
                for (String s : thirdAppType) {
                    this.removeSession(sessionInfo, s);
                }
                flag = true;
            } else if (this.checkClient(client)) {
                this.removeSession(sessionInfo, client);
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return flag;
    }

    private boolean checkClient(String client) {
        List<String> clients = this.getAllClients();
        return clients.contains(client);
    }

    private void removeSession(SessionUserInfo sessionInfo, String client) throws IOException {
        String notifyMessage = String.format(ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u6237\u5df2\u4e8e%s\u88ab\u7ba1\u7406\u5458\u7981\u7528\uff0c\u88ab\u8feb\u4e0b\u7ebf\u3002\u5982\u9700\u5e2e\u52a9\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SessionComService_1", (String)BOS_SVC_COMMON, (Object[])new Object[0]), DateUtils.getDateTime());
        String cacheKey = SessionComUtil.getCacheKey(sessionInfo);
        String[] list = CacheLoginUtils.getList(cacheKey);
        for (int i = 0; i < list.length; ++i) {
            String userInfo = list[i];
            Map cast = (Map)JSONUtils.cast((String)userInfo, Map.class);
            String sessionId = (String)cast.get("sessionId");
            if (sessionId == null || !client.equals(cast.get("clientType"))) continue;
            SessionManager.removeSession((String)sessionId);
            this.setLoginExitMessage(sessionId, notifyMessage, false, 6000);
            this.onlineUserService.logout(sessionId);
            CacheLoginUtils.removeListObject(cacheKey, i);
        }
    }

    private List<String> getAllClients() {
        Set<String> clientType = SessionComUtil.getClients(CLIENT_TYPE).keySet();
        return this.getThirdAppType(clientType, true);
    }

    private List<String> getThirdAppType(Set<String> clientType, boolean contains) {
        Set<String> thirdAppType = SessionComUtil.getClients(THIRD_APP_TYPE).keySet();
        ArrayList<String> returnValue = new ArrayList<String>(24);
        for (String s : clientType) {
            for (String s1 : thirdAppType) {
                returnValue.add(s + "-" + s1);
            }
        }
        if (contains) {
            returnValue.addAll(clientType);
        }
        return returnValue;
    }

    private void setLoginExitMessage(String sessionId, String msg, boolean showModifyPwd, int timeOut) {
        if (showModifyPwd) {
            CacheLoginData.setAttribute((String)"", (String)this.getExistsCachkey(sessionId), (String)msg, (int)timeOut);
        } else {
            CacheLoginData.setAttribute((String)"userDisable", (String)this.getExistsCachkey(sessionId), (String)msg, (int)timeOut);
        }
    }

    private String getExistsCachkey(String keyId) {
        String sessionId = null;
        if (keyId != null) {
            sessionId = Instance.getClusterName() + "_" + keyId;
        }
        return sessionId;
    }

    @Override
    public boolean removeSessionBySessionId(List<SessionInfo> sessionInfoList, String msg) {
        boolean flag = false;
        try {
            ArrayList<String> userIds = new ArrayList<String>(8);
            for (SessionInfo sessionInfo : sessionInfoList) {
                String sessionId = sessionInfo.getGloableSessionId();
                if (StringUtils.isNotEmpty((String)sessionId)) {
                    SessionManager.removeSession((String)sessionId);
                    this.setLoginExitMessage(sessionId, msg, false, 6000);
                    this.onlineUserService.logout(sessionId);
                }
                if (!StringUtils.isNotEmpty((String)sessionInfo.getUserId())) continue;
                userIds.add(sessionInfo.getUserId());
            }
            List<String> keys = this.getCacheKeyByUser(userIds);
            this.removeList(keys);
            flag = true;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return flag;
    }
}

