/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.util;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DBRoute;
import kd.bos.login.service.dto.SessionUserInfo;
import kd.bos.session.service.DBUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class SessionComUtil {
    public static List<String> getCacheKey(List<SessionUserInfo> sessionInfos) {
        List<String> keys = sessionInfos.stream().map(sessionInfo -> {
            String key = null;
            if (sessionInfo.getUserId() != null) {
                key = sessionInfo.getTenantId() + sessionInfo.getAccountId() + "_" + sessionInfo.getUserId();
            }
            return key;
        }).filter(v -> StringUtils.isNotEmpty((String)v)).collect(Collectors.toList());
        return keys;
    }

    public static String getCacheKey(SessionUserInfo sessionInfo) {
        String sessionId = null;
        if (sessionInfo.getUserId() != null) {
            sessionId = sessionInfo.getTenantId() + sessionInfo.getAccountId() + "_" + sessionInfo.getUserId();
        }
        return sessionId;
    }

    public static Map<String, Map<String, String>> getClients(String type) {
        String sql = "select fid, fparam_key,fparam_value  from T_BAS_DEFAULT_PARAMS where fparam_key = ?";
        Map query = (Map)DBUtils.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{type}, res -> {
            Map clients = null;
            while (res.next()) {
                if (!StringUtils.isNotEmpty((String)res.getString(3))) continue;
                String value = res.getString(3);
                clients = (Map)JSONUtils.cast((String)value, Map.class);
            }
            return clients;
        });
        return query;
    }
}

