/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.util;

import java.util.Collections;
import java.util.Map;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.param.CustomParam;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemParamsUtils {
    private static final Logger logger = LoggerFactory.getLogger(SystemParamsUtils.class);

    public static boolean getBooleanCustomParam(String key) {
        String customParam = SystemParamsUtils.getCustomParam(key);
        return Boolean.parseBoolean(customParam) || "1".equals(customParam);
    }

    public static String getCustomParam(String key) {
        Map<String, String> params = SystemParamsUtils.getCustomParams(key);
        if (params.isEmpty()) {
            return null;
        }
        return params.get(key);
    }

    public static Map<String, String> getCustomParams(String ... keys) {
        try {
            CustomParam customParam = SystemParamsUtils.initParam(keys);
            if (!ObjectUtils.isEmpty((Object)customParam)) {
                return SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
            }
        }
        catch (Exception e) {
            logger.info(e.toString());
        }
        return Collections.emptyMap();
    }

    private static CustomParam initParam(String ... keys) {
        if (keys != null && keys.length > 0) {
            CustomParam customParam = new CustomParam();
            for (String key : keys) {
                customParam.getSearchKeySet().add(key);
            }
            return customParam;
        }
        return null;
    }
}

