/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.cache.LoginCacheService;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import org.apache.commons.lang3.StringUtils;

public class ThirdSsoAuthUtils {
    private static Log logger = LogFactory.getLog(ThirdSsoAuthUtils.class);
    private static LoginCacheService cacheService;

    public static LoginCacheService getThirdSsoAuthCacheService() {
        if (cacheService == null) {
            cacheService = new LoginCacheService();
        }
        return cacheService;
    }

    public Map<String, Object> generateRedirectURL(String thirdAppId, String redirectUri, String sessionId) {
        Map<String, Object> result = new HashMap<String, String>(8);
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        if (sessionDAO == null) {
            logger.info("session is invalid");
            result.put("message", "session is invalid");
            return result;
        }
        String userId = sessionDAO.getAttribute("userId");
        result = this.generateAuthorizaCode(userId);
        if (result != null && "0".equals(result.get("errorCode"))) {
            redirectUri = redirectUri.contains("?") ? redirectUri + "&code=" : redirectUri + "?code=";
            redirectUri = redirectUri + result.get("code");
            result.put("redirectUri", (String)((Object)redirectUri));
        }
        return result;
    }

    public Map<String, Object> generateAuthorizaCode(String userId) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        if (StringUtils.isBlank((CharSequence)userId)) {
            logger.info("session is invalid");
            result.put("message", "session is invalid");
            return result;
        }
        String code = kd.bos.util.StringUtils.randomWord((int)64);
        ThirdSsoAuthUtils.getThirdSsoAuthCacheService().put(code, userId, 300, TimeUnit.SECONDS);
        logger.info(code + " is generate");
        result.put("errorCode", "0");
        result.put("code", code);
        return result;
    }
}

