/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.map;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxLink;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.map.MapServiceEnum;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.HttpClientUtils;

public class MapServiceConfigPlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(MapServiceConfigPlugin.class);
    private static final String ID = "id";
    private static final String DEFAULT_CONFIG_AP = "defaultpanelap";
    private static final String AMAP_CONFIG_AP = "amapconfigap";
    private static final String BAIDU_CONFIG_AP = "baiduconfigap";
    private static final String GOOGLEMAP_CONFIG_AP = "googleconfigap";
    private static final String GOOGLELABEL = "googlelabel";
    private static final String CONNECT_TEST = "connect_test";
    private static final String RESTRICTION_FORM = "restriction_form";
    private static final String API_NAME_DESC = "api_name_desc";
    private static final String TYPE_DESC = "type_desc";
    private static final String USE_DESC = "use_desc";
    private static final String LIMIT_DESC = "limit_desc";
    private static final String BOS_SVC_COMMON = "bos-svc-common";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONNECT_TEST});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BaseShowParameter baseShowParameter = (BaseShowParameter)e.getFormShowParameter();
        try {
            DynamicObject config = BusinessDataServiceHelper.loadSingle((Object)1738629370681140224L, (String)"bos_mapservice_config");
            if (config != null) {
                baseShowParameter.setStatus(OperationStatus.EDIT);
                baseShowParameter.setBillStatus(BillOperationStatus.EDIT);
                baseShowParameter.setPkId((Object)1738629370681140224L);
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.resetFormStyle();
        this.initRestrictionFormDesc();
    }

    private void initRestrictionFormDesc() {
        this.getModel().batchCreateNewEntryRow(RESTRICTION_FORM, 4);
        this.getModel().setValue(API_NAME_DESC, (Object)ResManager.loadKDString((String)"\u5730\u7406\u7f16\u7801", (String)"MapServiceConfigPlugin_8", (String)BOS_SVC_COMMON, (Object[])new Object[0]), 0);
        this.getModel().setValue(TYPE_DESC, (Object)"Web API", 0);
        this.getModel().setValue(USE_DESC, (Object)ResManager.loadKDString((String)"\u670d\u52a1\u7aef\u63d2\u4ef6\u8c03\u7528\u5730\u56fe\u7ec4\u4ef6\u63a5\u53e3\uff0c\u7ec4\u4ef6\u4f7f\u7528\u8be5API\u5c06\u4f20\u8fc7\u6765\u7684\u8be6\u7ec6\u5730\u5740\u8f6c\u6362\u4e3a\u7ecf\u7eac\u5ea6\u4fe1\u606f\uff0c\u4ece\u800c\u5728\u5730\u56fe\u4e0a\u5c55\u793a\u3002", (String)"MapServiceConfigPlugin_12", (String)BOS_SVC_COMMON, (Object[])new Object[0]), 0);
        this.getModel().setValue(API_NAME_DESC, (Object)ResManager.loadKDString((String)"\u9006\u5730\u7406\u7f16\u7801", (String)"MapServiceConfigPlugin_9", (String)BOS_SVC_COMMON, (Object[])new Object[0]), 1);
        this.getModel().setValue(TYPE_DESC, (Object)"Web API", 1);
        this.getModel().setValue(USE_DESC, (Object)ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u81ea\u52a8\u5b9a\u4f4d\u7b49\u529f\u80fd\uff0c\u4f7f\u7528\u8be5API\u5c06\u7ecf\u7eac\u5ea6\u4fe1\u606f\u8f6c\u6362\u4e3a\u8be6\u7ec6\u5730\u5740(\u5305\u62ec\u7701\u4efd\u7b49\u5185\u5bb9)\u53d1\u9001\u7ed9\u670d\u52a1\u7aef\u4f7f\u7528\u3002", (String)"MapServiceConfigPlugin_13", (String)BOS_SVC_COMMON, (Object[])new Object[0]), 1);
        this.getModel().setValue(API_NAME_DESC, (Object)ResManager.loadKDString((String)"\u5750\u6807\u8f6c\u6362", (String)"MapServiceConfigPlugin_10", (String)BOS_SVC_COMMON, (Object[])new Object[0]), 2);
        this.getModel().setValue(TYPE_DESC, (Object)"Web API", 2);
        this.getModel().setValue(USE_DESC, (Object)ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u81ea\u52a8\u5b9a\u4f4d\u7b49\u529f\u80fd\uff0c\u4f7f\u7528\u8be5API\u5c06\u7ecf\u7eac\u5ea6\u4fe1\u606f\u8f6c\u4e3a\u5730\u56fe\u7ec4\u4ef6\u652f\u6301\u7684\u5750\u6807\u7cfb\u4fe1\u606f\uff0c\u4fdd\u8bc1\u5b9a\u4f4d\u5730\u5740\u7684\u51c6\u786e\u6027\u3002", (String)"MapServiceConfigPlugin_14", (String)BOS_SVC_COMMON, (Object[])new Object[0]), 2);
        this.getModel().setValue(API_NAME_DESC, (Object)ResManager.loadKDString((String)"JS\u5b9a\u4f4d", (String)"MapServiceConfigPlugin_11", (String)BOS_SVC_COMMON, (Object[])new Object[0]), 3);
        this.getModel().setValue(TYPE_DESC, (Object)"JS API", 3);
        this.getModel().setValue(USE_DESC, (Object)ResManager.loadKDString((String)"\u5730\u56fe\u7ec4\u4ef6\u521d\u59cb\u5316\uff0c\u5982\u679c\u670d\u52a1\u7aef\u672a\u6307\u5b9a\u5730\u56fe\u9ed8\u8ba4\u5c55\u793a\u4f4d\u7f6e\uff0c\u5219\u5730\u56fe\u4f1a\u4f7f\u7528\u8be5API\u505a\u4e00\u6b21\u81ea\u52a8\u5b9a\u4f4d\u3002", (String)"MapServiceConfigPlugin_15", (String)BOS_SVC_COMMON, (Object[])new Object[0]), 3);
        Label label = (Label)this.getControl(GOOGLELABEL);
        label.setText(ResManager.loadKDString((String)"2.\u8c37\u6b4c\u5730\u56fe\u670d\u52a1\u9762\u5411\u5168\u7403\uff0c\u5c24\u5176\u63a8\u8350\u6d77\u5916\u5ba2\u6237\u4f7f\u7528\uff08\u9274\u4e8e\u5730\u533a\u653f\u7b56\u4e0e\u6cd5\u89c4\u5b58\u5728\u5dee\u5f02\uff0c\u8c37\u6b4c\u5730\u56fe\u5728\u4e2d\u56fd\u5927\u9646\u5730\u533a\u7684\u4f7f\u7528\u53ef\u80fd\u53d7\u5230\u4e00\u5b9a\u9650\u5236\uff09\u3002", (String)"MapServiceConfigPlugin_20", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"mapservice")) {
            this.resetFormStyle();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)control.getKey(), (CharSequence)CONNECT_TEST)) {
            IDataModel model = this.getModel();
            String mapService = (String)model.getValue("mapservice");
            if (StringUtils.equals((CharSequence)mapService, (CharSequence)MapServiceEnum.AMAP.getMapKey())) {
                String amapApiKey = (String)model.getValue("amap_apikey");
                if (StringUtils.isBlank((CharSequence)amapApiKey)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165Web\u670d\u52a1API\u5bc6\u94a5\u3002", (String)"MapServiceConfigPlugin_0", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
                    return;
                }
                this.testAMapConnect(amapApiKey);
                return;
            }
            if (StringUtils.equals((CharSequence)mapService, (CharSequence)MapServiceEnum.BAIDUMAP.getMapKey())) {
                String baiduServiceKey = (String)model.getValue("baidu_serverkey");
                if (StringUtils.isBlank((CharSequence)baiduServiceKey)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u670d\u52a1\u7aef\u5bc6\u94a5\u3002", (String)"MapServiceConfigPlugin_1", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
                    return;
                }
                this.testBaiduMapConnect(baiduServiceKey);
            }
            if (StringUtils.equals((CharSequence)mapService, (CharSequence)MapServiceEnum.GOOGLEMAP.getMapKey())) {
                String googleSecretKey = (String)model.getValue("google_secret_key");
                if (StringUtils.isBlank((CharSequence)googleSecretKey)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5bc6\u94a5\u3002", (String)"MapServiceConfigPlugin_17", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
                    return;
                }
                this.testGoogleMapConnect(googleSecretKey);
            }
        }
    }

    private void testAMapConnect(String key) {
        try {
            HashMap<String, String> body = new HashMap<String, String>(4);
            body.put("address", "china");
            body.put("output", "json");
            body.put("key", key);
            String result = HttpClientUtils.get((String)"https://restapi.amap.com/v3/geocode/geo", body);
            log.info("\u9ad8\u5fb7\u5730\u56fe\u8fde\u63a5\u6d4b\u8bd5\u7ed3\u679c\uff1a" + result);
            if (StringUtils.isBlank((CharSequence)result)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u201cWeb\u670d\u52a1API\u5bc6\u94a5\u201d\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"MapServiceConfigPlugin_2", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
                return;
            }
            Map connectResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            Object status = connectResult.get("status");
            Object info = connectResult.get("info");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)String.valueOf(status))) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u6b63\u5e38\uff0c\u8bf7\u4fdd\u5b58\u914d\u7f6e\u4f7f\u7528\u5730\u56fe\u670d\u52a1\u3002", (String)"MapServiceConfigPlugin_3", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
                return;
            }
            MessageBoxLink messageBoxLink = new MessageBoxLink().setIndex(0).setText(ResManager.loadKDString((String)"\u8bf7\u53c2\u8003\u201c\u9519\u8bef\u7801\u8bf4\u660e\u201d\u90e8\u5206\u5185\u5bb9", (String)"MapServiceConfigPlugin_5", (String)BOS_SVC_COMMON, (Object[])new Object[0])).setUrl("https://vip.kingdee.com/article/508218882893572352");
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u201cWeb\u670d\u52a1API\u5bc6\u94a5\u201d\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff0c\u9519\u8bef\u7801\uff1a%s\u3002#{0}", (String)"MapServiceConfigPlugin_4", (String)BOS_SVC_COMMON, (Object[])new Object[0]), info), Collections.singletonList(messageBoxLink), new ConfirmCallBackListener());
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u201cWeb\u670d\u52a1API\u5bc6\u94a5\u201d\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"MapServiceConfigPlugin_2", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
            log.error("\u9ad8\u5fb7\u5730\u56fe\u670d\u52a1\u8fde\u63a5\u6d4b\u8bd5\u51fa\u9519", (Throwable)e);
        }
    }

    private void testBaiduMapConnect(String key) {
        try {
            HashMap<String, String> body = new HashMap<String, String>(4);
            body.put("address", "china");
            body.put("output", "json");
            body.put("ak", key);
            String result = HttpClientUtils.get((String)"https://api.map.baidu.com/geocoding/v3/", body);
            log.info("\u767e\u5ea6\u5730\u56fe\u8fde\u63a5\u6d4b\u8bd5\u7ed3\u679c\uff1a" + result);
            if (StringUtils.isBlank((CharSequence)result)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u201c\u670d\u52a1\u7aef\u5bc6\u94a5\u201d\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"MapServiceConfigPlugin_6", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
                return;
            }
            Map connectResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            Object status = connectResult.get("status");
            if (StringUtils.equals((CharSequence)"0", (CharSequence)String.valueOf(status))) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u6b63\u5e38\uff0c\u8bf7\u4fdd\u5b58\u914d\u7f6e\u4f7f\u7528\u5730\u56fe\u670d\u52a1\u3002", (String)"MapServiceConfigPlugin_3", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
                return;
            }
            MessageBoxLink messageBoxLink = new MessageBoxLink().setIndex(0).setText(ResManager.loadKDString((String)"\u8bf7\u53c2\u8003\u201c\u9519\u8bef\u7801\u8bf4\u660e\u201d\u90e8\u5206\u5185\u5bb9", (String)"MapServiceConfigPlugin_5", (String)BOS_SVC_COMMON, (Object[])new Object[0])).setUrl("https://vip.kingdee.com/article/508218882893572352");
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u201c\u670d\u52a1\u7aef\u5bc6\u94a5\u201d\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff0c\u9519\u8bef\u7801\uff1a%s\u3002#{0}", (String)"MapServiceConfigPlugin_7", (String)BOS_SVC_COMMON, (Object[])new Object[0]), status), Collections.singletonList(messageBoxLink), new ConfirmCallBackListener());
        }
        catch (Exception e) {
            log.error("\u767e\u5ea6\u5730\u56fe\u670d\u52a1\u8fde\u63a5\u6d4b\u8bd5\u51fa\u9519", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u201c\u670d\u52a1\u7aef\u5bc6\u94a5\u201d\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"MapServiceConfigPlugin_6", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
        }
    }

    private void testGoogleMapConnect(String key) {
        try {
            String result = HttpClientUtils.get((String)("https://maps.googleapis.com/maps/api/geocode/json?address=1600+Amphitheatre+Parkway,+Mountain+View,+CA&key=" + key), (int)3000, (int)3000);
            log.info("\u8c37\u6b4c\u5730\u56fe\u8fde\u63a5\u6d4b\u8bd5\u7ed3\u679c\uff1a" + result);
            if (StringUtils.isBlank((CharSequence)result)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u201c\u5bc6\u94a5\u201d\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"MapServiceConfigPlugin_16", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
                return;
            }
            Map connectResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            Object status = connectResult.get("status");
            if (StringUtils.equals((CharSequence)"OK", (CharSequence)String.valueOf(status))) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u6b63\u5e38\uff0c\u8bf7\u4fdd\u5b58\u914d\u7f6e\u4f7f\u7528\u5730\u56fe\u670d\u52a1\u3002", (String)"MapServiceConfigPlugin_3", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
                return;
            }
            log.info("kd.bos.map.MapServiceConfigPlugin.testGoogleMapConnect\uff0cconnectResult\uff1a" + result);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u201c\u5bc6\u94a5\u201d\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"MapServiceConfigPlugin_18", (String)BOS_SVC_COMMON, (Object[])new Object[0]), new Object[0]));
        }
        catch (Exception e) {
            if (e.getMessage().contains("connect timed out")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u8d85\u65f6\u3002", (String)"MapServiceConfigPlugin_19", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
            }
            log.error("\u8c37\u6b4c\u5730\u56fe\u670d\u52a1\u8fde\u63a5\u6d4b\u8bd5\u51fa\u9519", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u201c\u5bc6\u94a5\u201d\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"MapServiceConfigPlugin_18", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            this.getModel().setValue(ID, (Object)1738629370681140224L);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") && operationResult.isSuccess()) {
            this.initRestrictionFormDesc();
        }
    }

    private void resetFormStyle() {
        boolean isGoogleMap;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String mapService = (String)model.getValue("mapservice");
        boolean isDefault = StringUtils.equals((CharSequence)mapService, (CharSequence)MapServiceEnum.DEFAULT.getMapKey());
        if (isDefault) {
            view.setVisible(Boolean.TRUE, new String[]{DEFAULT_CONFIG_AP});
            view.setVisible(Boolean.FALSE, new String[]{AMAP_CONFIG_AP, BAIDU_CONFIG_AP, CONNECT_TEST, GOOGLEMAP_CONFIG_AP});
            return;
        }
        boolean isAMap = StringUtils.equals((CharSequence)mapService, (CharSequence)MapServiceEnum.AMAP.getMapKey());
        if (isAMap) {
            view.setVisible(Boolean.TRUE, new String[]{AMAP_CONFIG_AP, CONNECT_TEST});
            view.setVisible(Boolean.FALSE, new String[]{DEFAULT_CONFIG_AP, BAIDU_CONFIG_AP, GOOGLEMAP_CONFIG_AP});
            return;
        }
        boolean isBaiduMap = StringUtils.equals((CharSequence)mapService, (CharSequence)MapServiceEnum.BAIDUMAP.getMapKey());
        if (isBaiduMap) {
            view.setVisible(Boolean.TRUE, new String[]{BAIDU_CONFIG_AP, CONNECT_TEST});
            view.setVisible(Boolean.FALSE, new String[]{DEFAULT_CONFIG_AP, AMAP_CONFIG_AP, GOOGLEMAP_CONFIG_AP});
        }
        if (isGoogleMap = StringUtils.equals((CharSequence)mapService, (CharSequence)MapServiceEnum.GOOGLEMAP.getMapKey())) {
            view.setVisible(Boolean.TRUE, new String[]{GOOGLEMAP_CONFIG_AP});
            view.setVisible(Boolean.FALSE, new String[]{DEFAULT_CONFIG_AP, BAIDU_CONFIG_AP, AMAP_CONFIG_AP, CONNECT_TEST});
        }
    }
}

