/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.upgradeservice;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.upgradeservice.dto.AppAndMenuData;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class PortalSchemeCardUpgradeAbstract
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PortalSchemeCardUpgradeAbstract.class);
    private static final String CACHE_SEL_APPID = "cache_sel_appId";
    private static final String CACHE_SEL_MENUID = "cache_sel_menuId";
    private static final String LAUNCHTYPE = "launchType";
    private static final String LAUNCHTYPE_MENU = "launchType_menu";
    private static final String CONFIG = "config";

    protected abstract Map<String, AppAndMenuData> buildTransformMenuMap();

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.info("PortalSchemeCardUpgradeAbstract.start");
        UpgradeResult result = new UpgradeResult();
        Map<String, AppAndMenuData> transformMenuMap = this.buildTransformMenuMap();
        if (transformMenuMap == null || transformMenuMap.size() == 0) {
            logger.info("transformMenuMap is empty");
            return result;
        }
        List<Object[]> updateCardParamsList = this.getCardConfigParams(transformMenuMap);
        List<Object[]> updateMarkMenuSqlParamsList = this.getMarkMenuParamsList(transformMenuMap);
        try (TXHandle txHandle = TX.required();){
            try {
                if (updateCardParamsList.size() > 0) {
                    String updateCardConfigSql = "update t_bas_cardconfig set fconfig = ? where fid = ?";
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)updateCardConfigSql, updateCardParamsList);
                }
                if (updateMarkMenuSqlParamsList.size() > 0) {
                    String updateUserMarkSql = "update t_bas_usermarkedmenus set fappid = ?, fmenuid = ? where fmenuid = ?";
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)updateUserMarkSql, updateMarkMenuSqlParamsList);
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                logger.error("PortalSchemeCardUpgradeAbstract execute error", (Throwable)e);
                throw new KDException(new ErrorCode("fail", "update fail," + e.getMessage()), new Object[0]);
            }
        }
        result.setSuccess(true);
        result.setLog(String.format("PortalSchemeCardUpgradeAbstract data update success, updateCardSqlList:%s,updateMarkMenuSqlList:%s", updateCardParamsList.size(), updateMarkMenuSqlParamsList.size()));
        logger.info("PortalSchemeCardUpgradeAbstract.end");
        return result;
    }

    @NotNull
    private List<Object[]> getCardConfigParams(Map<String, AppAndMenuData> transformMenuMap) {
        ArrayList<Object[]> updateCardParamsList;
        String sql = "select fid,ftype,fconfig from t_bas_cardconfig where ftype in('bos_card_billstats', 'bos_card_billstats_list', 'bos_card_quicklaunch') and fmainpageid in (select fid from t_bas_mainpagelayout where ftype='main')";
        String algoKey = this.getClass().getName() + ".query_t_bas_cardconfig";
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.basedata, (String)sql);){
            updateCardParamsList = new ArrayList<Object[]>();
            while (dataSet.hasNext()) {
                try {
                    Row row = dataSet.next();
                    Long fid = row.getLong(0);
                    String ftype = row.getString(1);
                    String fconfig = row.getString(2);
                    String replaceConfigData = "";
                    if ("bos_card_quicklaunch".equals(ftype)) {
                        replaceConfigData = this.replaceQuickCardConfig(fconfig, transformMenuMap);
                    } else if ("bos_card_billstats".equals(ftype)) {
                        replaceConfigData = this.replaceBillCountCardConfig(fconfig, transformMenuMap);
                    } else if ("bos_card_billstats_list".equals(ftype)) {
                        replaceConfigData = this.replaceMultiBillCountCardConfig(fconfig, transformMenuMap);
                    }
                    if (!StringUtils.isNotEmpty((String)replaceConfigData)) continue;
                    updateCardParamsList.add(new Object[]{replaceConfigData, fid});
                }
                catch (Exception e) {
                    logger.error("replaceCardConfig error", (Throwable)e);
                }
            }
        }
        return updateCardParamsList;
    }

    private String replaceQuickCardConfig(String fconfig, Map<String, AppAndMenuData> transformMenuMap) {
        if (StringUtils.isEmpty((String)fconfig)) {
            return fconfig;
        }
        Map configMap = (Map)SerializationUtils.fromJsonString((String)fconfig, Map.class);
        Map<String, Object> configInfo = this.getDetailConfigMap(configMap);
        if (configInfo == null) {
            return null;
        }
        LinkedHashMap<String, Map> newDataMap = new LinkedHashMap<String, Map>(8);
        boolean isNeedUpdate = false;
        for (Map.Entry<String, Object> entry : configInfo.entrySet()) {
            Map itemMap = (Map)entry.getValue();
            String menuId = entry.getKey();
            String launchType = (String)itemMap.get(LAUNCHTYPE);
            if (LAUNCHTYPE_MENU.equalsIgnoreCase(launchType) && transformMenuMap.containsKey(menuId)) {
                AppAndMenuData appAndMenuData = transformMenuMap.get(menuId);
                menuId = appAndMenuData.getMenuId();
                itemMap.put(CACHE_SEL_APPID, appAndMenuData.getAppId());
                itemMap.put(CACHE_SEL_MENUID, menuId);
                isNeedUpdate = true;
            }
            newDataMap.put(menuId, itemMap);
        }
        if (isNeedUpdate) {
            configMap.put(CONFIG, newDataMap);
            return SerializationUtils.toJsonString((Object)configMap);
        }
        return null;
    }

    private String replaceBillCountCardConfig(String fconfig, Map<String, AppAndMenuData> transformMenuMap) {
        if (StringUtils.isEmpty((String)fconfig)) {
            return fconfig;
        }
        Map configMap = (Map)SerializationUtils.fromJsonString((String)fconfig, Map.class);
        String menuId = (String)configMap.get("menuid");
        if (transformMenuMap.containsKey(menuId)) {
            AppAndMenuData appAndMenuData = transformMenuMap.get(menuId);
            configMap.put("menuid", appAndMenuData.getMenuId());
            configMap.put("appnum", appAndMenuData.getAppNum());
            return SerializationUtils.toJsonString((Object)configMap);
        }
        return null;
    }

    private String replaceMultiBillCountCardConfig(String fconfig, Map<String, AppAndMenuData> transformMenuMap) {
        if (StringUtils.isEmpty((String)fconfig)) {
            return fconfig;
        }
        Map configMap = (Map)SerializationUtils.fromJsonString((String)fconfig, Map.class);
        Map<String, Object> configInfo = this.getDetailConfigMap(configMap);
        if (configInfo == null) {
            return null;
        }
        boolean isNeedUpdate = false;
        for (Object valueObj : configInfo.values()) {
            Map itemMap = (Map)valueObj;
            String menuId = (String)itemMap.get("menuid");
            if (!transformMenuMap.containsKey(menuId)) continue;
            AppAndMenuData appAndMenuData = transformMenuMap.get(menuId);
            itemMap.put("menuid", appAndMenuData.getMenuId());
            itemMap.put("appnum", appAndMenuData.getAppNum());
            isNeedUpdate = true;
        }
        if (isNeedUpdate) {
            configMap.put(CONFIG, configInfo);
            return SerializationUtils.toJsonString((Object)configMap);
        }
        return null;
    }

    private List<Object[]> getMarkMenuParamsList(Map<String, AppAndMenuData> transformMenuMap) {
        ArrayList<Object[]> updateSqlParamsList = new ArrayList<Object[]>();
        transformMenuMap.forEach((k, v) -> {
            String newAppNum = v.getAppNum();
            String newMenuId = v.getMenuId();
            updateSqlParamsList.add(new Object[]{newAppNum, newMenuId, k});
        });
        return updateSqlParamsList;
    }

    private Map<String, Object> getDetailConfigMap(Map<String, String> cardInfo) {
        String configObj = cardInfo.get(CONFIG);
        Map configMap = null;
        if (configObj instanceof String) {
            String config = configObj;
            if (StringUtils.isEmpty((String)config)) {
                return null;
            }
            config = this.convertToPureJson(config);
            configMap = (Map)SerializationUtils.fromJsonString((String)config, Map.class);
        } else {
            configMap = (Map)((Object)configObj);
        }
        return configMap;
    }

    private String convertToPureJson(String configStr) {
        configStr = this.replaceBackSlach(configStr);
        configStr = configStr.replaceAll("\"\\{", "\\{").replaceAll("\\}\"", "\\}");
        return configStr;
    }

    private String replaceBackSlach(String layout) {
        String splitStr = "\\\"";
        while (layout.contains(splitStr)) {
            layout = layout.replaceAll("\\\\\"", "\"");
        }
        return layout;
    }
}

