/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.inte.api.EnabledLang;
import kd.bos.servicehelper.inte.InteServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ILocalStringUtil {
    private static final List<String> COMMON_LANG_LIST = Arrays.asList("zh_CN", "en_US");
    public static final LangSort DEFAULT_SORT = new LangSort(LangType.Minor, LangType.DefaultLang, LangType.Zh, LangType.Any);

    public static ILocaleString mapValueToLocaleString(Map<String, String> mapValue) {
        if (mapValue == null) {
            return null;
        }
        LocaleString iLocaleString = new LocaleString();
        for (Map.Entry<String, String> entry : mapValue.entrySet()) {
            iLocaleString.setItem(entry.getKey(), (Object)entry.getValue());
        }
        return iLocaleString;
    }

    public static String getValueByLang(ILocaleString muLang, String lang, LangSort sort, String defaultValue) {
        if (muLang != null) {
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)muLang.get((Object)lang)))) {
                return (String)muLang.get((Object)lang);
            }
            String sortValue = ILocalStringUtil.getValueFromSort(muLang, sort, lang);
            if (StringUtils.isNotBlank((CharSequence)sortValue)) {
                return sortValue;
            }
        }
        return defaultValue;
    }

    private static String getValueFromSort(ILocaleString muLang, LangSort sort, String lang) {
        if (sort == null || sort.getSortTypes() == null) {
            return null;
        }
        for (LangType sortType : sort.sortTypes) {
            String valueByLangType = ILocalStringUtil.getValueByLangType(sortType, muLang, lang);
            if (!StringUtils.isNotBlank((CharSequence)valueByLangType)) continue;
            return valueByLangType;
        }
        return null;
    }

    private static String getDefaultLang() {
        List enabledLangs = InteServiceHelper.getEnabledLang();
        if (enabledLangs != null && enabledLangs.size() > 0) {
            for (EnabledLang enabledLang : enabledLangs) {
                if (!enabledLang.isDefault.booleanValue()) continue;
                return enabledLang.getNumber();
            }
        }
        return null;
    }

    private static String getValueByLangType(LangType type, ILocaleString muLang, String lang) {
        if (LangType.Minor == type && !COMMON_LANG_LIST.contains(lang)) {
            return (String)muLang.get((Object)"en_US");
        }
        if (LangType.DefaultLang == type) {
            return (String)muLang.get((Object)ILocalStringUtil.getDefaultLang());
        }
        if (LangType.Zh == type) {
            return (String)muLang.get((Object)"zh_CN");
        }
        if (LangType.Any == type) {
            return ILocalStringUtil.localStringNoNull(muLang);
        }
        return null;
    }

    private static String localStringNoNull(ILocaleString muLang) {
        for (Map.Entry entry : muLang.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    public static class LangSort {
        private List<LangType> sortTypes;

        public LangSort(LangType ... sort) {
            if (sort != null && sort.length > 0) {
                this.sortTypes = new ArrayList<LangType>(sort.length);
                for (LangType langType : sort) {
                    this.sortTypes.add(langType);
                }
            }
        }

        public List<LangType> getSortTypes() {
            return this.sortTypes;
        }

        public void setSortTypes(List<LangType> sortTypes) {
            this.sortTypes = sortTypes;
        }
    }

    public static enum LangType {
        Minor,
        DefaultLang,
        Zh,
        Any;

    }
}

