/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.dto.MCUploadFileDto;
import kd.bos.portal.model.MCUploadFileInfo;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang3.StringUtils;

public class MCUploadFileUtil {
    private static Log log = LogFactory.getLog(MCUploadFileUtil.class);

    public static boolean setWebClientFiles(MCUploadFileDto mcUploadFileDto) throws Exception {
        if (mcUploadFileDto == null) {
            throw new KDException(new ErrorCode("fail", "setWebClientFiles fail, mcUploadFileDto is null"), new Object[0]);
        }
        String mcserver = System.getProperty("mc.server.url");
        if (mcserver == null) {
            throw new KDException(LoginErrorCode.loginConfigMissingKey, new Object[]{"mc.server.url"});
        }
        String token = MCUploadFileUtil.getAccessToken(mcserver);
        return MCUploadFileUtil.uploadStaticFile(mcserver, token, mcUploadFileDto);
    }

    public static boolean setWebClientFiles(MCUploadFileInfo mcUploadFileInfo) {
        boolean result;
        try {
            result = MCUploadFileUtil.setWebClientFiles(new MCUploadFileDto(mcUploadFileInfo));
        }
        catch (Exception e) {
            log.error("api setWebClientFiles error", (Throwable)e);
            result = false;
        }
        return result;
    }

    private static String getAccessToken(String mcServer) {
        String mcApi = "/api/upgradeLogin.do";
        HashMap<String, String> body = new HashMap<String, String>(2);
        body.put("tenantId", "0");
        body.put("accountId", "");
        String token = "";
        String response = "";
        String url = mcServer + mcApi;
        try {
            log.info(String.format("getAccessToken url:%s, body:%s", url, ((Object)body).toString()));
            response = HttpClientUtils.postAppJson((String)url, null, body);
            if (response != null) {
                Map map = (Map)SerializationUtils.fromJsonString((String)response, Map.class);
                Map data = (Map)map.get("data");
                token = data.get("access_token").toString();
            }
        }
        catch (Exception e) {
            log.error("MCUploadFileUtil#getAccessToken error:" + response, (Throwable)e);
            throw new KDException(new ErrorCode("fail", "getAccessToken fail"), new Object[0]);
        }
        return token;
    }

    private static boolean uploadStaticFile(String mcServer, String accessToken, MCUploadFileDto mcUploadFileDto) {
        String mcApi = "/kapi/v2/mc/webClient/uploadFile";
        String fileName = mcUploadFileDto.getName();
        ArrayList<HttpClientUtils.FormDataEntity> formDatas = new ArrayList<HttpClientUtils.FormDataEntity>(10);
        formDatas.add(new HttpClientUtils.FormDataEntity("file", mcUploadFileDto.getInputStream(), fileName));
        formDatas.add(new HttpClientUtils.FormDataEntity("isv", mcUploadFileDto.getIsv()));
        formDatas.add(new HttpClientUtils.FormDataEntity("tenantid", mcUploadFileDto.getTenantId()));
        formDatas.add(new HttpClientUtils.FormDataEntity("dcId", mcUploadFileDto.getDcid()));
        formDatas.add(new HttpClientUtils.FormDataEntity("keys", mcUploadFileDto.getKeys()));
        formDatas.add(new HttpClientUtils.FormDataEntity("destPath", mcUploadFileDto.getDestPath()));
        formDatas.add(new HttpClientUtils.FormDataEntity("name", fileName));
        formDatas.add(new HttpClientUtils.FormDataEntity("servertype", mcUploadFileDto.getServerType()));
        formDatas.add(new HttpClientUtils.FormDataEntity("fileserverpath", mcUploadFileDto.getFileServerPath()));
        formDatas.add(new HttpClientUtils.FormDataEntity("needupdate", mcUploadFileDto.isNeedUpdate() + ""));
        String url = mcServer + mcApi;
        log.info(String.format("uploadStaticFile url:%s, formData:%s", url, mcUploadFileDto.toString()));
        String response = HttpClientUtils.postFormData((String)(mcServer + mcApi), MCUploadFileUtil.getHeader(accessToken), formDatas, (int)5000, (int)5000);
        log.info("uploadStaticFile response:" + response);
        if (StringUtils.isBlank((CharSequence)response)) {
            throw new KDException(new ErrorCode("fail", "upload fail, response is empty"), new Object[0]);
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)response, Map.class);
        Object status = map.get("status");
        if (status == null || !Boolean.parseBoolean(status.toString())) {
            String message = "upload fail, status is false";
            Object messageObj = map.get("message");
            if (messageObj != null) {
                message = messageObj.toString();
            }
            throw new KDException(new ErrorCode("fail", message), new Object[0]);
        }
        return true;
    }

    private static Map<String, String> getHeader(String accessToken) {
        HashMap<String, String> header = new HashMap<String, String>(2);
        header.put("accessToken", accessToken);
        header.put("api", "true");
        return header;
    }
}

