/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.util.PasswordUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.PasswordEncryptUtil;

public class PswStrategyCommonUtil {
    private static Log logger = LogFactory.getLog(PswStrategyCommonUtil.class);
    private static final String SUCCESS = "success";
    private static final String BOS_SVC_COMMON = "bos-svc-common";
    private static final String BOS_USER = "bos_user";
    private static Pattern numPattern = Pattern.compile("[0-9]");
    private static Pattern lowerPattern = Pattern.compile(".*?[a-z]+.*?");
    private static Pattern upperPattern = Pattern.compile(".*?[A-Z]+.*?");
    private static Pattern specialCharPattern = Pattern.compile("[`~!@#$%^&*()_+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]");
    private static Pattern allLetterPattern = Pattern.compile("[A-Za-z]");

    public static Map<String, Object> verifyPwdByStrategy(String newpsw) {
        long userId = RequestContext.get().getCurrUserId();
        return PswStrategyCommonUtil.verifyPwdByStrategy(userId, newpsw);
    }

    public static Map<String, Object> verifyPwdByStrategy(long userId, String newpsw) {
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)BOS_USER);
        DynamicObject pswstrategObject = null;
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        try {
            pswstrategObject = PswStrategyCommonUtil.getPswStrategyDynamicObject(user);
        }
        catch (KDException e) {
            logger.error("getPswStrategyDynamicObject error", (Throwable)e);
            result.put(SUCCESS, false);
            result.put("msg", e.getMessage());
            return result;
        }
        catch (Exception e) {
            logger.error("getPswStrategyDynamicObject error", (Throwable)e);
            result.put(SUCCESS, false);
            result.put("msg", ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u5bc6\u7801\u7b56\u7565\u5931\u8d25\u3002", (String)"PswStrategyCommonUtil_10", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
            return result;
        }
        boolean flag = true;
        ArrayList<String> tipList = new ArrayList<String>(0);
        if (Objects.nonNull(pswstrategObject)) {
            String isWeakPswMsg;
            String checkPswRepeatTimesMsg;
            String checkPswFormatMsg;
            String checkPswLengthMsg = PswStrategyCommonUtil.checkPswLength(newpsw, pswstrategObject);
            if (checkPswLengthMsg != null) {
                flag = false;
                tipList.add(checkPswLengthMsg);
            }
            if ((checkPswFormatMsg = PswStrategyCommonUtil.checkPswFormat(newpsw, pswstrategObject)) != null) {
                flag = false;
                tipList.add(checkPswFormatMsg);
            }
            if (flag && (checkPswRepeatTimesMsg = PswStrategyCommonUtil.checkPswRepeatTimes(newpsw, pswstrategObject, user)) != null) {
                flag = false;
                tipList.add(checkPswRepeatTimesMsg);
            }
            if (flag && (isWeakPswMsg = PswStrategyCommonUtil.checkWeakPsw(newpsw, pswstrategObject)) != null) {
                flag = false;
                tipList.add(isWeakPswMsg);
            }
        }
        if (tipList.size() > 0) {
            String allMsg = String.join((CharSequence)"\uff0c", tipList);
            String msg = String.format(ResManager.loadKDString((String)"\u65b0\u5bc6\u7801%1$s\u3002", (String)"PswStrategyCommonUtil_0", (String)BOS_SVC_COMMON, (Object[])new Object[0]), allMsg);
            result.put("msg", msg);
        }
        result.put(SUCCESS, flag);
        return result;
    }

    private static String checkPswLength(String psw, DynamicObject pswstrategObject) {
        String msg = null;
        int fminlength = pswstrategObject.getInt("minlength");
        if (psw.length() < fminlength) {
            msg = String.format(ResManager.loadKDString((String)"\u65b0\u5bc6\u7801\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e%1$s\u4e2a\u5b57\u7b26", (String)"PswStrategyCommonUtil_1", (String)BOS_SVC_COMMON, (Object[])new Object[0]), fminlength);
        }
        return msg;
    }

    private static String checkPswFormat(String psw, DynamicObject pswstrategObject) {
        boolean flag;
        String msg = null;
        ArrayList<String> tipFieldList = new ArrayList<String>(0);
        boolean containNum = PswStrategyCommonUtil.checkPswContainNum(psw, pswstrategObject, tipFieldList);
        boolean containLetter = PswStrategyCommonUtil.checkPswContainLetter(psw, pswstrategObject, tipFieldList);
        boolean containSpecialChar = PswStrategyCommonUtil.checkPswContainSpecialChar(psw, pswstrategObject, tipFieldList);
        boolean bl = flag = containNum && containLetter && containSpecialChar;
        if (!flag && tipFieldList.size() > 0) {
            String fieldMsg = String.join((CharSequence)"\u3001", tipFieldList);
            msg = String.format(ResManager.loadKDString((String)"\u9700\u8981\u5305\u542b%1$s", (String)"PswStrategyCommonUtil_2", (String)BOS_SVC_COMMON, (Object[])new Object[0]), fieldMsg);
        }
        return msg;
    }

    private static boolean checkPswContainNum(String psw, DynamicObject pswstrategObject, List<String> tipFieldList) {
        boolean flag = true;
        boolean fisnumber = pswstrategObject.getBoolean("isnumber");
        if (fisnumber) {
            if (!PswStrategyCommonUtil.regexMatch(numPattern, psw).booleanValue()) {
                flag = false;
            }
            tipFieldList.add(ResManager.loadKDString((String)"\u6570\u5b57", (String)"PswStrategyCommonUtil_3", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
        }
        return flag;
    }

    private static boolean checkPswContainLetter(String psw, DynamicObject pswstrategObject, List<String> tipFieldList) {
        boolean flag = true;
        boolean fisletter = pswstrategObject.getBoolean("isletter");
        if (fisletter) {
            boolean hasCaseLetter = pswstrategObject.getBoolean("hascaseletter");
            if (hasCaseLetter) {
                if (!PswStrategyCommonUtil.regexMatch(lowerPattern, psw).booleanValue() || !PswStrategyCommonUtil.regexMatch(upperPattern, psw).booleanValue()) {
                    flag = false;
                }
                tipFieldList.add(ResManager.loadKDString((String)"\u5927\u5c0f\u5199\u5b57\u6bcd", (String)"PswStrategyCommonUtil_4", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
            } else {
                if (!PswStrategyCommonUtil.regexMatch(allLetterPattern, psw).booleanValue()) {
                    flag = false;
                }
                tipFieldList.add(ResManager.loadKDString((String)"\u5b57\u6bcd", (String)"PswStrategyCommonUtil_5", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
            }
        }
        return flag;
    }

    private static boolean checkPswContainSpecialChar(String psw, DynamicObject pswstrategObject, List<String> tipFieldList) {
        boolean flag = true;
        boolean fisspecial = pswstrategObject.getBoolean("isspecial");
        if (fisspecial) {
            if (!PswStrategyCommonUtil.regexMatch(specialCharPattern, psw).booleanValue()) {
                flag = false;
            }
            tipFieldList.add(ResManager.loadKDString((String)"\u7279\u6b8a\u5b57\u7b26", (String)"PswStrategyCommonUtil_6", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
        }
        return flag;
    }

    private static String checkPswRepeatTimes(String psw, DynamicObject pswstrategObject, DynamicObject user) {
        String msg = null;
        int frepeattimes = pswstrategObject.getInt("repeattimes");
        if (frepeattimes <= 0) {
            return msg;
        }
        Object pswhisObj = user.get("pswhisstr");
        if (pswhisObj == null) {
            return msg;
        }
        String[] pswHisStrs = pswhisObj.toString().split(",");
        for (int i = 0; i < frepeattimes; ++i) {
            String userId;
            boolean checkPasswordWithSalt;
            int currPswIndex = pswHisStrs.length - 1 - i;
            if (currPswIndex < 0) {
                currPswIndex = 0;
            }
            if (!(checkPasswordWithSalt = PasswordEncryptUtil.checkPasswordWithSalt((String)PasswordUtil.getCorrectUserIDSalt(userId = user.getString("id")), (String)psw, (String)pswHisStrs[currPswIndex]))) continue;
            msg = String.format(ResManager.loadKDString((String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u524d%1$s\u6b21\u65e7\u5bc6\u7801\u4e00\u81f4", (String)"PswStrategyCommonUtil_7", (String)BOS_SVC_COMMON, (Object[])new Object[0]), String.valueOf(frepeattimes));
            break;
        }
        return msg;
    }

    private static String checkWeakPsw(String psw, DynamicObject pswstrategObject) {
        String msg = null;
        boolean fweakpsw = pswstrategObject.getBoolean("weakpsw");
        if (fweakpsw) {
            QFilter filter = new QFilter("psw", "=", (Object)psw);
            if (QueryServiceHelper.exists((String)"perm_weakpsw", (QFilter[])new QFilter[]{filter})) {
                msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u662f\u5f31\u53e3\u4ee4", (String)"PswStrategyCommonUtil_8", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
            }
        }
        return msg;
    }

    private static DynamicObject getPswStrategyDynamicObject(DynamicObject user) {
        if (Objects.isNull(user)) {
            return null;
        }
        long pswstrategyId = 0L;
        DynamicObject pswstrategy = user.getDynamicObject("pswstrategy");
        if (pswstrategy == null) {
            ErrorCode errorCode = new ErrorCode("", ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7528\u6237\u672a\u8bbe\u7f6e\u5bc6\u7801\u7b56\u7565\uff0c\u8bf7\u8fd4\u56de\u4e0a\u4e00\u6b65\u8bbe\u7f6e\u5bc6\u7801\u7b56\u7565\u540e\u518d\u64cd\u4f5c\u3002", (String)"PswStrategyCommonUtil_9", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[0]);
        }
        String pswstrategyIdStr = pswstrategy.getString("id");
        if (StringUtils.isNumeric((CharSequence)pswstrategyIdStr)) {
            pswstrategyId = Long.parseLong(pswstrategyIdStr);
        }
        String selectFields = "minlength,isletter,isnumber,isspecial,repeattimes,hascaseletter,weakpsw,logincheckstgy";
        QFilter pswstrategyIdFilter = new QFilter("id", "=", (Object)pswstrategyId);
        QFilter[] filters = new QFilter[]{pswstrategyIdFilter};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"perm_pswstrategy", (String)selectFields, (QFilter[])filters);
    }

    private static Boolean regexMatch(Pattern pattern, String matcherStr) {
        Matcher m = pattern.matcher(matcherStr);
        return m.find();
    }
}

