/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.PortalLocalCacheUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TenantUtils {
    private static final Log LOGGER = LogFactory.getLog(TenantUtils.class);

    public static boolean isMasterTenant() {
        String tenantId = RequestContext.get().getTenantId();
        String key = "portal_masterTenant_" + tenantId;
        Object isMasterObj = PortalLocalCacheUtils.get(key);
        if (isMasterObj != null) {
            return Boolean.parseBoolean(isMasterObj.toString());
        }
        boolean isMaster = TenantUtils.isMasterTenantFromMC();
        PortalLocalCacheUtils.put(key, isMaster);
        return isMaster;
    }

    private static boolean isMasterTenantFromMC() {
        boolean isMaster = false;
        String tenantInfo = System.getProperty("mc.tenant.ids");
        if (tenantInfo != null) {
            try {
                List tenantDatas = (List)SerializationUtils.fromJsonString((String)tenantInfo, List.class);
                String currentTenant = RequestContext.get().getTenantId();
                for (Map tenantData : tenantDatas) {
                    Object isMasterObj;
                    Object tenantNumber = tenantData.get("tenantnumber");
                    if (!currentTenant.equals(tenantNumber) || (isMasterObj = tenantData.get("isMaster")) == null || !Boolean.parseBoolean(isMasterObj.toString())) continue;
                    isMaster = true;
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.info("PortalUsableFuncUtil#static isMasterTenant error", (Object)e);
            }
        }
        return isMaster;
    }

    public static boolean isTenantSystem() {
        String tenantId = RequestContext.get().getTenantId();
        QFilter enable = new QFilter("enable", "=", (Object)true);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"ctsy_tenant", (String)"tenantid", (QFilter[])new QFilter[]{enable});
        if (dynamicObjectMap.isEmpty()) {
            return false;
        }
        for (DynamicObject dynamicObject : dynamicObjectMap.values()) {
            String tenantIdData = dynamicObject.getString("tenantid");
            if (!tenantId.equals(tenantIdData)) continue;
            return true;
        }
        return false;
    }
}

