/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileUtils;

public class FileHandlerUtil {
    private static Log log = LogFactory.getLog(FileHandlerUtil.class);
    private static final String BOS_SVC_COMMON = "bos-svc-common";
    static final byte[] buffer = new byte[8192];

    public static File createSaveDir(String dirName) {
        String property = System.getProperty("user.home");
        String FILEPATH = FileUtils.cleanString((String)(property + File.separator + dirName + File.separator));
        File saveDir = new File(FILEPATH + UUID.randomUUID());
        boolean mkdirsSuccess = true;
        if (!saveDir.exists()) {
            mkdirsSuccess = saveDir.mkdirs();
        }
        if (!mkdirsSuccess) {
            throw new KDBizException(new ErrorCode("", String.format(ResManager.loadKDString((String)"\u521b\u5efa\u670d\u52a1\u5668\u7f13\u5b58\u6587\u4ef6\u5939\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u5668\u8def\u5f84\u6743\u9650%s", (String)"FileHandlerUtil_1", (String)BOS_SVC_COMMON, (Object[])new Object[0]), new Object[0])), new Object[]{FILEPATH});
        }
        return saveDir;
    }

    public static String flushToLocal(String fileName, String suffix, InputStream in, File saveDir, boolean isCreateTempFile) {
        String string;
        FileOutputStream fos = null;
        try {
            int len;
            File file = isCreateTempFile ? File.createTempFile(fileName, suffix, saveDir) : new File(saveDir, fileName);
            fos = new FileOutputStream(file);
            BufferedInputStream fis = new BufferedInputStream(in);
            while ((len = fis.read(buffer)) != -1) {
                ((OutputStream)fos).write(buffer, 0, len);
            }
            string = file.getAbsolutePath();
        }
        catch (IOException e) {
            try {
                throw new KDException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u5c06\u6587\u4ef6\u4e0b\u8f7d\u5230\u7f13\u5b58\u76ee\u5f55\u5f02\u5e38\u3002", (String)"FileHandlerUtil_2", (String)BOS_SVC_COMMON, (Object[])new Object[0]), e.getMessage())), new Object[0]);
            }
            catch (Throwable throwable) {
                FileSecurityUtil.safeClose(fos);
                throw throwable;
            }
        }
        FileSecurityUtil.safeClose(fos);
        return string;
    }

    public static String createZipForLocal(String fileName, String suffix, File saveDir, boolean isCreateTempFile) {
        File tempZipFile;
        ZipOutputStream zipOutputStream = null;
        if (!saveDir.isDirectory() || saveDir.listFiles() == null || saveDir.listFiles().length == 0) {
            throw new KDException(ResManager.loadKDString((String)"\u672c\u5730\u7f13\u5b58\u76ee\u5f55\u91cc\u6ca1\u6709\u6587\u4ef6", (String)"FileHandlerUtil_3", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
        }
        try {
            tempZipFile = isCreateTempFile ? File.createTempFile(fileName, suffix) : new File(System.getProperty("java.io.tmpdir"), fileName);
            zipOutputStream = new ZipOutputStream(new FileOutputStream(tempZipFile));
            FileHandlerUtil.zip(saveDir.listFiles(), "", zipOutputStream);
        }
        catch (Exception e) {
            try {
                throw new KDException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u751f\u6210\u538b\u7f29\u5305\u5931\u8d25\uff1a%s", (String)"FileHandlerUtil_4", (String)BOS_SVC_COMMON, (Object[])new Object[0]), e.getMessage())), new Object[0]);
            }
            catch (Throwable throwable) {
                FileSecurityUtil.safeClose(zipOutputStream);
                throw throwable;
            }
        }
        FileSecurityUtil.safeClose(zipOutputStream);
        return tempZipFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(File[] files, String baseFolder, ZipOutputStream zos) throws Exception {
        FileInputStream fis = null;
        for (File file : files) {
            if (file.isDirectory()) {
                FileHandlerUtil.zip(file.listFiles(), baseFolder + file.getName() + File.separator, zos);
                continue;
            }
            ZipEntry entry = new ZipEntry(baseFolder + file.getName());
            zos.putNextEntry(entry);
            try {
                int count;
                fis = new FileInputStream(file);
                while ((count = fis.read(buffer, 0, buffer.length)) != -1) {
                    zos.write(buffer, 0, count);
                }
                zos.closeEntry();
            }
            finally {
                if (fis != null) {
                    FileSecurityUtil.safeClose(fis);
                }
            }
        }
    }

    public static void tryDelFile(String filePath) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try {
            if (StringUtils.isNotBlank((CharSequence)filePath)) {
                service.delete(filePath);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }
}

