/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.util;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class ImportLogDeleteFileUtil {
    private static final String IS_FROM_LOG_MENU = "isfromlogmenu";
    private static final ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final Log log = LogFactory.getLog(ImportLogDeleteFileUtil.class);
    private static final String BOS_SVC_COMMON = "bos-svc-common";
    public static final String DELETE_PERM_ITEM = "4715e1f1000000ac";

    public static boolean isFromLogMenu(FormShowParameter formShowParameter) {
        Object isfromMenu = formShowParameter.getCustomParam(IS_FROM_LOG_MENU);
        return StringUtils.equals((CharSequence)"true", (CharSequence)((String)isfromMenu));
    }

    public static FileService getFileService() {
        return FileServiceFactory.getAttachmentFileService();
    }

    public static boolean isCanDeleteFile() {
        return StringUtils.equals((CharSequence)"true", (CharSequence)System.getProperty("import.candeletefile", "false"));
    }

    @Deprecated
    public static void createAppLoCodeRuleUtilsg(String formId, String bizAppId, String opName, String opDesc) {
        AppLogInfo appLogInfo = ImportLogDeleteFileUtil.buildAppInfo(formId, bizAppId, opName, opDesc);
        logService.addLog(appLogInfo);
    }

    public static void createAppLog(String formId, String bizAppId, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String ... opDescArgs) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(bizAppId);
        appLogInfo.setBizObjID(formId);
        appLogInfo.setOpName("attachOp", opNameBridge);
        appLogInfo.setOpDesc(opDescBridge, opDescArgs);
        logService.addLog((AppLogInfo)appLogInfo);
    }

    private static AppLogInfo buildAppInfo(String formId, String bizAppId, String opName, String opDesc) {
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setBizAppID(bizAppId);
        appLogInfo.setBizObjID(formId);
        appLogInfo.setOpName(opName);
        appLogInfo.setOpDescription(opDesc);
        return appLogInfo;
    }

    public static String getBizAppId(String appId, String formId) {
        String bizAppId;
        try {
            bizAppId = AppMetadataCache.getAppInfo((String)appId).getId();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            bizAppId = BizAppServiceHelp.getAppIdByFormNum((String)formId);
        }
        return bizAppId;
    }

    public static boolean checkDeletePermission(String appId, String formId, String permItemId) {
        long currUserId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.checkPermission((Long)currUserId, (String)appId, (String)formId, (String)permItemId);
    }

    public static String wrapUrl(FormShowParameter formShowParameter, String url) {
        if (ImportLogDeleteFileUtil.isFromLogMenu(formShowParameter)) {
            url = url + "&isfromlogmenu=true";
        }
        String appId = formShowParameter.getAppId();
        String fId = formShowParameter.getFormId();
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            url = url + "&appId=" + appId;
        }
        if (StringUtils.isNotEmpty((CharSequence)fId)) {
            url = url + "&fId=" + fId;
        }
        return url;
    }

    public static String getNoDeletePermissionMsg(String formId) {
        String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u5220\u9664\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportLogDeleteFileUtil_0", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
        try {
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
            LocaleString caption = formConfig.getCaption();
            msg = String.format(msg, caption.getLocaleValue());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            msg = String.format(msg, formId);
        }
        return msg;
    }
}

