/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.util;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.sdk.annotation.SdkInternal;

public class OpExistChecker {
    private static final String BOS_SVC_COMMON = "bos-svc-common";
    private static Log logger = LogFactory.getLog(OpExistChecker.class);

    @SdkInternal
    public static Boolean check(String entityNum, String opType, IFormView view) {
        try {
            if (opType == null) {
                logger.warn("OpExistChecker.check opType is null ");
                return Boolean.TRUE;
            }
            List opMetaList = ((MetadataService)ServiceFactory.getService(MetadataService.class)).loadEntityAllOperationMeta(entityNum);
            for (String opMetaString : opMetaList) {
                Map op = (Map)SerializationUtils.fromJsonString((String)opMetaString, Map.class);
                if (!opType.equals(op.get("type"))) continue;
                return Boolean.TRUE;
            }
            String errorTips = String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u4e0a\u6ca1\u6709\u6ca1\u6709\u7f16\u7801\u4e3a%2$s\u7684\u64cd\u4f5c", (String)"EntityMetadataProvider_2", (String)BOS_SVC_COMMON, (Object[])new Object[0]), entityNum, opType);
            view.showErrorNotification(errorTips);
            return Boolean.FALSE;
        }
        catch (Exception e) {
            logger.error("OpExistChecker.check error : " + e);
            return Boolean.TRUE;
        }
    }
}

