/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.attachment.DisposableUrlParam;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.session.SystemPropertyUtils;

public class PermissionParam {
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    public static String genAttacId(String appId, String entityNum, String logEntityNum, Object logPkId, String fileType) {
        Map<String, Object> permissionParam = PermissionParam.createPermissionParam(appId, entityNum, logEntityNum, logPkId, fileType, null, false);
        return PermissionParam.cachePermissionParam(permissionParam);
    }

    public static String genAttacId(String appId, String entityNum, String logEntityNum, Object logPkId, String fileType, String permId) {
        Map<String, Object> permissionParam = PermissionParam.createPermissionParam(appId, entityNum, logEntityNum, logPkId, fileType, permId, true);
        return PermissionParam.cachePermissionParam(permissionParam);
    }

    public static String genCustomAttacId(DisposableUrlParam disposableUrlParam) {
        Map<String, Object> permissionParam = PermissionParam.createPermissionParam(disposableUrlParam);
        return PermissionParam.cachePermissionParam(permissionParam, "customAttachId");
    }

    public static Map<String, Object> createPermissionParam(DisposableUrlParam disposableUrlParam) {
        HashMap<String, Object> permissionParam = new HashMap<String, Object>();
        permissionParam.put("entityNum", disposableUrlParam.getEntityNum());
        permissionParam.put("permItem", disposableUrlParam.getPermItem());
        permissionParam.put("billPkId", disposableUrlParam.getPkId());
        permissionParam.put("path", disposableUrlParam.getPath());
        permissionParam.put("count", disposableUrlParam.getCount());
        permissionParam.put("disableTime", disposableUrlParam.getDisableTime());
        return permissionParam;
    }

    private static Map<String, Object> createPermissionParam(String appId, String entityNum, String logEntityNum, Object logPkId, String fileType, String permId, boolean hasPerm) {
        HashMap<String, Object> permissionParam = new HashMap<String, Object>();
        permissionParam.put("appId", appId);
        permissionParam.put("entityNum", entityNum);
        permissionParam.put("logEntityNum", logEntityNum);
        if (hasPerm) {
            permissionParam.put("permItem", permId);
        } else if ("bos_importlog".equals(logEntityNum)) {
            permissionParam.put("permItem", "4730fc9f000003ae");
        } else if ("bos_exportlog".equals(logEntityNum)) {
            permissionParam.put("permItem", "4730fc9f000004ae");
        } else {
            throw new KDException(new ErrorCode("parameter is illegal", ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5408\u6cd5\uff01", (String)"AttachmentAction_12", (String)"bos-webactions", (Object[])new Object[0])), new Object[0]);
        }
        permissionParam.put("logPkId", logPkId);
        permissionParam.put("fileType", fileType);
        return permissionParam;
    }

    public static String cachePermissionParam(Map<String, Object> permissionParam) {
        return PermissionParam.cachePermissionParam(permissionParam, "AttachId");
    }

    private static String cachePermissionParam(Map<String, Object> permissionParam, String customRedisKey) {
        String attachId = customRedisKey + UUID.randomUUID().toString().replace("-", "");
        if (CollectionUtils.isEmpty(permissionParam)) {
            return attachId;
        }
        redisCache.put(attachId, (Object)SerializationUtils.toJsonString(permissionParam), 7200);
        return attachId;
    }

    public static void updatePermissionParam(String attachId, Map<String, Object> permissionParam) {
        redisCache.put(attachId, (Object)SerializationUtils.toJsonString(permissionParam), 7200);
    }

    public static Map<String, Object> getPermissionParam(String attachId) {
        String permissionParamJson = (String)redisCache.get(attachId);
        if (StringUtils.isNotBlank((CharSequence)permissionParamJson)) {
            Map permissionParam = (Map)SerializationUtils.fromJsonString((String)permissionParamJson, Map.class);
            return permissionParam;
        }
        return new HashMap<String, Object>();
    }

    public static List<Map<String, Object>> getPermissionParamList(String attachId) {
        ArrayList<Map<String, Object>> refEntityList = new ArrayList<Map<String, Object>>();
        refEntityList.add(PermissionParam.getPermissionParam(attachId));
        return refEntityList;
    }

    public static Boolean removePermissionParam(String attachId) {
        redisCache.remove(attachId);
        return Boolean.TRUE;
    }

    public static boolean isClearImpExpFiles() {
        return SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"impexpfiles.persistence", (Boolean)Boolean.FALSE) == false;
    }
}

