/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.util;

import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonDateFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.filter.SchemeFilterView;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public class TimeFilterLimitUtils {
    private static Log logger = LogFactory.getLog(TimeFilterLimitUtils.class);

    public static boolean check(List<QFilter> qfilters, List<String> timeFieldList) {
        int intervalMonth = TimeFilterLimitUtils.getQueryMonthInterval();
        boolean checkResult = true;
        if (qfilters == null || qfilters.isEmpty()) {
            return true;
        }
        for (QFilter filter : qfilters) {
            if (!timeFieldList.contains(filter.getProperty())) continue;
            String filterStr = filter.toString();
            List qfilterNests = filter.getNests(true);
            if (qfilterNests == null || qfilterNests.isEmpty()) continue;
            String startTime = null;
            String endTime = null;
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            startTime = filterStr.substring(0, filterStr.indexOf(39));
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            endTime = filterStr.substring(0, filterStr.indexOf(39));
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime start = LocalDateTime.parse(startTime, dateTimeFormatter);
                LocalDateTime end = LocalDateTime.parse(endTime, dateTimeFormatter);
                long duration = ChronoUnit.DAYS.between(start, end);
                if (duration > (long)(intervalMonth * 31)) {
                    checkResult = false;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7%d\u4e2a\u6708\u3002", (String)"LogOperactionListPlugin_0", (String)"bos-log-formplugin", (Object[])new Object[0]), TimeFilterLimitUtils.getQueryMonthInterval()));
                }
                checkResult = true;
            }
            catch (KDBizException bizExp) {
                throw bizExp;
            }
            catch (Exception px) {
                logger.error((Throwable)px);
                return checkResult;
            }
        }
        return checkResult;
    }

    public static int getQueryMonthInterval() {
        return 3;
    }

    public static void filterContainerInit(FilterContainerInitArgs args, List<String> timeFieldList) {
        try {
            List filterColumnList = args.getCommonFilterColumns();
            ArrayList comboItems = new ArrayList(16);
            for (FilterColumn filterColumn : filterColumnList) {
                if (!(filterColumn instanceof CommonDateFilterColumn)) continue;
                comboItems.addAll(((CommonDateFilterColumn)filterColumn).getComboItems());
            }
            Iterator iterator = comboItems.iterator();
            while (iterator.hasNext()) {
                ComboItem comboItem = (ComboItem)iterator.next();
                if (!"24".equals(comboItem.getValue()) || TimeFilterLimitUtils.getQueryMonthInterval() >= 3) continue;
                iterator.remove();
                break;
            }
            List<String> ids = Arrays.asList("13", "11", "10", "61", "63", "92", "24");
            FilterContainerInitEvent event = args.getFilterContainerInitEvent();
            Field field = event.getClass().getDeclaredField("schemeFilterView");
            ReflectionUtils.makeAccessible((Field)field);
            SchemeFilterView schemeFilterView = (SchemeFilterView)field.get(event);
            List filterColumns = schemeFilterView.getFilterColumns();
            for (FilterColumn column : filterColumns) {
                if (!timeFieldList.contains(column.getFieldName())) continue;
                SchemeFilterColumn schemeFilterColumn = (SchemeFilterColumn)column;
                Field field1 = schemeFilterColumn.getClass().getDeclaredField("compareTypes");
                ReflectionUtils.makeAccessible((Field)field1);
                List compareTypes = (List)field1.get(schemeFilterColumn);
                compareTypes.removeIf(temp -> !ids.contains(temp.getId()));
            }
        }
        catch (Exception e) {
            logger.error("\u79fb\u9664\u64cd\u4f5c\u65f6\u95f4\u8fc7\u53bb\u4e09\u4e2a\u6708\u51fa\u5f02\u5e38", (Throwable)e);
        }
    }
}

