/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.AdminAppResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TreeNodeFilter {
    private Set<String> disabledAppIds;
    private Set<String> disabledCloudIds;
    private AdminAppResult adminAppResult;
    private boolean isNeedFilter = TreeNodeFilter.isUseNewAppInfo();

    public TreeNodeFilter() {
        if (this.isNeedFilter) {
            this.disabledAppIds = ManageServiceHelper.getDisabledAppIds();
            this.disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
            this.adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId());
        }
    }

    public TreeNodeFilter(FilterTypeEnum filterType) {
        if (this.isNeedFilter) {
            if (FilterTypeEnum.ONLY_CLOUD == filterType) {
                this.disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
            } else if (FilterTypeEnum.ONLY_APP == filterType) {
                this.disabledAppIds = ManageServiceHelper.getDisabledAppIds();
                this.adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId());
            } else {
                throw new KDException(new ErrorCode("TreeNodeFilterTypeError", "filterType is error"), new Object[0]);
            }
        }
    }

    public QFilter getAppFilter(String appFieldKey) {
        if (!this.isNeedFilter) {
            return null;
        }
        if (this.adminAppResult != null && this.adminAppResult.needAdminAppRange()) {
            HashSet<String> appIds = new HashSet<String>(this.adminAppResult.getAppIds());
            if (CollectionUtils.isEmpty(appIds)) {
                return new QFilter(null, "is not null", null);
            }
            if (CollectionUtils.isNotEmpty(this.disabledAppIds)) {
                appIds.removeAll(this.disabledAppIds);
            }
            if (CollectionUtils.isNotEmpty(appIds)) {
                Set<String> extendAppIds = this.getExtendAppIds(appIds);
                appIds.addAll(extendAppIds);
                return new QFilter(appFieldKey, "in", appIds);
            }
        } else {
            HashSet<String> notInAppIds = new HashSet<String>(16);
            if (CollectionUtils.isNotEmpty(this.disabledAppIds)) {
                notInAppIds.addAll(this.disabledAppIds);
            }
            if (CollectionUtils.isNotEmpty(notInAppIds)) {
                Set<String> extendAppIds = this.getExtendAppIds(notInAppIds);
                notInAppIds.addAll(extendAppIds);
                return new QFilter(appFieldKey, "not in", notInAppIds);
            }
        }
        return null;
    }

    private Set<String> getExtendAppIds(Set<String> bizAppId) {
        String selectFields = "id";
        QFilter[] filters = new QFilter[]{new QFilter("masterid", "in", bizAppId)};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)selectFields, (QFilter[])filters);
        HashSet<String> extendAppIds = new HashSet<String>();
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String id = dynamicObject.getString("id");
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                extendAppIds.add(id);
            }
        }
        return extendAppIds;
    }

    public List<TreeNode> filterCloudTreeNode(List<TreeNode> clouds) {
        return this.filterCloudTreeNode(clouds, false);
    }

    public List<TreeNode> filterCloudTreeNode(List<TreeNode> clouds, boolean includeAppNode) {
        ArrayList<TreeNode> filterClouds = new ArrayList<TreeNode>(16);
        if (CollectionUtils.isEmpty(clouds)) {
            return filterClouds;
        }
        if (!this.isNeedFilter) {
            filterClouds.addAll(clouds);
            return filterClouds;
        }
        for (TreeNode cloud : clouds) {
            String id = cloud.getId();
            if (CollectionUtils.isNotEmpty(this.disabledCloudIds) && this.disabledCloudIds.contains(id)) continue;
            if (includeAppNode) {
                List<TreeNode> appTreeNode = this.filterAppTreeNode(cloud.getChildren());
                if (CollectionUtils.isEmpty(appTreeNode)) continue;
                cloud.setChildren(appTreeNode);
            }
            filterClouds.add(cloud);
        }
        return filterClouds;
    }

    public List<TreeNode> getCloudNodes() {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"cloud");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>();
        }
        for (TreeNode cloud : clouds) {
            cloud.setChildren(new ArrayList());
        }
        return this.filterCloudTreeNode(clouds);
    }

    public List<TreeNode> filterAppTreeNode(List<TreeNode> apps) {
        ArrayList<TreeNode> filterApps = new ArrayList<TreeNode>(16);
        if (CollectionUtils.isEmpty(apps)) {
            return filterApps;
        }
        if (!this.isNeedFilter) {
            filterApps.addAll(apps);
            return filterApps;
        }
        for (TreeNode app : apps) {
            String id = app.getId();
            if (CollectionUtils.isNotEmpty(this.disabledAppIds) && this.disabledAppIds.contains(id) || this.adminAppResult != null && this.adminAppResult.needAdminAppRange() && !this.adminAppResult.getAppIds().contains(id)) continue;
            filterApps.add(app);
        }
        return filterApps;
    }

    public boolean isDisableCloud(String cloudId) {
        if (this.isNeedFilter && StringUtils.isNotBlank((CharSequence)cloudId)) {
            return CollectionUtils.isNotEmpty(this.disabledCloudIds) && this.disabledCloudIds.contains(cloudId);
        }
        return false;
    }

    public boolean isDisableApp(String appId) {
        if (this.isNeedFilter && StringUtils.isNotBlank((CharSequence)appId)) {
            return CollectionUtils.isNotEmpty(this.disabledAppIds) && this.disabledAppIds.contains(appId) || this.adminAppResult != null && this.adminAppResult.needAdminAppRange() && !this.adminAppResult.getAppIds().contains(appId);
        }
        return false;
    }

    private static boolean isUseNewAppInfo() {
        Map customParameter = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        return Boolean.parseBoolean(customParameter.getOrDefault("SVC_IS_USE_NEW_APP_INFO", "true"));
    }

    public static enum FilterTypeEnum {
        ONLY_APP,
        ONLY_CLOUD;

    }
}

