/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.util.print;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.ILoginUserService;
import kd.bos.login.service.dto.AppType;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.svc.util.FileServerUtil;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileUtils;

public class PrintFileUtil {
    private static final DistributeSessionlessCache distributeCache = AclAdapter.getCacheService().getDistributeSessionlessCache("CachePrtRegion");
    private static final Log log = LogFactory.getLog(PrintFileUtil.class);

    public static String normalize(String fileUrl) {
        return FileUtils.checkFileUrl((String)fileUrl);
    }

    public static String byteToTempUrl(String fileName, String appId, String formId, byte[] pdfByte) {
        return PrintFileUtil.byteToTempUrl(fileName, appId, formId, pdfByte, true);
    }

    public static String byteToTempUrl(String fileName, String appId, String formId, byte[] pdfByte, boolean isFullPath) {
        String downloadUrl = null;
        if (pdfByte == null || pdfByte.length <= 0) {
            return downloadUrl;
        }
        if (fileName.endsWith(".pdf")) {
            return PrintFileUtil.saveAsPrintTempUrl(new ByteArrayInputStream(pdfByte), fileName, isFullPath);
        }
        Map cp = CacheFactory.getCommonCacheFactory().getTempFileCache().save(fileName, pdfByte, 7200);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", RequestContext.get().getUserId());
        map.put("formId", formId);
        map.put("appId", appId);
        distributeCache.put("PrintCheckId:" + (String)cp.get("id"), (Object)SerializationUtils.toJsonString(map), 7200);
        String url = "tempfile/%s.do?configKey=%s&id=%s";
        url = String.format(url, "download", cp.get("configKey"), cp.get("id"));
        if (!isFullPath) {
            return url;
        }
        String fullPath = UrlService.getDomainContextUrl();
        downloadUrl = fullPath.endsWith("/") ? fullPath + url : fullPath + "/" + url;
        return downloadUrl;
    }

    public static String saveAsPrintTempUrl(InputStream in, String fileName, boolean isFullPath) {
        AppType appType;
        PrtTaskResult taskResult = new PrtTaskResult();
        String taskId = String.valueOf(ID.genLongId());
        taskResult.setTaskId(taskId);
        taskResult.setTemp(true);
        taskResult.setDiskType("2");
        taskResult.setUserId(RequestContext.get().getUserId());
        taskResult.setTaskName("task-" + fileName);
        String path = PrintFileUtil.saveInputStream2TempFile(fileName, in, 7200);
        String attachId = String.valueOf(ID.genLongId());
        PrtTaskResult.Attach attach = new PrtTaskResult.Attach();
        attach.setAttachId(attachId);
        attach.setFileName(fileName);
        attach.setFilePath(path);
        taskResult.addAttach(attach);
        PrtTaskResultServiceHelper.savePrtResult(taskResult);
        String url = "print/download.do?tempAttach=true&taskId=%s&attachId=%s";
        if (StringUtils.isNotBlank((CharSequence)fileName) && fileName.endsWith(".pdf") && AppType.DingTalk == (appType = ((ILoginUserService)ServiceFactory.getService(ILoginUserService.class)).getAppTypeFromSession(RequestContext.get().getGlobalSessionId()))) {
            url = url + "&downloadAttach=true";
        }
        url = String.format(url, taskId, attachId);
        if (!isFullPath) {
            return url;
        }
        String fullPath = UrlService.getDomainContextUrl();
        String downloadUrl = fullPath.endsWith("/") ? fullPath + url : fullPath + "/" + url;
        return downloadUrl;
    }

    public static String getDomainContextUrl() {
        String fullPath = RequestContext.get().getClientFullContextPath();
        if (fullPath == null) {
            fullPath = UrlService.getDomainContextUrlByTenantCode((String)RequestContext.get().getTenantCode());
        }
        if (!fullPath.endsWith("/")) {
            fullPath = fullPath + "/";
        }
        return fullPath;
    }

    public static InputStream getFileInputStream(String filePath, String fileStorageType) {
        if ("2".equals(fileStorageType)) {
            TempFileCacheDownloadable cache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            Map<String, String> param = PrintFileUtil.parsePatch(filePath);
            InputStream inputStream = null;
            try {
                TempFileCacheDownloadable.Content content = cache.get(param.get("configKey"), param.get("id"));
                if (content == null) {
                    return null;
                }
                inputStream = content.getInputStream();
            }
            catch (Exception e) {
                log.error("\u4e34\u65f6\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\uff0cfilePath={}", (Object)filePath, (Object)e);
                throw new KDBizException("file is not exist or is expired.");
            }
            return inputStream;
        }
        InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(filePath);
        return inputStream;
    }

    public static InputStream getFileInputStream(String filePath) {
        Map<String, String> param = PrintFileUtil.parsePatch(filePath);
        if (!param.isEmpty()) {
            return PrintFileUtil.getFileInputStream(filePath, "2");
        }
        return PrintFileUtil.getFileInputStream(filePath, "0");
    }

    public static String saveInputStream2TempFile(String fileName, InputStream inputStream, int timeout) {
        Map cp = CacheFactory.getCommonCacheFactory().getTempFileCache().save(fileName, inputStream, timeout);
        String path = String.format("configKey=%s&id=%s", cp.get("configKey"), cp.get("id"));
        return path;
    }

    public static String bytesToFileUrl(String fileFullName, byte[] pdfByte) {
        return PrintFileUtil.saveInputStream2FileServer(fileFullName, new ByteArrayInputStream(pdfByte));
    }

    public static String saveInputStream2FileServer(String fileFullName, InputStream inputStream) {
        String baseDir = PrintFileUtil.genFilePath();
        String suffix = fileFullName.substring(fileFullName.lastIndexOf(46));
        String fileName = UUID.randomUUID() + suffix;
        FileItemExt fileItem = FileServerUtil.createFileItem(fileFullName, baseDir + fileName, inputStream, FileSource.PRINT_TPL);
        fileItem.setCreateNewFileWhenExists(true);
        String path = FileServiceFactory.getAttachmentFileService().upload((FileItem)fileItem);
        return path;
    }

    private static String genFilePath() {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
        String dateStr = simpleDateFormat.format(cale.getTime());
        RequestContext rc = RequestContext.getOrCreate();
        String baseDir = "/%s/%s/printfile/%s/%s/";
        baseDir = String.format(baseDir, rc.getTenantId(), rc.getAccountId(), dateStr, rc.getCurrUserId());
        return baseDir;
    }

    private static Map<String, String> parsePatch(String path) {
        try {
            String[] pairs = path.split("&");
            HashMap<String, String> m = new HashMap<String, String>(pairs.length);
            String[] var5 = pairs;
            int var6 = pairs.length;
            for (int var7 = 0; var7 < var6; ++var7) {
                String pair = var5[var7];
                String[] p = pair.split("=");
                m.put(p[0], p[1]);
            }
            return m;
        }
        catch (Exception exception) {
            return Collections.emptyMap();
        }
    }
}

