/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.util.print;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.mservice.form.FormService;
import kd.bos.service.ServiceFactory;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.web.DispatchServiceHelper;

public class PrintPermissionUtil {
    private static final DistributeSessionlessCache distributeCache = AclAdapter.getCacheService().getDistributeSessionlessCache("CachePrtPermission");
    private static final Log log = LogFactory.getLog(PrintPermissionUtil.class);
    private static String RC_PERMISSION_V = "1";

    private static String getCacheType() {
        return "PRT_PERMI_" + RequestContext.get().getCurrUserId();
    }

    public static void setMetaRcPermission(List<String> rcIds) {
        if (rcIds == null || rcIds.isEmpty()) {
            return;
        }
        HashMap<String, String> hm = new HashMap<String, String>(4);
        for (String rcId : rcIds) {
            hm.put(rcId, "1");
        }
        distributeCache.put(PrintPermissionUtil.getCacheType(), hm, 3, TimeUnit.MINUTES);
    }

    public static boolean checkMetaRcPermission(String rcId) {
        String cacheType = PrintPermissionUtil.getCacheType();
        String cacheData = (String)distributeCache.get(cacheType, rcId);
        if (cacheData == null) {
            return false;
        }
        return RC_PERMISSION_V.equals(cacheData);
    }

    public static boolean checkPermission(boolean isMobile, PrtTaskResult prtResult) {
        String userId = prtResult.getUserId();
        String formId = prtResult.getFormId();
        String appId = prtResult.getAppId();
        if (isMobile) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)userId, (CharSequence)String.valueOf(RequestContext.get().getCurrUserId()))) {
            log.info("curUserId:" + RequestContext.get().getCurrUserId() + "------userId:" + userId);
            return false;
        }
        if (prtResult.isTemp() && StringUtils.isBlank((CharSequence)appId)) {
            return true;
        }
        IAttachmentService service = (IAttachmentService)ServiceFactory.getService(IAttachmentService.class);
        boolean checkTempFilePermission = service.checkFilePermission();
        if (!checkTempFilePermission) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            Object hasPermission;
            String routeAppId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
            if (StringUtils.isBlank((CharSequence)appId)) {
                appId = routeAppId;
            }
            if (StringUtils.isBlank((CharSequence)routeAppId)) {
                routeAppId = "bos";
            }
            if ((hasPermission = DispatchServiceHelper.invokeBOSServiceByAppId((String)routeAppId, (String)"PermissionService", (String)"checkPermission", (Object[])new Object[]{Long.parseLong(userId), appId, formId, "4730fc9e000000ac"})) instanceof Boolean) {
                return (Boolean)hasPermission;
            }
            return false;
        }
        return true;
    }
}

