/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.util.print;

import java.util.Date;
import java.util.List;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.svc.util.print.PrtTaskResult;

public class PrtTaskResultServiceHelper {
    private static Log log = LogFactory.getLog(PrtTaskResultServiceHelper.class);
    private static DistributeSessionlessCache distributeCache = AclAdapter.getCacheService().getDistributeSessionlessCache("CachePrtRegion");
    private static final String PRTRESULT_FORMID = "bos_print_result";
    private static final String PRTRESULT_DETAIL_FORMID = "bos_print_result_detail";

    public static PrtTaskResult getPrtResult(String taskId) {
        PrtTaskResult prtTaskResult = PrtTaskResultServiceHelper.getPrtResultFromCache(taskId);
        if (prtTaskResult == null) {
            prtTaskResult = PrtTaskResultServiceHelper.getPrtResultFromDb(taskId);
        }
        return prtTaskResult;
    }

    public static PrtTaskResult getPrtResult(String taskId, boolean isTemp) {
        if (isTemp) {
            return PrtTaskResultServiceHelper.getPrtResultFromCache(taskId);
        }
        return PrtTaskResultServiceHelper.getPrtResultFromDb(taskId);
    }

    public static Tuple<PrtTaskResult, PrtTaskResult.Attach> loopGetPrtResult(String attachId, long loopTimeMillis) {
        PrtTaskResult prtResult = null;
        PrtTaskResult.Attach attach = null;
        long startTime = System.currentTimeMillis();
        int tryNum = 0;
        while (System.currentTimeMillis() - startTime < loopTimeMillis) {
            prtResult = PrtTaskResultServiceHelper.getPrtResult(attachId, true);
            ++tryNum;
            if (prtResult == null) {
                try {
                    Thread.sleep(Math.min(100 * tryNum, 1000));
                }
                catch (InterruptedException e) {
                    log.error((Throwable)e);
                }
                continue;
            }
            attach = prtResult.getAttach().stream().filter(f -> attachId.equals(f.getAttachId())).findAny().orElse(null);
            if (attach == null) continue;
            break;
        }
        return Tuple.create(prtResult, attach);
    }

    public static void savePrtResult(PrtTaskResult prtTaskResult) {
        if (prtTaskResult.isTemp()) {
            distributeCache.put(prtTaskResult.getTaskId(), (Object)SerializationUtils.toJsonString((Object)prtTaskResult), 7200);
            return;
        }
        String taskId = prtTaskResult.getTaskId();
        long pkId = Long.parseLong(taskId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)PRTRESULT_FORMID);
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)PRTRESULT_FORMID);
            dynamicObject.set("id", (Object)pkId);
            dynamicObject.set("taskid", (Object)taskId);
            dynamicObject.set("creator", (Object)prtTaskResult.getUserId());
            dynamicObject.set("org", (Object)prtTaskResult.getOrgId());
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("appid", (Object)prtTaskResult.getAppId());
            dynamicObject.set("formid", (Object)prtTaskResult.getFormId());
            dynamicObject.set("disktype", (Object)prtTaskResult.getDiskType());
            if (!StringUtils.isBlank((CharSequence)prtTaskResult.getTaskName())) {
                dynamicObject.set("taskname", (Object)prtTaskResult.getTaskName());
            }
            if (!StringUtils.isBlank((CharSequence)prtTaskResult.getExtType())) {
                dynamicObject.set("exptype", (Object)prtTaskResult.getExtType());
            }
            if (!StringUtils.isBlank((CharSequence)prtTaskResult.getServiceN())) {
                dynamicObject.set("servicen", (Object)prtTaskResult.getServiceN());
            }
            if (!StringUtils.isBlank((CharSequence)prtTaskResult.getPrinter())) {
                dynamicObject.set("printer", (Object)prtTaskResult.getPrinter());
            }
            if (!StringUtils.isBlank((CharSequence)prtTaskResult.getStatus())) {
                dynamicObject.set("status", (Object)prtTaskResult.getStatus());
            }
        }
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(PRTRESULT_DETAIL_FORMID);
        List<PrtTaskResult.Attach> detailList = prtTaskResult.getAttach();
        if (detailList != null && detailList.size() > 0) {
            int size = dynamicObjectCollection.size() + 1;
            MainEntityType dataEntityType = (MainEntityType)dynamicObject.getDataEntityType();
            EntityType entityType = (EntityType)dataEntityType.getAllEntities().get(PRTRESULT_DETAIL_FORMID);
            for (PrtTaskResult.Attach detail : detailList) {
                DynamicObject entryObj = new DynamicObject((DynamicObjectType)entityType, null);
                entryObj.set("seq", (Object)size);
                entryObj.set("filename", (Object)detail.getFileName());
                entryObj.set("filepath", (Object)detail.getFilePath());
                entryObj.set("filetype", (Object)detail.getFileType());
                entryObj.set("source", (Object)detail.getSource());
                dynamicObjectCollection.add((Object)entryObj);
                ++size;
            }
        }
        try (TXHandle h = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private static PrtTaskResult getPrtResultFromCache(String taskId) {
        String str = (String)distributeCache.get(taskId);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            PrtTaskResult printReult = (PrtTaskResult)SerializationUtils.fromJsonString((String)str, PrtTaskResult.class);
            printReult.setTemp(true);
            return printReult;
        }
        return null;
    }

    private static PrtTaskResult getPrtResultFromDb(String taskId) {
        PrtTaskResult prtTaskResult = new PrtTaskResult();
        prtTaskResult.setTaskId(taskId);
        long pkId = Long.parseLong(taskId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)PRTRESULT_FORMID);
        if (dynamicObject == null) {
            return prtTaskResult;
        }
        prtTaskResult.setFormId(dynamicObject.getString("formid"));
        prtTaskResult.setAppId(dynamicObject.getString("appid"));
        prtTaskResult.setOrgId(String.valueOf(dynamicObject.get("org_id")));
        prtTaskResult.setUserId(String.valueOf(dynamicObject.get("creator_id")));
        prtTaskResult.setDiskType(dynamicObject.getString("disktype"));
        prtTaskResult.setTaskName(dynamicObject.getString("taskname"));
        prtTaskResult.setExtType(dynamicObject.getString("exptype"));
        prtTaskResult.setServiceN(dynamicObject.getString("servicen"));
        prtTaskResult.setPrinter(dynamicObject.getString("printer"));
        prtTaskResult.setStatus(dynamicObject.getString("status"));
        DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection(PRTRESULT_DETAIL_FORMID);
        for (DynamicObject obj : collection) {
            PrtTaskResult.Attach attach = new PrtTaskResult.Attach();
            String filepath = obj.getString("filepath");
            attach.setFilePath(filepath);
            attach.setAttachId(String.valueOf(obj.get("id")));
            attach.setSource(obj.getString("source"));
            attach.setFileName(obj.getString("filename"));
            prtTaskResult.addAttach(attach);
        }
        return prtTaskResult;
    }
}

