/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.util.print;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class UpdateLocalNameUtil {
    private static final Log logger = LogFactory.getLog(UpdateLocalNameUtil.class);

    public static void updateManageOldTplNameAndNumber(String printMetaId) {
        try {
            QFilter qFilter = new QFilter("id", "=", (Object)printMetaId);
            DynamicObject formMeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id,number,bizappid,basedatafield,modifierid", (QFilter[])new QFilter[]{qFilter});
            if (formMeta == null) {
                return;
            }
            ILocaleString name = formMeta.getLocaleString("name");
            String number = formMeta.getString("number");
            UpdateLocalNameUtil.updateManageOldTplNameAndNumber(printMetaId, (Map)name, number);
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    public static void updateManageOldTplNameAndNumber(String printMetaId, Map name, String number) {
        DynamicObject dynamicObject;
        Throwable throwable;
        TXHandle h;
        block17: {
            block18: {
                block19: {
                    h = TX.requiresNew();
                    throwable = null;
                    String updateSql = "update %s set  fnumber = ? where fprinttplid = ?";
                    Object[] params = new SqlParameter[]{new SqlParameter("fnumber", 12, (Object)number), new SqlParameter("fprinttplid", 12, (Object)printMetaId)};
                    updateSql = String.format(updateSql, "t_bas_printtplinfo");
                    DB.execute((DBRoute)DBRoute.basedata, (String)updateSql, (Object[])params);
                    dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_manageprinttpl", (String)"id", (QFilter[])new QFilter[]{new QFilter("printtplid", "=", (Object)printMetaId)});
                    if (dynamicObject != null) break block17;
                    if (h == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        h.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                h.close();
            }
            return;
        }
        try {
            try {
                UpdateLocalNameUtil.updateLocaleName(dynamicObject.getPkValue(), 12, name, "t_bas_printtplinfo_l");
                DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_bas_printtplinfo");
                cacheManager.removeByPrimaryKey(new Object[]{dynamicObject.getPkValue()});
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (h != null) {
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    h.close();
                }
            }
        }
    }

    public static void updateLocaleName(Object id, int idType, Map localeName, String metaTableL) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                UpdateLocalNameUtil.deleteDataById(id, idType, metaTableL);
                UpdateLocalNameUtil.insertManageTplLocalName(id, idType, localeName, metaTableL);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
            }
        }
    }

    private static void deleteDataById(Object id, int idType, String metaTableL) {
        String sql = "delete from %s where fid=?";
        sql = String.format(sql, metaTableL);
        Object[] params = new SqlParameter[]{new SqlParameter("fid", idType, id)};
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
    }

    private static void insertManageTplLocalName(Object id, int idType, Map localeName, String metaTableL) {
        if (localeName == null) {
            return;
        }
        String insertNameSql = "insert into %s (fpkid,fid,flocaleid,fname) values (?,?,?,?)";
        insertNameSql = String.format(insertNameSql, metaTableL);
        ArrayList paramsList = new ArrayList(2);
        localeName.forEach((key, value) -> {
            String pkId = DB.genStringId((String)metaTableL);
            SqlParameter[] sqlParameters = new SqlParameter[]{new SqlParameter("fpkid", 12, (Object)pkId), new SqlParameter("fid", idType, id), new SqlParameter("flocaleid", 12, key), new SqlParameter("fname", 12, value)};
            paramsList.add(sqlParameters);
        });
        if (!CollectionUtils.isEmpty(paramsList)) {
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertNameSql, paramsList);
        }
    }

    public static void updateLocaleData(Object id, int idType, Map localeName, Map<String, String> localeDataMap, String metaTableL) {
        if (localeName == null || localeDataMap == null) {
            return;
        }
        Set<String> localIds = UpdateLocalNameUtil.queryLocalIds(id, idType, metaTableL);
        ArrayList insertParams = new ArrayList(5);
        ArrayList insertNoDataParams = new ArrayList(5);
        ArrayList updateParams = new ArrayList(5);
        ArrayList updateNoDataParams = new ArrayList(5);
        String insertSql = String.format("insert into %s (fpkid,fid,flocaleid,fname,fdata) values (?,?,?,?,?)", metaTableL);
        String insertNoDataSql = String.format("insert into %s (fpkid,fid,flocaleid,fname) values (?,?,?,?)", metaTableL);
        String updateSql = String.format("update %s set fname = ?, fdata = ? where fid = ? and flocaleid = ?", metaTableL);
        String updateNoDataSql = String.format("update %s set fname = ? where fid = ? and flocaleid = ?", metaTableL);
        localeName.forEach((lang, nameValue) -> {
            String data = (String)localeDataMap.get(lang);
            if (data == null) {
                if (localIds.contains(lang)) {
                    SqlParameter[] sqlParameters = new SqlParameter[]{new SqlParameter("fname", 12, nameValue), new SqlParameter("fid", 12, id), new SqlParameter("flocaleid", 12, lang)};
                    updateNoDataParams.add(sqlParameters);
                } else {
                    String pkId = DB.genStringId((String)metaTableL);
                    SqlParameter[] sqlParameters = new SqlParameter[]{new SqlParameter("fpkid", 12, (Object)pkId), new SqlParameter("fid", idType, id), new SqlParameter("flocaleid", 12, lang), new SqlParameter("fname", 12, nameValue)};
                    insertNoDataParams.add(sqlParameters);
                }
            } else if (localIds.contains(lang)) {
                SqlParameter[] sqlParameters = new SqlParameter[]{new SqlParameter("fname", 12, nameValue), new SqlParameter("fdata", -16, (Object)data), new SqlParameter("fid", 12, id), new SqlParameter("flocaleid", 12, lang)};
                updateParams.add(sqlParameters);
            } else {
                String pkId = DB.genStringId((String)metaTableL);
                SqlParameter[] sqlParameters = new SqlParameter[]{new SqlParameter("fpkid", 12, (Object)pkId), new SqlParameter("fid", idType, id), new SqlParameter("flocaleid", 12, lang), new SqlParameter("fname", 12, nameValue), new SqlParameter("fdata", -16, (Object)data)};
                insertParams.add(sqlParameters);
            }
        });
        try (TXHandle tx = TX.required();){
            if (!CollectionUtils.isEmpty(insertParams)) {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, insertParams);
            }
            if (!CollectionUtils.isEmpty(insertNoDataParams)) {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertNoDataSql, insertNoDataParams);
            }
            if (!CollectionUtils.isEmpty(updateParams)) {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)updateSql, updateParams);
            }
            if (!CollectionUtils.isEmpty(updateNoDataParams)) {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)updateNoDataSql, updateNoDataParams);
            }
        }
    }

    private static Set<String> queryLocalIds(Object id, int idType, String metaTableL) {
        String select = String.format("select fid,flocaleid from %s where fid = ?", metaTableL);
        return (Set)DB.query((DBRoute)DBRoute.basedata, (String)select, (Object[])new SqlParameter[]{new SqlParameter("fid", idType, id)}, res -> {
            HashSet<String> localSet = new HashSet<String>(8);
            while (res.next()) {
                localSet.add(res.getString(2));
            }
            return localSet;
        });
    }
}

