/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions.utils;

import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FilePathUtil {
    private static String[] illegalChars = new String[]{"../", "..\\", "<", ">", "\""};
    private static Log log = LogFactory.getLog(FilePathUtil.class);

    public static String dealPathParam(String path) {
        if (FilePathUtil.containsIllegalChar(path).booleanValue()) {
            throw new KDException(new ErrorCode("ILLEGAL_PATH", "PATH_CONTAINS_ILLEGAL_CHAR"), new Object[0]);
        }
        if (path.contains("&kdedcba=")) {
            path = path.substring(0, path.lastIndexOf("&kdedcba="));
        }
        if (path.contains("?v=1")) {
            path = path.replace("?v=1.0", "");
            path = path.replace("?v=1", "");
        }
        if (path.contains("?v=0.5")) {
            path = path.replace("?v=0.5", "");
        }
        return path;
    }

    public static String dealPath(String path, String source) {
        path = FilePathUtil.dealPathParam(path);
        path = "image".equals(source) ? FileServiceExtFactory.getImageFileServiceExt().getRealPath(path) : FileServiceExtFactory.getAttachFileServiceExt().getRealPath(path);
        log.info("kd.bos.web.actions.utils.FilePathUtil.dealPath\uff1a" + path);
        if (FilePathUtil.containsIllegalChar(path).booleanValue()) {
            throw new KDException(new ErrorCode("ILLEGAL_PATH", "PATH_CONTAINS_ILLEGAL_CHAR"), new Object[0]);
        }
        return path;
    }

    private static Boolean containsIllegalChar(String path) {
        if (path == null) {
            return Boolean.FALSE;
        }
        for (String illegalChar : illegalChars) {
            if (!path.contains(illegalChar)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String getFileExt(String filename) {
        if (filename == null || !filename.contains(".") || filename.endsWith(".")) {
            return filename;
        }
        return filename.substring(filename.lastIndexOf(".") + 1);
    }
}

