/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.mservice.attachment.SyncStatus;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.web.DispatchServiceHelper;

public class FilePremissionUtil {
    private static Log log = LogFactory.getLog(FilePremissionUtil.class);
    private static final String STATUS = "status";
    private static final String DESCRIPTION = "description";
    private static final String ERROR = "error";
    private static final String BOS_SVC_COMMON = "bos-svc-common";
    private static final String ATT_ENTRYGRID_UPLOADVIEW_FORMID = "bos_entryattach_upload";
    private static final String ATT_FIELD_MOB = "bos_mobtb_attfield_upload";
    private static final String PRINT_CHECKID = "PrintCheckId:";
    private static final String ATTATCHMENT_CHECKID = "TempFileCheckId:";
    private static final String REPORT_CHECKID = "ReportTempFileCheckId:";
    protected static final String ID_MAP_KEY = "id";
    private static final String PERM_BIZOBJAPP = "perm_bizobjapp";
    private static final String BIZAPP = "bizapp";
    private static final String ENTITY_BOS_BILL_FILE_MAPPING = "bos_bill_file_mapping";
    private static final Map<String, String> permItemMapping = new HashMap<String, String>(11);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    public static String checkFilePremission(Map<String, Object> param) throws UnsupportedEncodingException {
        String permItem;
        String path = param.get("path") != null ? (String)param.get("path") : "";
        String string = permItem = param.get("permItem") != null ? (String)param.get("permItem") : "";
        if (StringUtils.isNotBlank((CharSequence)path)) {
            List<Object> refEntityList = new ArrayList(10);
            if (path.contains("tempfile/download.do?configKey")) {
                boolean checkTempFilePermission = Boolean.parseBoolean(String.valueOf(DispatchServiceHelper.invokeBOSService((String)IAttachmentService.class.getSimpleName(), (String)"checkTempFilePermission", (Object[])new Object[0])));
                if (!checkTempFilePermission) {
                    return path;
                }
                String string2 = path.split("id=")[1];
                String checkIdValue = (String)cache.get(ATTATCHMENT_CHECKID + string2);
                if (StringUtils.isNotBlank((CharSequence)checkIdValue)) {
                    Map refEntitiyMap = (Map)SerializationUtils.fromJsonString((String)checkIdValue, Map.class);
                    refEntitiyMap.put("permItem", permItem);
                    refEntityList.add(refEntitiyMap);
                }
            } else {
                boolean checkFilePermission = Boolean.parseBoolean(String.valueOf(DispatchServiceHelper.invokeBOSService((String)IAttachmentService.class.getSimpleName(), (String)"checkFilePermission", (Object[])new Object[0])));
                if (!checkFilePermission) {
                    return path;
                }
                while (path.contains("//")) {
                    path = path.replaceAll("//", "/");
                }
                refEntityList = FilePremissionUtil.getFileRefListByPath(path, Boolean.TRUE);
            }
            for (Map map : refEntityList) {
                map.put("permItem", permItem);
            }
            if (!FilePremissionUtil.hasEntityPermission(refEntityList).booleanValue()) {
                throw new KDException(new ErrorCode("NO Permission!", ResManager.loadKDString((String)"\u65e0\u8bbf\u95ee\u6743\u9650!", (String)"AttachmentAction_11", (String)"bos-webactions", (Object[])new Object[0])), new Object[0]);
            }
        }
        return path;
    }

    public static List<Map<String, Object>> getFileRefListByPath(String path, Boolean syncWriteMapping) {
        DynamicObject[] billFillMappings;
        ArrayList<Map<String, Object>> refEntityList = new ArrayList<Map<String, Object>>();
        QFilter pathEquals = new QFilter("path", "=", (Object)path);
        QFilter syncStatusEquals = new QFilter("syncStatus", "=", (Object)SyncStatus.Success.getValue());
        QFilter[] qFilters = new QFilter[]{pathEquals, syncStatusEquals};
        String selectFields = "APPID,BIZOBJ,BILLPKID";
        for (DynamicObject fileBillMapping : billFillMappings = BusinessDataServiceHelper.load((String)ENTITY_BOS_BILL_FILE_MAPPING, (String)selectFields, (QFilter[])qFilters)) {
            HashMap<String, Object> refEntitiyMap = new HashMap<String, Object>(2);
            DynamicObject bizobj = fileBillMapping.getDynamicObject("BIZOBJ");
            if (bizobj == null) continue;
            String entityNum = bizobj.getString("NUMBER");
            refEntitiyMap.put("entityNum", entityNum);
            refEntitiyMap.put("billPkId", fileBillMapping.get("billpkid"));
            refEntityList.add(refEntitiyMap);
        }
        if (billFillMappings.length == 0 && syncWriteMapping.booleanValue()) {
            BillFileMappingWriter.syncWriteFileBillMapping(path);
        }
        return refEntityList;
    }

    public static Boolean hasEntityPermission(List<Map<String, Object>> refEntityList) {
        boolean checkFilePermission = Boolean.parseBoolean(String.valueOf(DispatchServiceHelper.invokeBOSService((String)IAttachmentService.class.getSimpleName(), (String)"checkFilePermission", (Object[])new Object[0])));
        long curUserId = RequestContext.get().getCurrUserId();
        log.info("checkFilePermission : " + checkFilePermission + " ; curUserId : " + curUserId + " ; attRefEntityKeyList : " + SerializationUtils.toJsonString(refEntityList));
        if (!checkFilePermission) {
            return Boolean.TRUE;
        }
        if (-1L == curUserId) {
            return Boolean.TRUE;
        }
        Boolean hasPermission = Boolean.FALSE;
        if (refEntityList.size() == 0 || refEntityList.get(0).size() == 0) {
            return Boolean.TRUE;
        }
        String entityNum = (String)refEntityList.get(0).get("entityNum");
        Object permItemObj = refEntityList.get(0).get("permItem");
        String permItem = null;
        if (permItemObj instanceof String) {
            permItem = (String)permItemObj;
        }
        if (StringUtils.isBlank((CharSequence)entityNum) || StringUtils.isBlank((CharSequence)permItem)) {
            log.info("kd.bos.web.actions.handler.ImportAttachHandle.handler --- entityNum = " + entityNum + " --- ,permItem = " + permItem);
            throw new KDException(new ErrorCode("NO Permission!", ResManager.loadKDString((String)"\u65e0\u8bbf\u95ee\u6743\u9650!", (String)"AttachmentAction_11", (String)"bos-webactions", (Object[])new Object[0])), new Object[0]);
        }
        log.info("begin check --- curUserId : " + curUserId + " ; checkEntityKeyList : " + SerializationUtils.toJsonString(refEntityList));
        hasPermission = FilePremissionUtil.doCheckPermission(refEntityList, curUserId, hasPermission, false);
        log.info("hasPermission : " + hasPermission + " ; curUserId : " + curUserId);
        return hasPermission;
    }

    private static Boolean doCheckPermission(List<Map<String, Object>> refEntityList, long curUserId, Boolean hasPermission, boolean isTempDownload) {
        for (Map<String, Object> entity : refEntityList) {
            try {
                if (isTempDownload && entity.containsKey("permissionItemId") && StringUtils.isBlank((Object)entity.get("permissionItemId"))) {
                    return Boolean.TRUE;
                }
                Object billPkIdCheck = entity.get("billPkId");
                List<Object> billPkIdList = FilePremissionUtil.convertBillPkId(billPkIdCheck);
                String entityNumCheck = (String)entity.get("entityNum");
                String permItemCheck = isTempDownload ? (entity.get("permissionItemId") == null ? "2NJ5XVVCMBCL" : (String)entity.get("permissionItemId")) : String.valueOf(entity.get("permItem"));
                Set<String> permissionCheckSet = FilePremissionUtil.convertPermItem(permItemCheck);
                Map permMap = PermissionServiceHelper.checkMultiPermItemInfos((long)curUserId, (String)entityNumCheck, permissionCheckSet);
                log.info("checkFunctionPermission : permMap = " + permMap);
                Boolean hasDataPermission = FilePremissionUtil.checkDataPermission(curUserId, entityNumCheck, billPkIdCheck, permItemCheck, billPkIdList);
                if (!((Boolean)permMap.get(permItemCheck)).booleanValue() || !hasDataPermission.booleanValue()) continue;
                hasPermission = Boolean.TRUE;
                break;
            }
            catch (Exception e) {
                log.error("FilePremissionUtil.doCheckPermission() occur Exception: " + e.getMessage(), (Throwable)e);
            }
        }
        return hasPermission;
    }

    private static Boolean checkDataPermission(long curUserId, String entityNum, Object billPkId, String permItem, List<Object> billPkIdList) {
        if (billPkIdList.size() > 0) {
            return FilePremissionUtil.doCheckDataPerm(curUserId, entityNum, billPkId, permItem, billPkIdList);
        }
        return true;
    }

    private static Boolean doCheckDataPerm(long curUserId, String entityNum, Object billPkId, String permItem, List<Object> billPkIdList) {
        log.info("checkDataPermission : curUserId = " + curUserId + " ; appId = " + FilePremissionUtil.getAppId(entityNum) + " ; entityNumCheck = " + entityNum + " ; billPkIdList = " + billPkIdList);
        Map dataPermMap = (Map)DispatchServiceHelper.invokeBOSServiceByAppId((String)FilePremissionUtil.getAppId(entityNum), (String)"PermissionService", (String)"checkOperationRule", (Object[])new Object[]{curUserId, entityNum, "view", billPkIdList, new StringBuilder()});
        log.info("checkDataPermission : operationKey = view ; dataPermMap = " + dataPermMap);
        Boolean hasDataPermission = (Boolean)dataPermMap.get(billPkId);
        if (("2NJ5SR4NUEJ=".equals(permItem) || "2NJ5YJOIS+MJ".equals(permItem) || "2NJ5W8AA040D".equals(permItem) || "2NJ5ZK67OB2T".equals(permItem)) && Boolean.TRUE.equals(hasDataPermission)) {
            dataPermMap = (Map)DispatchServiceHelper.invokeBOSServiceByAppId((String)FilePremissionUtil.getAppId(entityNum), (String)"PermissionService", (String)"checkOperationRule", (Object[])new Object[]{curUserId, entityNum, "modify", billPkIdList, new StringBuilder()});
            log.info("checkDataPermission : operationKey = modify ; dataPermMap = " + dataPermMap);
            hasDataPermission = (Boolean)dataPermMap.get(billPkId);
        }
        return hasDataPermission;
    }

    private static String getAppId(String entityNum) {
        String appInnerId = BizAppServiceHelp.getAppIdByFormNum((String)entityNum);
        if (StringUtils.isBlank((CharSequence)appInnerId)) {
            return "bos";
        }
        String appId = MetadataDao.getAppNumberByAppId((String)appInnerId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            return "bos";
        }
        return appId;
    }

    private static List<Object> convertBillPkId(Object billPkId) {
        ArrayList<Object> billPkIdList = new ArrayList<Object>();
        if (StringUtils.isBlank((Object)billPkId) || "0".equals(billPkId.toString())) {
            return billPkIdList;
        }
        billPkIdList.add(billPkId);
        return billPkIdList;
    }

    private static Set<String> convertPermItem(String permItem) {
        HashSet<String> permSet = new HashSet<String>();
        permSet.add(permItem);
        return permSet;
    }

    public static Boolean checkUploadPermission(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return FilePremissionUtil.checkUploadPermission(request, response, "", "", "");
    }

    public static Boolean checkUploadPermission(HttpServletRequest request, HttpServletResponse response, String appId, String entityNum, String permItem) throws IOException {
        return FilePremissionUtil.checkUploadPermission(request, response, appId, entityNum, permItem, null);
    }

    public static Boolean checkUploadPermission(HttpServletRequest request, HttpServletResponse response, String appId, String entityNum, String permItem, FileItem fileItem) throws IOException {
        String pageId = "";
        Object billPkId = "";
        if (fileItem != null) {
            pageId = fileItem.getPageId();
        }
        billPkId = FilePremissionUtil.genBillPkId(pageId);
        boolean checkFilePermission = Boolean.parseBoolean(String.valueOf(DispatchServiceHelper.invokeBOSService((String)IAttachmentService.class.getSimpleName(), (String)"checkFilePermission", (Object[])new Object[0])));
        if (!checkFilePermission) {
            return Boolean.TRUE;
        }
        if (StringUtils.isEmpty((CharSequence)pageId) && StringUtils.isBlank((CharSequence)(pageId = request.getHeader("pageId")))) {
            pageId = request.getParameter("pageId");
        }
        if (StringUtils.isBlank((CharSequence)(appId = request.getHeader("appId")))) {
            appId = request.getParameter("appId");
        }
        if (FilePremissionUtil.tryGetHasRightValue(pageId, appId)) {
            return Boolean.TRUE;
        }
        ArrayList<Map<String, Object>> refEntityList = new ArrayList<Map<String, Object>>();
        if (StringUtils.isBlank((CharSequence)entityNum)) {
            entityNum = request.getParameter("fId");
        }
        if (StringUtils.isBlank((CharSequence)entityNum)) {
            log.info("kd.bos.web.actions.utils.FilePermissionUtil.checkUploadPermission --- entityNum = " + entityNum);
            return Boolean.TRUE;
        }
        entityNum = FilePremissionUtil.getRealEntityNum(entityNum);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("entityNum", entityNum);
        param.put("billPkId", billPkId);
        param.put("permItem", permItem);
        refEntityList.add(param);
        Boolean hasEntityPermission = FilePremissionUtil.hasEntityPermission(refEntityList);
        if (!hasEntityPermission.booleanValue() && cache.get("import_" + entityNum + "_" + pageId) != null) {
            param.put("permItem", "4730fc9f000003ae");
            permItem = "4730fc9f000003ae";
            ArrayList<Map<String, Object>> refEntityListForImport = new ArrayList<Map<String, Object>>();
            refEntityListForImport.add(param);
            hasEntityPermission = FilePremissionUtil.hasEntityPermission(refEntityListForImport);
            cache.remove("import_" + entityNum + "_" + pageId);
        }
        if (!hasEntityPermission.booleanValue()) {
            FilePremissionUtil.writeErrorMessage(response, FilePremissionUtil.genNoPermissionTips(entityNum, permItem));
        }
        return hasEntityPermission;
    }

    private static boolean tryGetHasRightValue(String pageId, String appId) {
        if (StringUtils.isEmpty((CharSequence)appId)) {
            return FilePremissionUtil.tryGetHasRightValue(pageId);
        }
        return (Boolean)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"IAttachmentService", (String)"hasWF", (Object[])new Object[]{pageId});
    }

    public static Object genBillPkId(String pageId) {
        Object billPkId = "";
        if (StringUtils.isBlank((CharSequence)pageId)) {
            return billPkId;
        }
        try {
            SessionManager sm = SessionManager.getCurrent();
            sm.setRequestThread(true);
            IFormView formView = sm.getViewNoPlugin(pageId);
            billPkId = formView.getModel().getDataEntity().getPkValue();
            if (!formView.getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
                billPkId = 0L;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return billPkId;
    }

    private static String getRealEntityNum(String entityNum) {
        FormConfig formConfig;
        String formConfigStr = (String)DispatchServiceHelper.invokeBOSServiceByFormId((String)entityNum, (String)MetadataService.class.getSimpleName(), (String)"loadFormConfig", (Object[])new Object[]{entityNum});
        if (StringUtils.isBlank((CharSequence)formConfigStr)) {
            return entityNum;
        }
        try {
            formConfig = (FormConfig)ControlTypes.fromJsonStringToObj((String)formConfigStr);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            try {
                formConfig = (FormConfig)SerializationUtils.fromJsonString((String)formConfigStr, FormConfig.class);
            }
            catch (Exception e2) {
                log.error((Throwable)e2);
                return entityNum;
            }
        }
        entityNum = formConfig.getEntityTypeId();
        return entityNum;
    }

    private static void writeErrorMessage(HttpServletResponse response, String errorMessage) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(STATUS, ERROR);
        result.put(DESCRIPTION, errorMessage);
        String jsonResult = SerializationUtils.toJsonString(result);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
    }

    public static String genNoPermissionTips(String entityNum, String permissionItem) {
        MainEntityType dataEntityType;
        if (StringUtils.isBlank((CharSequence)entityNum)) {
            return "";
        }
        try {
            dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        }
        catch (Exception e) {
            log.error("kd.bos.web.actions.utils.FilePermissionUtil.genNoPermissionTips --- entityNum is error : " + e);
            return "";
        }
        String noPermissionTip = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\u3002", (String)"NoPermissionTips", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
        String permissionName = PermissionServiceHelper.getPermItemNameById((String)permissionItem);
        if (permissionName == null) {
            permissionName = permissionItem;
        }
        return String.format(noPermissionTip, dataEntityType.getDisplayName(), permissionName);
    }

    @Deprecated
    public static String genNoPermissionTipsForTwoPerms(String entityNum, String firstPermissionItem, String secondPermissionItem) {
        MainEntityType dataEntityType;
        if (StringUtils.isBlank((CharSequence)entityNum)) {
            return "";
        }
        try {
            dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        }
        catch (Exception e) {
            log.error("kd.bos.web.actions.utils.FilePermissionUtil.genNoPermissionTips --- entityNum is error : " + e);
            return "";
        }
        String noPermissionTip = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u548c\u201c%3$s\u201d\u6743\u9650\u3002", (String)"NoPermissionTipsForTwoPerms", (String)BOS_SVC_COMMON, (Object[])new Object[0]);
        String firstPermissionName = PermissionServiceHelper.getPermItemNameById((String)firstPermissionItem);
        String secondPermissionName = PermissionServiceHelper.getPermItemNameById((String)secondPermissionItem);
        if (firstPermissionName == null) {
            firstPermissionName = firstPermissionItem;
        }
        if (secondPermissionName == null) {
            secondPermissionName = secondPermissionItem;
        }
        return String.format(noPermissionTip, dataEntityType.getDisplayName(), firstPermissionName, secondPermissionName);
    }

    public static Boolean tryGetHasRightValue(HttpServletRequest request) {
        String appId;
        String pageId = request.getHeader("pageId");
        if (StringUtils.isBlank((CharSequence)pageId)) {
            pageId = request.getParameter("pageId");
        }
        if (StringUtils.isBlank((CharSequence)(appId = request.getHeader("appId")))) {
            appId = request.getParameter("appId");
        }
        return FilePremissionUtil.tryGetHasRightValue(pageId, appId);
    }

    public static Boolean tryGetHasRightValue(String pageId) {
        try {
            if (StringUtils.isBlank((CharSequence)pageId)) {
                return Boolean.FALSE;
            }
            SessionManager sm = SessionManager.getCurrent();
            sm.setRequestThread(true);
            IFormView formView = sm.getViewNoPlugin(pageId);
            String source = (String)formView.getFormShowParameter().getCustomParam("SOURCE");
            boolean hasRight = "WF".equals(source);
            log.info("tryGetHasRightValue source is " + source + ", hasRight is " + hasRight);
            return hasRight;
        }
        catch (Throwable e) {
            log.warn("tryGetHasRightValue fail : " + e);
            return Boolean.FALSE;
        }
    }

    public static void allPermissionQuery(IPageCache pageCache, String key, Long currUserId, String entityNum, IClientViewProxy clientViewProxy, IFormView view) {
        boolean checkFilePermission = Boolean.parseBoolean(String.valueOf(DispatchServiceHelper.invokeBOSService((String)IAttachmentService.class.getSimpleName(), (String)"checkFilePermission", (Object[])new Object[0])));
        long curUserId = RequestContext.get().getCurrUserId();
        log.info("checkFilePermission\u53c2\u6570 : " + checkFilePermission + " ; curUserId : " + curUserId);
        if (!checkFilePermission) {
            return;
        }
        if (-1L == curUserId) {
            return;
        }
        if (FilePremissionUtil.getHasRightValue(view)) {
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pageCache.get("flagKey:" + key))) {
            return;
        }
        Map<String, Object> resultMap = !FilePremissionUtil.isEntryView(view) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)pageCache.get("attachmentPermission")) ? FilePremissionUtil.queryPermissionFromDB(pageCache, currUserId, entityNum) : FilePremissionUtil.queryPermissionFromCache(pageCache, currUserId, entityNum, view);
        pageCache.put("flagKey:" + key, key);
        clientViewProxy.invokeControlMethod(key, "setAttPermission", new Object[]{resultMap});
    }

    public static void allPermissionQuery(IPageCache pageCache, String key, Long currUserId, String appId, String entityNum, IClientViewProxy clientViewProxy, IFormView view) {
        FilePremissionUtil.allPermissionQuery(pageCache, key, currUserId, entityNum, clientViewProxy, view);
    }

    public static boolean hasAttachmentOpPermission(String entityNum, String permItem, IFormView view, boolean showTips) {
        return FilePremissionUtil.hasAttachmentOpPermission(null, entityNum, permItem, view, showTips);
    }

    public static boolean hasAttachmentOpPermission(String appId, String entityNum, String permItem, IFormView view, boolean showTips) {
        return FilePremissionUtil.hasAttachmentOpPermission(appId, entityNum, null, permItem, view, showTips);
    }

    public static boolean hasAttachmentOpPermission(String appId, String entityNum, Object billPkId, String permItem, IFormView view, boolean showTips) {
        boolean isHasRight = FilePremissionUtil.getHasRightValue(view);
        if (view != null && isHasRight) {
            return true;
        }
        List<Map<String, Object>> refEntityList = FilePremissionUtil.genRefEntityList(appId, entityNum, billPkId, permItem);
        Boolean hasPermission = FilePremissionUtil.hasEntityPermission(refEntityList);
        if (!hasPermission.booleanValue() && showTips && view != null) {
            view.showErrorNotification(FilePremissionUtil.genNoPermissionTips(entityNum, permItem));
        }
        return hasPermission;
    }

    public static boolean hasAttachmentOpPermission(String entityNum, String permItem, IFormView view, boolean showTips, String key, IClientViewProxy clientViewProxy) {
        return FilePremissionUtil.hasAttachmentOpPermission(null, entityNum, permItem, view, showTips, key, clientViewProxy);
    }

    public static boolean hasAttachmentOpPermission(String appId, String entityNum, String permItem, IFormView view, boolean showTips, String key, IClientViewProxy clientViewProxy) {
        return FilePremissionUtil.hasAttachmentOpPermission(appId, entityNum, null, permItem, view, showTips, key, clientViewProxy);
    }

    public static boolean hasAttachmentOpPermission(String appId, String entityNum, Object billPkId, String permItem, IFormView view, boolean showTips, String key, IClientViewProxy clientViewProxy) {
        boolean isHasRight = FilePremissionUtil.getHasRightValue(view);
        if (view != null && isHasRight) {
            return true;
        }
        List<Map<String, Object>> refEntityList = FilePremissionUtil.genRefEntityList(appId, entityNum, billPkId, permItem);
        Boolean hasPermission = FilePremissionUtil.hasEntityPermission(refEntityList);
        if (view != null) {
            FilePremissionUtil.refreshPermission(view, permItem, hasPermission, entityNum, key, clientViewProxy);
        }
        if (!hasPermission.booleanValue() && showTips && view != null) {
            view.showErrorNotification(FilePremissionUtil.genNoPermissionTips(entityNum, permItem));
        }
        return hasPermission;
    }

    private static void refreshPermission(IFormView view, String permItem, Boolean currentPermission, String entityNum, String key, IClientViewProxy clientViewProxy) {
        long currUserId = RequestContext.get().getCurrUserId();
        IPageCache pageCache = view.getPageCache();
        String oldPermissions = pageCache.get("attachmentPermission");
        if (StringUtils.isBlank((CharSequence)oldPermissions)) {
            Object attachmentPermissionObj = view.getFormShowParameter().getCustomParams().get("attachmentPermission");
            String string = oldPermissions = attachmentPermissionObj != null ? String.valueOf(attachmentPermissionObj) : null;
        }
        if (StringUtils.isBlank((CharSequence)oldPermissions)) {
            return;
        }
        HashMap oldPermissionMap = (HashMap)SerializationUtils.fromJsonString((String)oldPermissions, Map.class);
        if (!currentPermission.equals(((HashMap)oldPermissionMap.get(permItemMapping.get(permItem))).get(permItemMapping.get(permItem)))) {
            Map<String, Object> resultMap = FilePremissionUtil.queryPermissionFromDB(currUserId, entityNum);
            clientViewProxy.invokeControlMethod(key, "setAttPermission", new Object[]{resultMap});
        }
    }

    private static Map<String, Object> queryPermissionFromDB(Long currUserId, String entityNum) {
        Set<String> permissionCheckSet = FilePremissionUtil.genPermissionCheckSet();
        Map permissionMap = PermissionServiceHelper.checkMultiPermItemInfos((long)currUserId, (String)entityNum, permissionCheckSet);
        return FilePremissionUtil.genResultMap(entityNum, permissionMap);
    }

    private static Map<String, Object> queryPermissionFromDB(IPageCache pageCache, Long currUserId, String entityNum) {
        Set<String> permissionCheckSet = FilePremissionUtil.genPermissionCheckSet();
        log.info("kd.bos.web.actions.utils.FilePremissionUtil.queryPermissionFromDB --- currUserId\uff1a" + currUserId + "\uff0centityNum\uff1a" + entityNum + "\uff0cpermissionCheckSet\uff1a" + permissionCheckSet);
        Map permissionMap = PermissionServiceHelper.checkMultiPermItemInfos((long)currUserId, (String)entityNum, permissionCheckSet);
        log.info("kd.bos.web.actions.utils.FilePremissionUtil.queryPermissionFromDB --- permissionResult\uff1a" + permissionMap);
        Map<String, Object> resultMap = FilePremissionUtil.genResultMap(entityNum, permissionMap);
        pageCache.put("attachmentPermission", SerializationUtils.toJsonString(resultMap));
        return resultMap;
    }

    private static Map<String, Object> queryPermissionFromCache(IPageCache pageCache, Long currUserId, String entityNum, IFormView view) {
        String attachmentPermission = pageCache.get("attachmentPermission");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)attachmentPermission)) {
            return (Map)SerializationUtils.fromJsonString((String)attachmentPermission, Map.class);
        }
        Object attachmentPermissionObj = view.getFormShowParameter().getCustomParams().get("attachmentPermission");
        String string = attachmentPermission = attachmentPermissionObj != null ? String.valueOf(attachmentPermissionObj) : null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)attachmentPermission)) {
            return (Map)SerializationUtils.fromJsonString((String)attachmentPermission, Map.class);
        }
        return FilePremissionUtil.queryPermissionFromDB(pageCache, currUserId, entityNum);
    }

    private static Set<String> genPermissionCheckSet() {
        HashSet<String> permissionCheckSet = new HashSet<String>();
        permissionCheckSet.add("2NJ5SR4NUEJ=");
        permissionCheckSet.add("2NJ5VA7D2ONF");
        permissionCheckSet.add("2NJ5W8AA040D");
        permissionCheckSet.add("2NJ5XVVCMBCL");
        permissionCheckSet.add("2NJ5YJOIS+MJ");
        permissionCheckSet.add("2NJ5ZK67OB2T");
        permissionCheckSet.add("2NJ6+I0X0CJ8");
        return permissionCheckSet;
    }

    private static Map<String, Object> genResultMap(String entityNum, Map<String, Boolean> permissionMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("upload", FilePremissionUtil.genDetailResultMap(entityNum, permissionMap, "upload", "2NJ5SR4NUEJ="));
        result.put("preview", FilePremissionUtil.genDetailResultMap(entityNum, permissionMap, "preview", "2NJ5VA7D2ONF"));
        result.put("rename", FilePremissionUtil.genDetailResultMap(entityNum, permissionMap, "rename", "2NJ5W8AA040D"));
        result.put("download", FilePremissionUtil.genDetailResultMap(entityNum, permissionMap, "download", "2NJ5XVVCMBCL"));
        result.put("delete", FilePremissionUtil.genDetailResultMap(entityNum, permissionMap, "delete", "2NJ5YJOIS+MJ"));
        result.put("mark", FilePremissionUtil.genDetailResultMap(entityNum, permissionMap, "mark", "2NJ5ZK67OB2T"));
        result.put("attView", FilePremissionUtil.genDetailResultMap(entityNum, permissionMap, "attView", "2NJ6+I0X0CJ8"));
        return result;
    }

    private static Map<String, Object> genDetailResultMap(String entityNum, Map<String, Boolean> permResultMap, String permissionKey, String permItem) {
        String msg = null;
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        Boolean permResult = permResultMap.get(permItem);
        if (StringUtils.isNotBlank((Object)permResult) && !permResult.booleanValue()) {
            msg = FilePremissionUtil.genNoPermissionTips(entityNum, permItem);
            msg = FilePremissionUtil.genUploadMsg(entityNum, permResultMap, permissionKey, msg);
        }
        detailMap.put(permissionKey, permResult);
        detailMap.put("msg", msg);
        return detailMap;
    }

    private static String genUploadMsg(String entityNum, Map<String, Boolean> permissionResultMap, String permissionKey, String msg) {
        if ("upload".equals(permissionKey) && FilePremissionUtil.isConfigurePermissions(entityNum, "2NJ6+I0X0CJ8") && FilePremissionUtil.isConfigurePermissions(entityNum, "2NJ5SR4NUEJ=") && !permissionResultMap.get("2NJ6+I0X0CJ8").booleanValue() && !permissionResultMap.get("2NJ5SR4NUEJ=").booleanValue()) {
            msg = FilePremissionUtil.genNoPermissionTipsForTwoPerms(entityNum, "2NJ5SR4NUEJ=", "2NJ6+I0X0CJ8");
        }
        if ("attView".equals(permissionKey) && permissionResultMap.get("2NJ5SR4NUEJ=").booleanValue()) {
            String displayName;
            try {
                displayName = EntityMetadataCache.getDataEntityType((String)entityNum).getDisplayName().getLocaleValue();
            }
            catch (Exception e) {
                log.error("kd.bos.web.actions.utils.FilePermissionUtil.genNoPermissionTips --- entityNum is error : " + e);
                displayName = "";
            }
            msg = String.format(ResManager.loadKDString((String)"\u201c\u9644\u4ef6\u67e5\u8be2\u201d\u662f\u201c\u4e0a\u4f20\u6587\u4ef6\u201d\u64cd\u4f5c\u7684\u524d\u7f6e\u6743\u9650\uff0c\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u9644\u4ef6\u67e5\u8be2\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u56e0\u6b64\u65e0\u6743\u8fdb\u884c\u4e0a\u4f20\u6587\u4ef6\u64cd\u4f5c\u3002", (String)"FilePremissionUtil_1", (String)BOS_SVC_COMMON, (Object[])new Object[0]), displayName);
        }
        return msg;
    }

    private static boolean isConfigurePermissions(String entityNum, String permissionItem) {
        Set permissionItemsSet = ((MetadataService)ServiceFactory.getService(MetadataService.class)).loadPermissionItems(entityNum);
        return permissionItemsSet.contains(permissionItem);
    }

    private static List<Map<String, Object>> genRefEntityList(String appId, String entityNum, Object billPkId, String permItem) {
        ArrayList<Map<String, Object>> refEntityList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            param.put("appId", appId);
        }
        if (StringUtils.isNotBlank((Object)billPkId)) {
            param.put("billPkId", billPkId);
        }
        param.put("entityNum", entityNum);
        param.put("permItem", permItem);
        refEntityList.add(param);
        return refEntityList;
    }

    public static boolean getHasRightValue(IFormView view) {
        boolean isHasRight = true;
        if (view != null) {
            String serviceAppId = view.getFormShowParameter().getServiceAppId();
            isHasRight = FilePremissionUtil.isEntryView(view) ? FilePremissionUtil.tryGetHasRightValue(view.getFormShowParameter().getParentPageId(), serviceAppId) : FilePremissionUtil.tryGetHasRightValue(view.getPageId(), serviceAppId);
        }
        return isHasRight;
    }

    private static boolean isEntryView(IFormView view) {
        boolean flag = false;
        String entityNum = view.getModel().getDataEntity().getDataEntityType().getName();
        if (ATT_ENTRYGRID_UPLOADVIEW_FORMID.equals(entityNum) || ATT_FIELD_MOB.equals(entityNum)) {
            flag = true;
        }
        return flag;
    }

    @Deprecated
    public static String getPermissionItem(String entityNum, String permissionItem) {
        if (StringUtils.isBlank((CharSequence)entityNum)) {
            return permissionItem;
        }
        Set permissionItemsSet = ((MetadataService)ServiceFactory.getService(MetadataService.class)).loadPermissionItems(entityNum);
        if (permissionItemsSet.contains(permissionItem)) {
            return permissionItem;
        }
        if (permissionItem.equals("2NJ5XVVCMBCL") || permissionItem.equals("2NJ5VA7D2ONF")) {
            return "47150e89000000ac";
        }
        if (permissionItem.equals("2NJ5SR4NUEJ=") || permissionItem.equals("2NJ5YJOIS+MJ")) {
            return "4715a0df000000ac";
        }
        return permissionItem;
    }

    public static void checkTempFile(HttpServletRequest request, boolean isCheck) {
        if (isCheck) {
            boolean checkFilePermission = Boolean.parseBoolean(String.valueOf(DispatchServiceHelper.invokeBOSService((String)IAttachmentService.class.getSimpleName(), (String)"checkFilePermission", (Object[])new Object[0])));
            if (!checkFilePermission) {
                return;
            }
            if (FilePremissionUtil.tryGetHasRightValue(request).booleanValue()) {
                return;
            }
            String id = request.getParameter(ID_MAP_KEY);
            String value = (String)cache.get(ATTATCHMENT_CHECKID + id);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = (String)cache.get(REPORT_CHECKID + id);
            }
            Map refEntitiyMap = null;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                refEntitiyMap = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            }
            if (!CollectionUtils.isEmpty(refEntitiyMap)) {
                ArrayList<Map<String, Object>> refEntityList = new ArrayList<Map<String, Object>>(1);
                refEntityList.add(refEntitiyMap);
                if (!FilePremissionUtil.hasTempPermission(refEntityList).booleanValue()) {
                    throw new KDException(new ErrorCode("NO Permission!", ResManager.loadKDString((String)"\u65e0\u8bbf\u95ee\u6743\u9650!", (String)"TempFileCheckServiceImpl_0", (String)"bos-mservice-form", (Object[])new Object[0])), new Object[0]);
                }
            } else {
                value = (String)cache.get(PRINT_CHECKID + id);
                if (!FilePremissionUtil.hasPermission(value).booleanValue()) {
                    throw new KDException(new ErrorCode("NO Permission!", ResManager.loadKDString((String)"\u65e0\u8bbf\u95ee\u6743\u9650!", (String)"TempFileCheckServiceImpl_0", (String)"bos-mservice-form", (Object[])new Object[0])), new Object[0]);
                }
            }
        }
    }

    private static Boolean hasTempPermission(List<Map<String, Object>> refEntityList) {
        Boolean hasPermission = Boolean.FALSE;
        long curUserId = RequestContext.get().getCurrUserId();
        if (curUserId == -1L) {
            return Boolean.TRUE;
        }
        if (refEntityList.size() == 0) {
            hasPermission = Boolean.TRUE;
        }
        log.info("begin check --- curUserId : " + curUserId + " ; attRefEntityKeyList : " + SerializationUtils.toJsonString(refEntityList));
        hasPermission = FilePremissionUtil.doCheckPermission(refEntityList, curUserId, hasPermission, true);
        log.info("hasPermission : " + hasPermission + " ; curUserId : " + curUserId);
        return hasPermission;
    }

    private static Boolean hasPermission(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return Boolean.TRUE;
        }
        Map config = null;
        String curUserId = RequestContext.get().getUserId();
        try {
            config = (Map)SerializationUtils.fromJsonString((String)content, Map.class);
        }
        catch (Exception e) {
            log.error("\u9a8c\u7b7e\u8f6c\u6362Map\u5931\u8d25,\u53ef\u80fd\u662f\u53ea\u6709\u7528\u6237id\u3002", (Throwable)e);
            if (!StringUtils.equalsIgnoreCase((CharSequence)curUserId, (CharSequence)content)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        String userId = String.valueOf(config.get("userId"));
        if (!StringUtils.equalsIgnoreCase((CharSequence)curUserId, (CharSequence)userId)) {
            return Boolean.FALSE;
        }
        boolean checkTempFilePermission = Boolean.parseBoolean(String.valueOf(DispatchServiceHelper.invokeBOSService((String)IAttachmentService.class.getSimpleName(), (String)"checkTempFilePermission", (Object[])new Object[0])));
        if (!checkTempFilePermission) {
            return true;
        }
        Boolean hasPermission = Boolean.TRUE;
        Object formIdObj = config.get("formId");
        Object appIdObj = config.get("appId");
        if (formIdObj != null) {
            String formId = (String)formIdObj;
            String appId = null;
            appId = appIdObj == null ? BizAppServiceHelp.getAppIdByFormNum((String)formId) : (String)appIdObj;
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            hasPermission = permissionService.checkPermission(Long.parseLong(userId), appId, (String)formIdObj, "4730fc9e000000ac");
        }
        return hasPermission;
    }

    static {
        permItemMapping.put("2NJ5SR4NUEJ=", "upload");
        permItemMapping.put("2NJ5VA7D2ONF", "preview");
        permItemMapping.put("2NJ5W8AA040D", "rename");
        permItemMapping.put("2NJ5XVVCMBCL", "download");
        permItemMapping.put("2NJ5YJOIS+MJ", "delete");
        permItemMapping.put("2NJ5ZK67OB2T", "mark");
        permItemMapping.put("2NJ6+I0X0CJ8", "attView");
    }
}

