/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.acl;

import kd.bos.svc.acl.basedataversion.BasedataVersionService;
import kd.bos.svc.acl.basedataversion.IBasedataVersionService;
import kd.bos.svc.acl.cache.CacheServiceV5_0;
import kd.bos.svc.acl.cache.ICacheService;
import kd.bos.svc.acl.i18n.BosI18nService;
import kd.bos.svc.acl.i18n.I18nService;
import kd.bos.svc.acl.privacy.BosPrivacyCenterService;
import kd.bos.svc.acl.privacy.IPrivacyCenterService;
import kd.bos.svc.acl.serviceLookup.IAclServiceLookup;
import kd.bos.svc.acl.serviceLookup.ServiceLookupLater;
import kd.bos.svc.acl.utils.ConfigPropUtil;

public class AclAdapter {
    private static IPrivacyCenterService privacyCenterService;
    private static ICacheService cacheService;
    private static IBasedataVersionService basedataVersionService;
    private static I18nService i18nService;
    private static IAclServiceLookup serviceLookup;
    private static String SERVICE_SUFFIX;

    public static IAclServiceLookup getAclServiceLookup() {
        if (serviceLookup == null) {
            String className = ConfigPropUtil.getProperty("IAclServiceLookup" + SERVICE_SUFFIX, ServiceLookupLater.class.getName());
            serviceLookup = (IAclServiceLookup)AclAdapter.createInstance(className);
        }
        return serviceLookup;
    }

    public static IPrivacyCenterService getPrivacyCenterService() {
        if (privacyCenterService == null) {
            String className = ConfigPropUtil.getProperty("IPrivacyCenterService" + SERVICE_SUFFIX, BosPrivacyCenterService.class.getName());
            privacyCenterService = (IPrivacyCenterService)AclAdapter.createInstance(className);
        }
        return privacyCenterService;
    }

    public static ICacheService getCacheService() {
        if (cacheService == null) {
            String className = ConfigPropUtil.getProperty("ICacheService" + SERVICE_SUFFIX, CacheServiceV5_0.class.getName());
            cacheService = (ICacheService)AclAdapter.createInstance(className);
        }
        return cacheService;
    }

    public static IBasedataVersionService getBasedataVersionService() {
        if (basedataVersionService == null) {
            String className = ConfigPropUtil.getProperty("IBasedataVersionService" + SERVICE_SUFFIX, BasedataVersionService.class.getName());
            basedataVersionService = (IBasedataVersionService)AclAdapter.createInstance(className);
        }
        return basedataVersionService;
    }

    public static I18nService getI18nService() {
        if (i18nService == null) {
            String className = ConfigPropUtil.getProperty("I18Service" + SERVICE_SUFFIX, BosI18nService.class.getName());
            i18nService = (I18nService)AclAdapter.createInstance(className);
        }
        return i18nService;
    }

    private static <T> T createInstance(String className) {
        try {
            Class<?> aClass = Class.forName(className);
            Object o = aClass.newInstance();
            return (T)o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        SERVICE_SUFFIX = "_IMPL";
    }
}

