/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.svc.earlywarn;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.earlywarn.warn.EarlyWarnDcBinder;
import kd.bos.entity.earlywarn.warn.EarlyWarnElement;
import kd.bos.entity.earlywarn.warnschedule.WarnSchedule;
import kd.bos.entity.earlywarn.warnschedule.WarnScheduleDcBinder;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.earlywarn.warn.DesignEarlyWarnMeta;
import kd.bos.metadata.earlywarn.warn.DesignEarlyWarnMetaL;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetaDaoPlugin;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetadata;
import kd.bos.metadata.earlywarn.warn.EarlyWarnReader;
import kd.bos.metadata.earlywarn.warnschedule.WarnScheduleMetaDaoPlugin;
import kd.bos.metadata.earlywarn.warnschedule.WarnScheduleMetadata;
import kd.bos.metadata.earlywarn.warnschedule.WarnScheduleReader;
import kd.bos.mservice.svc.earlywarn.IDeployFile;
import kd.bos.mservice.svc.earlywarn.IEarlyWarnProxy;

public class EarlyWarnProxyImpl
implements IEarlyWarnProxy {
    private DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    public List<IDeployFile> getEarlyWarnDeployFile(String id) {
        ArrayList<IDeployFile> files = new ArrayList<IDeployFile>(10);
        DesignEarlyWarnMeta designMeta = (DesignEarlyWarnMeta)BusinessDataReader.read((Object)id, (IDataEntityType)OrmUtils.getDataEntityType(DesignEarlyWarnMeta.class), (Boolean)Boolean.FALSE);
        DeployMetadata deploy = new DeployMetadata();
        deploy.getDesignMetas().add(designMeta);
        String fileName = String.format("%s_%s", designMeta.getNumber(), id);
        deploy.setId(id);
        files.add((IDeployFile)deploy.toDeployFile(fileName + ".warn"));
        List<Object> designFormMetaLs = EarlyWarnProxyImpl.getLocale(OrmUtils.getDataEntityType(DesignEarlyWarnMetaL.class), id);
        for (Object fm : designFormMetaLs) {
            DesignMetaL fmL = (DesignMetaL)fm;
            deploy = new DeployMetadata();
            deploy.setId(id);
            deploy.getDesignMetas().add(fmL);
            files.add((IDeployFile)deploy.toDeployFile(fileName + "." + fmL.getLocaleId() + ".warnx"));
        }
        return files;
    }

    public String loadEarlyWarn(String earlyWarnId) {
        String accountId = CacheKeyUtil.getAcctId();
        String cacheType = String.format("%s_%s", accountId, "EarlyWarn");
        String result = (String)this.cache.get(cacheType, earlyWarnId);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return result;
        }
        EarlyWarnDcBinder binder = new EarlyWarnDcBinder();
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)binder);
        EarlyWarnMetadata metadata = EarlyWarnReader.loadMeta((String)earlyWarnId, (boolean)true);
        EarlyWarnElement earlyWarn = metadata.getWarnElement();
        result = serializer.serializeToString((Object)earlyWarn, null);
        if (null != result) {
            this.cache.put(cacheType, earlyWarnId, (Object)result);
        }
        return result;
    }

    public String loadWarnSchedule(String warnScheduleId) {
        String accountId = CacheKeyUtil.getAcctId();
        String cacheType = String.format("%s_%s", accountId, "WarnSchedule");
        String result = (String)this.cache.get(cacheType, warnScheduleId);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return result;
        }
        WarnScheduleDcBinder binder = new WarnScheduleDcBinder();
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)binder);
        WarnScheduleMetadata metadata = WarnScheduleReader.loadMeta((String)warnScheduleId, (boolean)true);
        WarnSchedule warnSchedule = metadata.getWarnSchedule();
        result = serializer.serializeToString((Object)warnSchedule, null);
        if (null != result) {
            this.cache.put(cacheType, warnScheduleId, (Object)result);
        }
        return result;
    }

    private static List<Object> getLocale(final IDataEntityType designerMetaType, String id) {
        String tableName = designerMetaType.getAlias();
        ArrayList<String> fieldNames = new ArrayList<String>(10);
        for (ISimpleProperty property : designerMetaType.getProperties().getSimpleProperties(true)) {
            String fieldName = property.getAlias();
            if (!StringUtils.isNotBlank((CharSequence)fieldName)) continue;
            fieldNames.add(fieldName);
        }
        String sql = String.format("select %s from %s where FId=? ", StringUtils.join((Object[])fieldNames.toArray(), (String)","), tableName);
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)id)};
        ResultSetHandler<List<Object>> action = new ResultSetHandler<List<Object>>(){

            public List<Object> handle(ResultSet rs) throws Exception {
                ArrayList<Object> objs = new ArrayList<Object>(10);
                while (rs.next()) {
                    Object obj = designerMetaType.createInstance();
                    for (ISimpleProperty property : designerMetaType.getProperties().getSimpleProperties(true)) {
                        if (property.getPropertyType() == String.class) {
                            property.setValue(obj, (Object)rs.getString(property.getAlias()));
                            continue;
                        }
                        property.setValue(obj, rs.getObject(property.getAlias()));
                    }
                    objs.add(obj);
                }
                return objs;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public Object newEarlyWarnMetaDaoPlugin() {
        return new EarlyWarnMetaDaoPlugin();
    }

    public Object newWarnScheduleMetaDaoPlugin() {
        return new WarnScheduleMetaDaoPlugin();
    }
}

