/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.svc.expt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.attachment.util.AttachExceptionHandler;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.dto.ExportPermissionParam;
import kd.bos.form.mservice.ExportPermissionService;
import kd.bos.lang.Lang;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.svc.util.EncryptUtils;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.web.actions.export.ExportActionResult;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.bos.web.actions.utils.FileOperationLog;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportActionImpl {
    private static Log log = LogFactory.getLog(ExportActionImpl.class);
    private static final String BOS_WEBACTIONS = "bos-webactions";
    private static final String BOS_MSERVICE_SVC = "bos-mservice-svc";
    private static final String UTF_8 = "UTF-8";
    private static final String QUERY_SERVICE = "QueryService";
    private static final String RELEASE_EXPORT_DATA = "releaseExportData";
    private static final String HAS_NEXT_PAGE = "hasNextPage";
    private static BlockingQueue<String> ExportAccessQueue = new ArrayBlockingQueue<String>(ExportActionImpl.getMaxDownloadTemplateCountProperty());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportActionResult doExportAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Boolean success = Boolean.FALSE;
        String formId = request.getParameter("formid");
        String fileName = request.getParameter("filename");
        ExportActionResult result = new ExportActionResult();
        try {
            boolean hasPermission = new ExportPermissionService().checkPermission(new ExportPermissionParam(Long.valueOf(RequestContext.get().getCurrUserId()), formId, "47150e89000000ac"));
            if (!hasPermission) {
                throw new KDException(new ErrorCode("NO Permission!", ResManager.loadKDString((String)"\u65e0\u8bbf\u95ee\u6743\u9650!", (String)"ExportActionImpl_3", (String)BOS_MSERVICE_SVC, (Object[])new Object[0])), new Object[0]);
            }
            String type = request.getParameter("type");
            String exportId = request.getParameter("exportid");
            String templateId = request.getParameter("templateid");
            boolean fillParent = Boolean.parseBoolean(request.getParameter("fillparent"));
            String routeAppId = request.getParameter("routeappid");
            String encodePlugin = request.getParameter("plugin");
            String plugin = "";
            if (encodePlugin != null) {
                plugin = EncryptUtils.decodeBase64((String)encodePlugin);
            }
            String extenddata = request.getParameter("extenddata");
            result = this.doExportAction(type, exportId, templateId, fillParent, routeAppId, formId, fileName, plugin, extenddata);
            success = this.dealExportActionResult(result, response, fileName);
        }
        catch (KDException e) {
            log.error((Throwable)e);
            if (AttachExceptionHandler.dealException((KDException)e, (HttpServletResponse)response).booleanValue()) {
                result.setSuccess(false);
            }
        }
        catch (Exception e) {
            log.error("ExportActionImpl.doExportAction() occur Exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.doExportLog(request, success, formId, fileName);
        }
        return result;
    }

    private Boolean dealExportActionResult(ExportActionResult result, HttpServletResponse response, String fileName) throws IOException {
        Boolean success = Boolean.FALSE;
        if (result.isSuccess()) {
            SXSSFWorkbook wb = result.getWorkbook();
            BatchDownloadRequest attachReq = result.getAttachRequest();
            fileName = FileSecurityUtil.getSecurityHeader((String)fileName);
            if (wb != null) {
                response.setCharacterEncoding(UTF_8);
                response.setContentType("application/octet-stream");
                response.addHeader("Content-Disposition", "attachment;filename*=UTF-8''" + URLEncoder.encode(fileName, UTF_8).replaceAll("\\+", "%20"));
                wb.write((OutputStream)response.getOutputStream());
                wb.dispose();
                wb.close();
            } else if (attachReq != null) {
                response.addHeader("Content-Disposition", "attachment;filename*=UTF-8''" + URLEncoder.encode(fileName, UTF_8).replaceAll("\\+", "%20"));
                FileService service = FileServiceFactory.getAttachmentFileService();
                service.batchDownload(attachReq, (OutputStream)response.getOutputStream(), "application");
            }
            success = Boolean.TRUE;
        } else if (StringUtils.isNotBlank((CharSequence)result.getError())) {
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result.getError());
        } else {
            response.reset();
        }
        return success;
    }

    private void doExportLog(HttpServletRequest request, Boolean success, String entityNum, String fileName) {
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f", "ExportActionImpl_0", BOS_MSERVICE_SVC);
        if (success.booleanValue()) {
            FileOperationLog.getInstance().createAttachLog(request, fileName);
            return;
        }
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5bfc\u5165\u6a21\u677f\u6587\u4ef6%s\u4e0b\u8f7d\u5931\u8d25\u3002", "ExportActionImpl_2", BOS_MSERVICE_SVC);
        this.createAppLog(entityNum, opName, opDesc, fileName);
    }

    private void createAppLog(String bizObjID, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String ... opDescArgs) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(BizAppServiceHelp.getAppIdByFormNum((String)bizObjID));
        appLogInfo.setBizObjID(bizObjID);
        appLogInfo.setOpName("export", opNameBridge);
        appLogInfo.setOpDesc(opDescBridge, opDescArgs);
        ((ILogService)ServiceFactory.getService(ILogService.class)).addLog((AppLogInfo)appLogInfo);
    }

    public ExportActionResult doExportAction(String type, String exportId, String templateId, boolean fillParent, String routeAppId, String formId, String fileName, String plugin, String extenddata) throws IOException {
        ExportActionResult result = new ExportActionResult();
        if (!ExportAccessQueue.offer("")) {
            result.setSuccess(false);
            return result;
        }
        try {
            if (StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)fileName)) {
                result.setSuccess(false);
                ExportActionResult exportActionResult = result;
                return exportActionResult;
            }
            fileName = fileName.replace("../", "");
            fileName = fileName.replace("..\\", "");
            try {
                BatchDownloadRequest attachReq;
                if (!"attachment".equals(type)) {
                    SXSSFWorkbook wb = new SXSSFWorkbook(5000);
                    wb.setCompressTempFiles(true);
                    SXSSFSheet sheet = wb.createSheet("sheet1");
                    SXSSFSheet tempSheet = null;
                    ExportSheetStyle styles = new ExportSheetStyle(wb);
                    if (StringUtils.isNotBlank((CharSequence)templateId)) {
                        if (fillParent) {
                            tempSheet = wb.createSheet("sheet2");
                        }
                        this.prepareExportData(wb, sheet, styles, routeAppId, formId, exportId, templateId, plugin, extenddata, fileName, tempSheet);
                    } else if (StringUtils.isNotBlank((CharSequence)exportId)) {
                        this.prepareListData(wb, sheet, styles, routeAppId, formId, exportId);
                    }
                    if (tempSheet != null) {
                        wb.removeSheetAt(wb.getSheetIndex((Sheet)tempSheet));
                    }
                    result.setWorkbook(wb);
                } else {
                    attachReq = this.downloadAttachment(routeAppId, formId, exportId, fileName);
                    result.setAttachRequest(attachReq);
                }
                attachReq = result;
                return attachReq;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        finally {
            ExportAccessQueue.poll();
        }
    }

    private static int getMaxDownloadTemplateCountProperty() {
        try {
            return Integer.parseInt(System.getProperty("max.download.template.count", "20"));
        }
        catch (NumberFormatException e) {
            log.warn((Throwable)e);
            return 20;
        }
    }

    private BatchDownloadRequest downloadAttachment(String routeAppId, String formId, String exportId, String fileName) throws IOException {
        BatchDownloadRequest attachReq = new BatchDownloadRequest("attachments.zip");
        int pageIndex = 0;
        int pageSize = 200;
        JSONArray attachArr = null;
        JSONObject retObj = null;
        ArrayList<BatchDownloadRequest.Dir> dirs = new ArrayList<BatchDownloadRequest.Dir>();
        do {
            String retJson = (String)DispatchServiceHelper.invokeBOSService((String)routeAppId, (String)QUERY_SERVICE, (String)"getExportAttachment", (Object[])new Object[]{exportId, formId, pageIndex, pageSize});
            retObj = JSON.parseObject((String)retJson);
            attachArr = retObj.getJSONArray("attachs");
            for (int i = 0; i < attachArr.size(); ++i) {
                JSONArray attachs = attachArr.getJSONArray(i);
                if (attachs.isEmpty()) continue;
                BatchDownloadRequest.Dir dir = new BatchDownloadRequest.Dir("pk-" + attachs.getJSONObject(0).getString("pkId"));
                BatchDownloadRequest.File[] files = new BatchDownloadRequest.File[attachs.size()];
                for (int j = 0; j < files.length; ++j) {
                    JSONObject att = attachs.getJSONObject(j);
                    files[j] = new BatchDownloadRequest.File(att.getString("name"), att.getString("url"));
                }
                dir.setFiles(files);
                dirs.add(dir);
            }
            ++pageIndex;
        } while (retObj.getIntValue("billCount") == pageSize);
        if (!dirs.isEmpty()) {
            attachReq.setDirs(dirs.toArray(new BatchDownloadRequest.Dir[0]));
            return attachReq;
        }
        DispatchServiceHelper.invokeBOSService((String)routeAppId, (String)QUERY_SERVICE, (String)RELEASE_EXPORT_DATA, (Object[])new Object[]{exportId, formId});
        return null;
    }

    private void prepareListData(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, String routeAppId, String formId, String exportId) {
        int rowCount = 0;
        int pageIndex = 0;
        int pageSize = 2000;
        JSONObject dataAll = null;
        JSONArray dataArr = null;
        JSONArray titles = null;
        boolean hasNextPage = false;
        do {
            String dataJson = (String)DispatchServiceHelper.invokeBOSService((String)routeAppId, (String)QUERY_SERVICE, (String)"getExportDataByList", (Object[])new Object[]{exportId, formId, titles == null, pageIndex, pageSize});
            dataAll = JSON.parseObject((String)dataJson);
            if (titles == null) {
                titles = JSON.parseArray((String)dataAll.getString("ListFieldCaptions"));
                ExportWriter.writeLine((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONArray)titles, (int)rowCount++);
            }
            if (dataAll.containsKey((Object)HAS_NEXT_PAGE)) {
                hasNextPage = dataAll.getBooleanValue(HAS_NEXT_PAGE);
            }
            dataArr = dataAll.getJSONArray("Data");
            for (int i = 0; i < dataArr.size(); ++i) {
                ExportWriter.writeLine((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONArray)titles, (JSONArray)dataArr.getJSONArray(i), (int)rowCount++);
            }
            ++pageIndex;
        } while (dataArr.size() == pageSize || hasNextPage);
        DispatchServiceHelper.invokeBOSService((String)routeAppId, (String)QUERY_SERVICE, (String)RELEASE_EXPORT_DATA, (Object[])new Object[]{exportId, formId});
    }

    private void prepareExportData(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, String routeAppId, String formId, String exportId, String templateId, String plugin, String extenddata, String fileName, SXSSFSheet tempSheet) {
        String exportJSon = (String)DispatchServiceHelper.invokeBOSService((String)routeAppId, (String)"MetadataService", (String)"getExportWriter", (Object[])new Object[]{formId, Long.parseLong(templateId), plugin == null ? "" : plugin, extenddata});
        List format = JSON.parseArray((String)exportJSon, ExportWriterFormat.class);
        ExportWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)(tempSheet != null ? tempSheet : sheet), (ExportSheetStyle)styles, (List)format);
        if (StringUtils.isNotBlank((CharSequence)exportId)) {
            if (tempSheet != null) {
                SXSSFRow fillTitle = sheet.createRow(0);
                int i = 0;
                String cellVal = null;
                StringBuilder displayCellVal = null;
                List<String> langs = this.getLangEndFix();
                for (Cell cell : tempSheet.getRow(2)) {
                    cellVal = cell.getStringCellValue();
                    String cellVal0 = cellVal.split(" # ")[0];
                    displayCellVal = cellVal0 != null ? new StringBuilder(cellVal0) : new StringBuilder();
                    if (cellVal != null) {
                        if (cellVal.endsWith(".name")) {
                            displayCellVal.append(ResManager.loadKDString((String)".\u540d\u79f0", (String)"FormAction_0", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
                        } else if (cellVal.endsWith(".number")) {
                            displayCellVal.append(ResManager.loadKDString((String)".\u7f16\u7801", (String)"FormAction_1", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
                        } else {
                            for (String lang : langs) {
                                if (!cellVal.endsWith(lang)) continue;
                                displayCellVal.append(lang);
                                break;
                            }
                        }
                        Cell tempCell = fillTitle.createCell(i, cell.getCellType());
                        tempCell.setCellStyle(cell.getCellStyle());
                        tempCell.setCellValue(displayCellVal.toString());
                    }
                    ++i;
                }
            }
            int pageIndex = 0;
            int pageSize = Integer.parseInt(System.getProperty("Export_Page_Size", "300"));
            int rowIndex = tempSheet != null ? 1 : 3;
            JSONArray billArr = null;
            JSONArray pkArr = null;
            JSONObject dataAll = null;
            boolean hasNextPage = false;
            do {
                String dataJson = (String)DispatchServiceHelper.invokeBOSService((String)routeAppId, (String)QUERY_SERVICE, (String)"getExportData", (Object[])new Object[]{exportId, formId, String.join((CharSequence)",", ((ExportWriterFormat)format.get(0)).listFields(new ArrayList())), pageIndex, pageSize});
                dataAll = JSON.parseObject((String)dataJson);
                billArr = dataAll.getJSONArray("data");
                pkArr = dataAll.getJSONArray("attachPkIds");
                if (dataAll.containsKey((Object)HAS_NEXT_PAGE)) {
                    hasNextPage = dataAll.getBooleanValue(HAS_NEXT_PAGE);
                }
                TraceSpan span = Tracer.create((String)"formaction", (String)"export");
                Object object = null;
                try {
                    for (int i = 0; i < billArr.size(); ++i) {
                        int offset = ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)billArr.getJSONObject(i), (int)rowIndex, (ExportWriterFormat)((ExportWriterFormat)format.get(0)), (pkArr != null && pkArr.size() > i && pkArr.get(i) != null ? 1 : 0) != 0, (String)fileName, (tempSheet != null ? 1 : 0) != 0);
                        if (offset > 1) {
                            rowIndex += offset;
                            continue;
                        }
                        ++rowIndex;
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (span != null) {
                        if (object != null) {
                            try {
                                span.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            span.close();
                        }
                    }
                }
                ++pageIndex;
            } while (billArr.size() == pageSize || hasNextPage);
            DispatchServiceHelper.invokeBOSService((String)routeAppId, (String)QUERY_SERVICE, (String)RELEASE_EXPORT_DATA, (Object[])new Object[]{exportId, formId});
        }
    }

    private List<String> getLangEndFix() {
        ArrayList<String> langs = new ArrayList<String>(10);
        for (Lang lang : Lang.values()) {
            langs.add("." + lang.name());
        }
        return langs;
    }
}

