/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.svc.expt;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.form.plugin.parameter.IExportConfigKeyEnum;
import kd.bos.form.plugin.parameter.ImportAndExportConfigCache;
import kd.bos.mservice.svc.expt.ExportActionImpl;
import kd.bos.mservice.svc.expt.IExportService;
import kd.bos.service.metadata.ExportWriterBuilder;
import kd.bos.web.actions.export.ExportActionResult;
import org.apache.commons.collections4.MapUtils;

public class ExportServiceImpl
implements IExportService {
    private ImportAndExportConfigCache importAndExportConfigCache = new ImportAndExportConfigCache();

    public Map<String, Boolean> getSettingOfMultilang(String entityId) {
        Map multilangConfig = this.importAndExportConfigCache.getMultilangConfig(entityId);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(multilangConfig.size());
        for (Map.Entry entry : multilangConfig.entrySet()) {
            String lang = ((String)entry.getKey()).replace("lang_", "");
            result.put(lang, (Boolean)entry.getValue());
        }
        return result;
    }

    public boolean getSettingOfAutoLine(String entityId) {
        return this.importAndExportConfigCache.getAutoLineConfig(entityId).orElse(Boolean.TRUE);
    }

    public Optional<Boolean> getSettingOfAutoFullSuperInfoAtImportTemplate(String entityId) {
        Map settingOfAutoFullSuperInfo = this.importAndExportConfigCache.getAutoFillSuperInfoConfig(entityId);
        Boolean forImportTemplate = (Boolean)settingOfAutoFullSuperInfo.get("forimporttemplate");
        return forImportTemplate == null ? Optional.of(Boolean.FALSE) : Optional.of(forImportTemplate);
    }

    public Optional<Boolean> getSettingOfAutoFullSuperInfoAtExportTemplate(String entityId) {
        Map settingOfAutoFullSuperInfo = this.importAndExportConfigCache.getAutoFillSuperInfoConfig(entityId);
        Boolean forExportTemplate = (Boolean)settingOfAutoFullSuperInfo.get("forexporttemplate");
        return forExportTemplate == null ? Optional.of(Boolean.TRUE) : Optional.of(forExportTemplate);
    }

    public Optional<Boolean> getSettingOfAutoFullSuperInfoAtList(String entityId) {
        Map settingOfAutoFullSuperInfo = this.importAndExportConfigCache.getAutoFillSuperInfoConfig(entityId);
        Boolean forList = (Boolean)settingOfAutoFullSuperInfo.get("forlisttemplate");
        return forList == null ? Optional.of(Boolean.TRUE) : Optional.of(forList);
    }

    public Optional<Boolean> getSettingOfIsCsvFileAtList(String entityId) {
        Map settingOfExportCsv = this.importAndExportConfigCache.getExportCsv(entityId);
        Boolean forList = (Boolean)settingOfExportCsv.get("forcsvlist");
        return forList == null ? Optional.of(Boolean.FALSE) : Optional.of(forList);
    }

    public Optional<Boolean> getSettingOfIsCsvFileAtExportTemplate(String entityId) {
        Map settingOfExportCsv = this.importAndExportConfigCache.getExportCsv(entityId);
        Boolean forExportTemplate = (Boolean)settingOfExportCsv.get("forcsvexporttemplate");
        return forExportTemplate == null ? Optional.of(Boolean.FALSE) : Optional.of(forExportTemplate);
    }

    public boolean getSettingOfExportSummaryLine(String entityId) {
        Optional configForSummaryLine = this.importAndExportConfigCache.getConfigCache(entityId, IExportConfigKeyEnum.ExportConfigForSummaryLineEnum);
        return configForSummaryLine.map(Boolean::valueOf).orElse(Boolean.FALSE);
    }

    public boolean getSettingOfExportAllDataDataWithErrLog(String entityId) {
        Optional configForExportAllDataDataWithErrLog = this.importAndExportConfigCache.getConfigCache(entityId, IExportConfigKeyEnum.ExportConfigForAllLogData);
        return configForExportAllDataDataWithErrLog.map(Boolean::valueOf).orElse(Boolean.FALSE);
    }

    public String getExportWriter(String formId, long templateId, String pluginClassName, String extenddata) {
        return new ExportWriterBuilder().build(formId, templateId, pluginClassName, extenddata);
    }

    public Optional<Map<String, String>> getSettingOfExportImg(String entityId) {
        HashMap<String, String> settingOfExportImg = this.importAndExportConfigCache.getExportImg(entityId);
        if (MapUtils.isEmpty((Map)settingOfExportImg)) {
            settingOfExportImg = new HashMap<String, String>(2);
            settingOfExportImg.put("forimgexport", String.valueOf(Boolean.FALSE));
            settingOfExportImg.put("combofieldpicname", String.valueOf(0));
            return Optional.of(settingOfExportImg);
        }
        return Optional.of(settingOfExportImg);
    }

    public Optional<Map<String, String>> getSettingOfExportAtt(String entityId) {
        HashMap<String, String> settingOfExportAtt = this.importAndExportConfigCache.getExportAtt(entityId);
        if (MapUtils.isEmpty((Map)settingOfExportAtt)) {
            settingOfExportAtt = new HashMap<String, String>(2);
            settingOfExportAtt.put("forattexport", String.valueOf(Boolean.FALSE));
            settingOfExportAtt.put("combofieldattname", String.valueOf(0));
            return Optional.of(settingOfExportAtt);
        }
        return Optional.of(settingOfExportAtt);
    }

    public ExportActionResult doExportAction(String type, String exportId, String templateId, boolean fillParent, String routeAppId, String formId, String fileName, String plugin, String extenddata) throws IOException {
        return new ExportActionImpl().doExportAction(type, exportId, templateId, fillParent, routeAppId, formId, fileName, plugin, extenddata);
    }

    public ExportActionResult doExportAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return new ExportActionImpl().doExportAction(request, response);
    }
}

