/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.attachment;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.field.AttachmentEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.service.attachment.controller.param.AttachmentDownloadArgs;
import kd.bos.service.attachment.controller.result.AttachmentDownloadResult;
import kd.bos.service.attachment.extend.permission.FilePermissionExtensionFactory;
import kd.bos.service.attachment.extend.permission.FilePermissionParam;
import kd.bos.service.attachment.extend.permission.FileTypeEnum;
import kd.bos.service.attachment.extend.permission.PermissionResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.web.actions.utils.AttachmentUtil;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.bos.web.actions.utils.FilePremissionUtil;
import kd.bos.web.actions.utils.FileReqLimitUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ApiAttachmentServiceImpl {
    private static final String ATTACHMENT_PANEL_ENTITY = "bos_attachment";
    private static final String ATTACHMENT_FIELD_ENTITY = "bd_attachment";
    private static final String BOS_MSERVICE_SVC = "bos-mservice-svc";

    public AttachmentDownloadResult download(AttachmentDownloadArgs downloadArgs) throws Exception {
        if ("/".equals(downloadArgs.getPath())) {
            throw new KDException(new ErrorCode("PATH_ERROR", ResManager.loadKDString((String)"path\u8def\u5f84\u9519\u8bef\u3002", (String)"ApiAttachmentServiceImpl_0", (String)BOS_MSERVICE_SVC, (Object[])new Object[0])), new Object[0]);
        }
        String entityNumber = downloadArgs.getEntityNumber();
        Object pkId = downloadArgs.getBillPkId();
        String controlKey = downloadArgs.getControlKey();
        String path = FilePathUtil.dealPathParam((String)URLDecoder.decode(downloadArgs.getPath(), "UTF-8"));
        if (!this.checkPathMapping(entityNumber, pkId, path, controlKey, downloadArgs.getAttParentPkId())) {
            throw new KDException(new ErrorCode("PATH_MAPPING_ERROR", ResManager.loadKDString((String)"\u9644\u4ef6\u8def\u5f84\u548c\u5355\u636e\u6ca1\u6709\u5173\u8054\u3002", (String)"ApiAttachmentServiceImpl_1", (String)BOS_MSERVICE_SVC, (Object[])new Object[0])), new Object[0]);
        }
        if (!this.checkPermission(entityNumber, pkId)) {
            throw new KDException(new ErrorCode("NO_PERMISSION", ResManager.loadKDString((String)"\u65e0\u9644\u4ef6\u4e0b\u8f7d\u6743\u9650\u3002", (String)"ApiAttachmentServiceImpl_2", (String)BOS_MSERVICE_SVC, (Object[])new Object[0])), new Object[0]);
        }
        if (FileReqLimitUtil.checkLimitReq((String)"download", (int)0)) {
            throw new KDException(new ErrorCode("REQUEST_LIMIT", AttachmentUtil.getUploadOrDownloadLimitTips((String)"downloadlimit")), new Object[0]);
        }
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        if (!fileService.exists(path)) {
            throw new KDException(new ErrorCode("FILE_IS_NOT_EXIST", ResManager.loadKDString((String)"\u9644\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"ApiAttachmentServiceImpl_3", (String)BOS_MSERVICE_SVC, (Object[])new Object[0])), new Object[0]);
        }
        FilePermissionParam filePermissionParam = new FilePermissionParam(String.valueOf(pkId), downloadArgs.getAppId(), path, FileTypeEnum.ATTACHMENT, null);
        PermissionResult permissionResult = FilePermissionExtensionFactory.getFilePermissionExtension().checkPermission(filePermissionParam);
        if (!permissionResult.getHasPermission().booleanValue()) {
            throw new KDException(new ErrorCode("NO_PERMISSION_EXT", permissionResult.getMsg()), new Object[0]);
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        fileService.download(downloadArgs.getPath(), (OutputStream)outStream, null);
        return new AttachmentDownloadResult(this.getAttachmentFileName(path), "application/octet-stream", downloadArgs.isDownload(), outStream.toByteArray());
    }

    private String getAttachmentFileName(String path) {
        String fileName = ResManager.loadKDString((String)"\u672a\u77e5\u6587\u4ef6\u540d", (String)"ApiAttachmentServiceImpl_5", (String)BOS_MSERVICE_SVC, (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)path)) {
            return fileName;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)path).or("path", "=", (Object)path);
        Map svcAttachment = BusinessDataServiceHelper.loadFromCache((String)"bos_svc_attachment", (String)"id,name", (QFilter[])qFilter.toArray());
        if (MapUtils.isEmpty((Map)svcAttachment)) {
            return fileName;
        }
        for (DynamicObject value : svcAttachment.values()) {
            String name = value.getString("name");
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            fileName = name;
            break;
        }
        return fileName;
    }

    private boolean checkPermission(String entityNumber, Object pkId) {
        HashMap<String, Object> entityInfo = new HashMap<String, Object>();
        entityInfo.put("entityNum", entityNumber);
        entityInfo.put("billPkId", pkId);
        entityInfo.put("permItem", "2NJ5XVVCMBCL");
        return FilePremissionUtil.hasEntityPermission(Collections.singletonList(entityInfo));
    }

    private boolean checkPathMapping(String entityNumber, Object billPkId, String path, String controlKey, Object attParentPkId) {
        Control control = this.getAttachmentControl(entityNumber, controlKey);
        if (control == null) {
            throw new KDException(new ErrorCode("CONTROL_NOT_EXIST", ResManager.loadKDString((String)"\u9644\u4ef6\u6240\u5728\u63a7\u4ef6\u6807\u8bc6\u9519\u8bef\u3002", (String)"ApiAttachmentServiceImpl_4", (String)BOS_MSERVICE_SVC, (Object[])new Object[0])), new Object[0]);
        }
        if (control instanceof AttachmentPanel) {
            QFilter billTypeFilter = new QFilter("fbilltype", "=", (Object)entityNumber);
            QFilter pkIdFilter = new QFilter("finterid", "=", (Object)String.valueOf(billPkId));
            QFilter pathFilter = new QFilter("ffileid", "=", (Object)path);
            QFilter controlKeyFilter = new QFilter("fattachmentpanel", "=", (Object)controlKey);
            return QueryServiceHelper.exists((String)ATTACHMENT_PANEL_ENTITY, (QFilter[])new QFilter[]{billTypeFilter, pkIdFilter, pathFilter, controlKeyFilter});
        }
        DynamicObjectCollection attachmentFields = QueryServiceHelper.query((String)ATTACHMENT_FIELD_ENTITY, (String)"id", (QFilter[])new QFilter("url", "=", (Object)path).toArray());
        if (CollectionUtils.isEmpty((Collection)attachmentFields)) {
            return false;
        }
        List<Long> attIds = attachmentFields.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        AttachmentProp attachmentProp = (AttachmentProp)dataEntityType.getAllFields().get(controlKey);
        return this.isExistAttachmentRecord(attachmentProp, attIds, billPkId, attParentPkId);
    }

    private boolean isExistAttachmentRecord(AttachmentProp attachmentProp, List<Long> attIds, Object billPkId, Object attParentPkId) {
        EntityType entityType = (EntityType)attachmentProp.getParent();
        ISimpleProperty primaryKey = entityType.getPrimaryKey();
        String pkKey = primaryKey.getAlias();
        DBRoute dbRoute = new DBRoute(entityType.getDBRouteKey());
        Object[] params = new SqlParameter[]{attIds.size() == 1 ? new SqlParameter(":FBasedataId", -5, (Object)attIds.get(0)) : new SqlParameter(":FBasedataId", 2003, attIds)};
        String sql = "SELECT " + pkKey + " FROM " + attachmentProp.getAlias() + " WHERE FBasedataId = ?";
        Object pkId = attParentPkId == null || StringUtils.isBlank((Object)attParentPkId) ? billPkId : attParentPkId;
        return (Boolean)DB.query((DBRoute)dbRoute, (String)sql, (Object[])params, rs -> {
            while (rs.next()) {
                Object pk = rs.getObject(pkKey);
                if (!StringUtils.equals((CharSequence)pkId.toString(), (CharSequence)pk.toString())) continue;
                return true;
            }
            return false;
        });
    }

    private Control getAttachmentControl(String entityNumber, String controlKey) {
        List controls = FormMetadataCache.getRootControl((String)entityNumber).getItems();
        return this.getAttachmentControl(controls, controlKey);
    }

    private Control getAttachmentControl(List<Control> controls, String controlKey) {
        for (Control control : controls) {
            Control attachmentControl;
            if (control instanceof AttachmentPanel && StringUtils.equalsIgnoreCase((CharSequence)controlKey, (CharSequence)control.getKey())) {
                return control;
            }
            if (control instanceof AttachmentEdit && StringUtils.equalsIgnoreCase((CharSequence)controlKey, (CharSequence)control.getKey())) {
                return control;
            }
            if (!(control instanceof Container) || (attachmentControl = this.getAttachmentControl(controls = ((Container)control).getItems(), controlKey)) == null) continue;
            return attachmentControl;
        }
        return null;
    }
}

