/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.attachment;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kd.bos.attachment.util.CacheKey;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.service.attachment.IAttachmentOperateService;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;

public class AttachmentOperateServiceImpl
implements IAttachmentOperateService {
    private static final String ATTACHMENT_PANEL = "AttachmentPanel";
    private static final String ATTACHMENT_FIELD = "AttachmentField";
    private static final Log log = LogFactory.getLog(AttachmentOperateServiceImpl.class);

    public void persistAttachments(OperateOption option, DynamicObject[] successObjs) {
        if (option.containsVariable(ATTACHMENT_PANEL)) {
            String attachmentPanelString = option.getVariableValue(ATTACHMENT_PANEL);
            Map attachmentPanel = (Map)SerializationUtils.fromJsonString((String)attachmentPanelString, Map.class);
            Map attachmentInfo = (Map)attachmentPanel.get("AttachmentInfo");
            Object pkId = attachmentPanel.get("PkId");
            if (StringUtils.isBlank(pkId) || "0".equals(pkId.toString())) {
                pkId = successObjs[0].getPkValue();
            }
            String appId = StringUtils.isBlank(attachmentPanel.get("AppId")) ? "" : attachmentPanel.get("AppId").toString();
            String formId = StringUtils.isBlank(attachmentPanel.get("FormId")) ? "" : attachmentPanel.get("FormId").toString();
            String billNo = StringUtils.isBlank(attachmentPanel.get("BillNo")) ? "" : attachmentPanel.get("BillNo").toString();
            ArrayList<String> attPanelKeys = new ArrayList<String>();
            if (attachmentPanel.get("ShareAttsMsg") != null) {
                Map shareAttsMsg = (Map)attachmentPanel.get("ShareAttsMsg");
                for (Map.Entry entry : attachmentInfo.entrySet()) {
                    String attPanelKey = (String)entry.getKey();
                    String entityId = (String)shareAttsMsg.get(attPanelKey);
                    if (StringUtils.isEmpty((CharSequence)entityId)) continue;
                    attPanelKeys.add(attPanelKey);
                    AttachmentServiceHelper.saveTempAttachments((String)billNo, (String)entityId, pkId, (String)appId, (Map)attachmentInfo);
                }
            }
            if (attPanelKeys.size() > 0) {
                for (String attPanelKey : attPanelKeys) {
                    attachmentInfo.remove(attPanelKey);
                }
            }
            AttachmentServiceHelper.saveTempAttachments((String)billNo, (String)formId, pkId, (String)appId, (Map)attachmentInfo);
            option.removeVariable(ATTACHMENT_PANEL);
        }
        if (option.containsVariable(ATTACHMENT_FIELD)) {
            String attachmentFieldString = option.getVariableValue(ATTACHMENT_FIELD);
            Map attachmentField = (Map)SerializationUtils.fromJsonString((String)attachmentFieldString, Map.class);
            Object pkId = attachmentField.get("PkId");
            if (StringUtils.isBlank(pkId) || "0".equals(pkId.toString())) {
                pkId = successObjs[0].getPkValue();
            }
            attachmentField.put("PkId", pkId);
            AttachmentFieldServiceHelper.saveTempAttachments((String)SerializationUtils.toJsonString((Object)attachmentField));
            option.removeVariable(ATTACHMENT_FIELD);
        }
    }

    public void deleteAttachCache(String pageId, String entryKey) {
        try {
            IFormView view = SessionManager.getCurrent().getView(pageId);
            if (view == null) {
                return;
            }
            IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            IDataModel model = (IDataModel)view.getService(IDataModel.class);
            IDataEntityType dataEntityType = model.getDataEntity().getDataEntityType();
            if (!(dataEntityType instanceof MainEntityType)) {
                return;
            }
            MainEntityType mainEntityType = (MainEntityType)dataEntityType;
            Map allEntities = mainEntityType.getAllEntities();
            EntityType entityType = (EntityType)allEntities.get(entryKey);
            DataEntityPropertyCollection properties = entityType.getProperties();
            for (IDataEntityProperty property : properties) {
                if (!(property instanceof AttachmentProp)) continue;
                String fieldKey = property.getName();
                Object cacheKeySetJson = proxy.getViewState("attach_" + fieldKey);
                if (StringUtils.isBlank((Object)cacheKeySetJson)) {
                    return;
                }
                Set cacheKeySet = (Set)SerializationUtils.fromJsonString((String)((String)cacheKeySetJson), Set.class);
                for (String cacheKey : cacheKeySet) {
                    proxy.postBack(cacheKey, null);
                }
                proxy.postBack("attach_" + fieldKey, null);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private String getCacheKey(int parentIndex, int currRowIndex, String fieldKey, String pageId) {
        CacheKey key = new CacheKey(parentIndex, currRowIndex, fieldKey, pageId, "SuccessAttIds");
        return SerializationUtils.toJsonString((Object)key);
    }
}

