/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.image;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.attachment.util.AttachmentOpLogUtil;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentOpType;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.FieldType;
import kd.bos.mservice.attachment.IAttachmentManagerService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.image.IImageOperateService;
import kd.bos.service.image.ImgFileService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class ImageOperateServiceImpl
implements IImageOperateService {
    private static final String REMOVEIMAGE = "RemoveImage";
    private static final String THUMBNAILS_PARAMS = "thumbparam";
    private static final String THUMBNAILS_IDENTITY = "_thumbnails_";
    private static final List<String> supportFormat = Arrays.asList(".bmp", ".gif", ".jpg", ".png", ".jpeg");
    private static final String BOS_PICTURE = "bos-picture";
    private static final String I_ATTACHMENT_MANAGER_SERVICE = "IAttachmentManagerService";
    private static final String ENTITY_BOS_ATTACH_OPLOG = "bos_attachment_oplog";
    private static final Log log = LogFactory.getLog(ImageOperateServiceImpl.class);
    private ImgFileService imageFileService;

    public void removeImage(OperateOption option, DynamicObject[] successObjs) {
        try {
            if (option.containsVariable(REMOVEIMAGE)) {
                String removeImageString = option.getVariableValue(REMOVEIMAGE);
                Map cacheMap = (Map)SerializationUtils.fromJsonString((String)removeImageString, Map.class);
                Object pkId = cacheMap.get("PkId");
                if (StringUtils.isBlank(pkId) || "0".equals(pkId.toString())) {
                    pkId = successObjs[0].getPkValue();
                }
                String appId = StringUtils.isBlank(cacheMap.get("AppId")) ? "" : cacheMap.get("AppId").toString();
                String formId = StringUtils.isBlank(cacheMap.get("FormId")) ? "" : cacheMap.get("FormId").toString();
                String billNo = StringUtils.isBlank(cacheMap.get("billno")) ? "" : cacheMap.get("billno").toString();
                Boolean isWeb = (Boolean)cacheMap.get("isWeb");
                List removeList = (List)cacheMap.get("remove");
                if (CollectionUtils.isNotEmpty((Collection)removeList)) {
                    for (HashMap removeMap : removeList) {
                        this.realRemoveImage(removeMap, appId, formId, isWeb, billNo, pkId);
                    }
                }
                option.removeVariable(REMOVEIMAGE);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public void realRemoveImage(HashMap<String, Object> removeMap, String appId, String formId, Boolean isWeb, String billNo, Object pkId) {
        try {
            String path = String.valueOf(removeMap.get("url"));
            String fileName = AttachmentOpLogUtil.getFileName((String)path);
            String fileExt = AttachmentOpLogUtil.getFileExt((String)path);
            List thumbParams = (List)removeMap.get(THUMBNAILS_PARAMS);
            if (StringUtils.isBlank((Object)thumbParams) || thumbParams.size() == 0) {
                this.getFileService().delete(path);
                BillFileMappingWriter.removeMappingRecord((String)path, (String)"image");
            } else {
                List<String> correlationURLs = this.getCorrelationURLs(path, thumbParams);
                for (String url : correlationURLs) {
                    this.getFileService().delete(url);
                    BillFileMappingWriter.removeMappingRecord((String)path, (String)"image");
                }
            }
            this.doRemoveOperationLog(path, appId, formId, isWeb, billNo, pkId, fileName, fileExt);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void doRemoveOperationLog(String path, String appId, String formId, Boolean isWeb, String billNo, Object pkId, String fileName, String fileExt) {
        ArrayList<AttachmentInfo> infos = new ArrayList<AttachmentInfo>(10);
        QFilter[] qFilters = new QFilter[]{new QFilter("OPTYPE", "=", (Object)"1").and(new QFilter("URL", "=", (Object)path))};
        Map opLogObjCol = BusinessDataServiceHelper.loadFromCache((String)ENTITY_BOS_ATTACH_OPLOG, (QFilter[])qFilters);
        for (Map.Entry entry : opLogObjCol.entrySet()) {
            DynamicObject opLogObj = (DynamicObject)entry.getValue();
            Date now = new Date();
            RequestContext rc = RequestContext.get();
            AttachmentInfo attachmentInfo = new AttachmentInfo();
            attachmentInfo.setAttSourceType(AttachmentType.image);
            attachmentInfo.setFieldType(FieldType.Image);
            attachmentInfo.setFieldKey(opLogObj.getString("ATTKEY"));
            attachmentInfo.setAttKey(opLogObj.getString("ATTKEY"));
            attachmentInfo.setFileName(fileName);
            attachmentInfo.setExt(fileExt);
            attachmentInfo.setEntityNum(formId);
            attachmentInfo.setAppId(appId);
            attachmentInfo.setCreateTime(now);
            attachmentInfo.setCreateUserId(rc.getUserId());
            attachmentInfo.setModifyTime(now);
            attachmentInfo.setBillno(billNo);
            attachmentInfo.setBillPkId(String.valueOf(pkId));
            attachmentInfo.setDownloadUrl(path);
            attachmentInfo.setClient(isWeb != false ? "web" : "mobile");
            infos.add(attachmentInfo);
        }
        if (!infos.isEmpty()) {
            IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
            managerService.afterDoOperation(infos, AttachmentOpType.Remove);
        }
    }

    protected FileService getFileService() {
        if (this.imageFileService == null) {
            this.imageFileService = new ImgFileService();
        }
        return this.imageFileService;
    }

    private List<String> getCorrelationURLs(String url, List<Map<String, String>> thumbnailsParams) {
        ArrayList<String> urls = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String originalPictrue = this.getOriginalPictrue(url);
            for (Map<String, String> thumbnailsParameter : thumbnailsParams) {
                String thumbnailsTag = thumbnailsParameter.get("thumbnailsTag");
                String thumbnailsURL = ImageOperateServiceImpl.processPathString(originalPictrue, thumbnailsTag, "");
                urls.add(thumbnailsURL);
            }
            urls.add(originalPictrue);
        }
        return urls;
    }

    private String getOriginalPictrue(String url) {
        if (StringUtils.isNotBlank((CharSequence)url) && StringUtils.contains((CharSequence)url, (CharSequence)THUMBNAILS_IDENTITY)) {
            String subString = StringUtils.substringAfterLast((String)url, (String)THUMBNAILS_IDENTITY);
            String thumbTag = StringUtils.substringBeforeLast((String)subString, (String)".");
            url = StringUtils.replaceOnce((String)url, (String)(THUMBNAILS_IDENTITY + thumbTag), (String)"");
        }
        return url;
    }

    private static String processPathString(String srcPath, String thumbnailsTag, String fileName) {
        boolean isMatch = true;
        String distPath = srcPath.replace("//", "/");
        if (!distPath.contains(".")) {
            distPath = String.format("%s%s", distPath, fileName);
            isMatch = supportFormat.stream().anyMatch(format -> fileName.toLowerCase(Locale.ENGLISH).endsWith((String)format));
        } else {
            isMatch = supportFormat.stream().anyMatch(format -> srcPath.toLowerCase(Locale.ENGLISH).endsWith((String)format));
        }
        if (!isMatch) {
            String msgformat = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4e0a\u4f20\u56fe\u7247\u6587\u4ef6\u7c7b\u578b\uff1a%s", (String)"ImageAction_2", (String)BOS_PICTURE, (Object[])new Object[0]);
            String msg = String.format(msgformat, org.apache.commons.lang.StringUtils.join((Object[])supportFormat.toArray()));
            throw new KDBizException(new ErrorCode("NOSUPPORT_PICTURE_FORMAT", msg), new Object[0]);
        }
        String ext = distPath.substring(StringUtils.lastIndexOf((CharSequence)distPath, (CharSequence)"."));
        if (StringUtils.isNotBlank((CharSequence)thumbnailsTag)) {
            String prefix = distPath.substring(0, StringUtils.lastIndexOf((CharSequence)distPath, (CharSequence)"."));
            distPath = String.format("%s_thumbnails_%s%s", prefix, thumbnailsTag, ext);
        }
        return distPath;
    }

    private void handleException(Exception e) throws IOException {
        log.error((Throwable)e);
    }
}

