/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.tempfile;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.attachment.util.AttachExceptionHandler;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.attachment.util.AttachmentPreviewUtil;
import kd.bos.form.watermark.common.WaterMarkKit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.extend.action.FileActionExtensionFactory;
import kd.bos.service.attachment.extend.permission.FilePermissionExtensionFactory;
import kd.bos.service.attachment.extend.permission.FilePermissionParam;
import kd.bos.service.attachment.extend.permission.FileTypeEnum;
import kd.bos.service.attachment.extend.permission.PermissionResult;
import kd.bos.svc.util.PermissionParam;
import kd.bos.web.actions.AttachmentAction;
import kd.bos.web.actions.utils.AttachmentUtil;
import kd.bos.web.actions.utils.CtsyActionDispatchServiceHelper;
import kd.bos.web.actions.utils.EncryptDownloadUtil;
import kd.bos.web.actions.utils.FileOperationLog;
import kd.bos.web.actions.utils.FilePremissionUtil;
import kd.bos.web.actions.utils.FileReqLimitUtil;
import org.apache.commons.collections4.MapUtils;

public class TempFileWebAction {
    private static Log log = LogFactory.getLog(TempFileWebAction.class);
    private static final String errorMessage = "{'success':'false';'errorCode':'NO Permission!'}";
    private static final String result = "{'success':'false';'errorCode':'File NotFound'}";
    private static final String IS_LOSE_EFFICACY = "is_Lose_Efficacy";
    private static final String BOS_ATTACHMENT = "bos-attachment";
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    public void print(HttpServletRequest request, HttpServletResponse response) throws IOException {
        TempFileCacheDownloadable.Content content;
        block33: {
            try {
                if (CtsyActionDispatchServiceHelper.isCtsyRequest(request)) {
                    CtsyActionDispatchServiceHelper.redirectHttpAction(request, response);
                    return;
                }
            }
            catch (Exception e) {
                log.error("tempfile print ctsy dispatch failed", (Throwable)e);
            }
            response.setContentType("application/pdf");
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            if (!(cache instanceof TempFileCacheDownloadable)) {
                throw new RuntimeException(cache.getClass().getName() + " must implements " + TempFileCacheDownloadable.class.getName());
            }
            TempFileCacheDownloadable downloader = (TempFileCacheDownloadable)cache;
            content = null;
            try {
                content = downloader.download(request);
            }
            catch (KDException e) {
                if (e.getErrorCode() == null || !"NO Permission!".equals(e.getErrorCode().getCode())) break block33;
                this.writeResponseJson((ServletResponse)response, errorMessage);
                return;
            }
        }
        if (content == null) {
            this.writeResponseJson((ServletResponse)response, result);
            return;
        }
        try {
            String encodeFileName = URLEncoder.encode(content.getFilename(), "UTF-8");
            String contentValue = String.format("inline; filename=\"%s\";filename*=utf-8''%s", encodeFileName, encodeFileName);
            response.setHeader("Content-Disposition", contentValue);
            try (BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
                 InputStream input = content.getInputStream();){
                ByteStreams.copy((InputStream)input, (OutputStream)out);
                ((OutputStream)out).flush();
            }
        }
        catch (IOException e) {
            log.error(String.format("error when download %s", request.getRequestURI() + "?" + request.getQueryString()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void download(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (CtsyActionDispatchServiceHelper.isCtsyRequest(request)) {
                CtsyActionDispatchServiceHelper.redirectHttpAction(request, response);
                return;
            }
        }
        catch (Exception e) {
            log.error("tempfile download ctsy dispatch failed", (Throwable)e);
        }
        if (FileReqLimitUtil.checkLimitReq("download", 0)) {
            AttachmentAction.writeErrorMessage(response, AttachmentUtil.getUploadOrDownloadLimitTips("downloadlimit"));
            return;
        }
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        if (!(cache instanceof TempFileCacheDownloadable)) {
            throw new RuntimeException(cache.getClass().getName() + " must implements " + TempFileCacheDownloadable.class.getName());
        }
        StringBuffer url = request.getRequestURL();
        if (request.getQueryString() != null) {
            url.append("?").append(request.getQueryString());
        }
        FilePermissionParam filePermissionParam = new FilePermissionParam(request.getParameter("fId"), request.getParameter("appId"), url.toString(), FileTypeEnum.TEMPFILE, request);
        PermissionResult permissionResult = FilePermissionExtensionFactory.getFilePermissionExtension().checkPermission(filePermissionParam);
        if (!permissionResult.getHasPermission().booleanValue()) {
            AttachmentAction.writeErrorMessage(response, permissionResult.getMsg());
            return;
        }
        TempFileCacheDownloadable downloader = (TempFileCacheDownloadable)cache;
        TempFileCacheDownloadable.Content content = null;
        String fileName = request.getParameter("fileName");
        Boolean success = Boolean.FALSE;
        try {
            block52: {
                try {
                    FilePremissionUtil.checkTempFile((HttpServletRequest)request, (boolean)true);
                    this.dealDisposableUrl(request);
                    content = downloader.download(request);
                }
                catch (KDException e) {
                    log.error((Throwable)e);
                    if (!AttachExceptionHandler.dealException((KDException)e, (HttpServletResponse)response).booleanValue()) break block52;
                    this.doFileDownloadLog(success, request, fileName);
                    return;
                }
            }
            if (content == null) {
                this.writeResponseJson((ServletResponse)response, result);
                return;
            }
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/octet-stream");
            if (StringUtils.isBlank((CharSequence)fileName)) {
                fileName = content.getFilename();
            }
            String agent = request.getHeader("USER-AGENT");
            fileName = FileActionExtensionFactory.getFileActionExtension().getFileName(fileName);
            boolean isFireFox = agent != null && agent.toLowerCase().indexOf("firefox") > 0;
            fileName = FileSecurityUtil.getSecurityHeader((String)fileName);
            if (this.checkIsWpsEdit(request)) {
                response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20"));
            } else if (isFireFox) {
                String rFileName = "=?UTF-8?B?" + new String(Base64.getEncoder().encode(fileName.getBytes("UTF-8"))) + "?=";
                response.addHeader("Content-Disposition", "attachment;filename=" + rFileName);
            } else {
                String rFileName = URLEncoder.encode(fileName, "UTF-8");
                response.addHeader("Content-Disposition", "attachment;filename*=UTF-8''" + rFileName.replaceAll("\\+", "%20"));
            }
            try {
                BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
                Throwable throwable = null;
                try {
                    Throwable throwable2;
                    InputStream tempInputStream;
                    block53: {
                        block54: {
                            block55: {
                                tempInputStream = content.getInputStream();
                                throwable2 = null;
                                String encryptPassword = request.getParameter("password");
                                if (!StringUtils.isNotBlank((CharSequence)encryptPassword)) break block53;
                                EncryptDownloadUtil.encryptDownLoad(request, response, null, fileName, encryptPassword, tempInputStream);
                                if (tempInputStream == null) break block54;
                                if (throwable2 == null) break block55;
                                try {
                                    tempInputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                break block54;
                            }
                            tempInputStream.close();
                        }
                        if (out == null) return;
                        if (throwable != null) {
                            try {
                                ((OutputStream)out).close();
                                return;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                return;
                            }
                        }
                        ((OutputStream)out).close();
                        return;
                    }
                    try {
                        InputStream waterMarked = this.addWaterMark(fileName, request, tempInputStream);
                        ByteStreams.copy((InputStream)waterMarked, (OutputStream)out);
                        ((OutputStream)out).flush();
                        success = Boolean.TRUE;
                        return;
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                    }
                    finally {
                        if (tempInputStream != null) {
                            if (throwable2 != null) {
                                try {
                                    tempInputStream.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                            } else {
                                tempInputStream.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                catch (Throwable throwable9) {
                    throw throwable9;
                }
            }
            catch (IOException e) {
                log.error(String.format("error when download %s", request.getRequestURI() + "?" + request.getQueryString()), (Throwable)e);
                return;
            }
        }
        finally {
            this.doFileDownloadLog(success, request, fileName);
        }
    }

    private void dealDisposableUrl(HttpServletRequest request) {
        String flag;
        String redisKey = IS_LOSE_EFFICACY + request.getParameter("id");
        String disposable = request.getParameter("disposable");
        if (StringUtils.isNotEmpty((CharSequence)disposable)) {
            redisKey = redisKey + disposable;
        }
        if (StringUtils.equals((CharSequence)"false", (CharSequence)(flag = (String)redisCache.get(redisKey)))) {
            redisCache.put(redisKey, (Object)"true");
        } else {
            long disableTime;
            if (StringUtils.equals((CharSequence)"true", (CharSequence)flag)) {
                throw new KDException(new ErrorCode("Invalid Path!", ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u94fe\u63a5\u5931\u6548\uff01", (String)"AttachmentAction_29", (String)BOS_ATTACHMENT, (Object[])new Object[0])), new Object[0]);
            }
            Map permissionParam = PermissionParam.getPermissionParam((String)redisKey);
            if (MapUtils.isEmpty((Map)permissionParam)) {
                return;
            }
            Object countObj = permissionParam.get("count");
            Object disableTimeObj = permissionParam.get("disableTime");
            if (disableTimeObj instanceof Long && (disableTime = ((Long)disableTimeObj).longValue()) > 0L && new Date().getTime() > disableTime) {
                throw new KDException(new ErrorCode("timeout!", ResManager.loadKDString((String)"\u94fe\u63a5\u5df2\u8d85\u65f6\uff01", (String)"AttachmentAction_34", (String)BOS_ATTACHMENT, (Object[])new Object[0])), new Object[0]);
            }
            if (countObj instanceof Integer) {
                int count = (Integer)countObj;
                if (count < 1) {
                    throw new KDException(new ErrorCode("timeout!", ResManager.loadKDString((String)"\u94fe\u63a5\u5df2\u8d85\u65f6\uff01", (String)"AttachmentAction_34", (String)BOS_ATTACHMENT, (Object[])new Object[0])), new Object[0]);
                }
                permissionParam.put("count", --count);
                PermissionParam.updatePermissionParam((String)redisKey, (Map)permissionParam);
            }
        }
    }

    private InputStream addWaterMark(String fileName, HttpServletRequest request, InputStream tempInputStream) {
        boolean isFromYunPan = StringUtils.equals((CharSequence)request.getParameter("source"), (CharSequence)"preview");
        boolean fromOnlyOffice = AttachmentPreviewUtil.fromOnlyOfficeDownLoad((HttpServletRequest)request);
        boolean isAddDownloadWaterMark = WaterMarkKit.isAddDownloadWaterMark((String)fileName, (HttpServletRequest)request, (boolean)fromOnlyOffice);
        if (!isAddDownloadWaterMark || isFromYunPan) {
            return tempInputStream;
        }
        return WaterMarkKit.addWaterMark((HttpServletRequest)request, (String)fileName, (InputStream)tempInputStream);
    }

    private void doFileDownloadLog(Boolean success, HttpServletRequest request, String fileName) {
        if (success.booleanValue()) {
            FileOperationLog.getInstance().createAttachLog(request, fileName);
        }
    }

    private boolean checkIsWpsEdit(HttpServletRequest request) {
        String fileHeader = request.getParameter("fileHeader");
        return StringUtils.equals((CharSequence)"1", (CharSequence)fileHeader);
    }

    public void writeResponseJson(ServletResponse response, CharSequence result) throws IOException {
        response.setContentType("text/json;charset=utf-8");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)response.getOutputStream()), "utf-8");){
            writer.write(result.toString());
            ((Writer)writer).flush();
        }
    }

    public void testPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String content = request.getParameter("content");
        String filename = request.getParameter("filename");
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String url = cache.saveAsUrl(filename, content.getBytes(Charsets.UTF_8), 300000);
        String result = "{'success':'true';'url':" + url + "}";
        this.writeResponseJson((ServletResponse)response, result);
    }

    public void remove(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (CtsyActionDispatchServiceHelper.isCtsyRequest(request)) {
                CtsyActionDispatchServiceHelper.redirectHttpAction(request, response);
                return;
            }
        }
        catch (Exception e) {
            log.error("tempfile remove ctsy dispatch failed", (Throwable)e);
        }
        String result = "{\"status\":\"success\"}";
        this.writeResponseJson((ServletResponse)response, result);
    }
}

