/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.file.security;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.CustomParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.file.security.FileCheckResult;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.fileservice.impl.WatermarkService;
import kd.bos.fileservice.watermark.WatermarkParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.actions.utils.FileTypeUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class FileChecker {
    private static Log log = LogFactory.getLog(FileChecker.class);
    private static List<String> excelFileTypeList = new ArrayList<String>(5);
    private static List<String> zipFileTypeList = new ArrayList<String>(2);
    private static List<String> pdfFileTypeList = new ArrayList<String>(1);
    private static List<String> csvFormulaList = new ArrayList<String>();
    private static Pattern NotPrintCharPattern = Pattern.compile("[\\p{C}&&[^\\s]&&[^\n]&&[^\r][^\t]]");
    private static final List<String> supportPicTypeList = Arrays.asList("bmp", "jpg", "png", "jpeg");

    public static InputStream fileSecurityVerification(InputStream in, String fileName) {
        BufferedInputStream[] bufferedInputStreams;
        if (fileName == null) {
            return in;
        }
        String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1);
        fileExt = fileExt.toLowerCase(Locale.ENGLISH);
        boolean isExcel = false;
        boolean isZip = false;
        boolean isPdf = false;
        if (excelFileTypeList.contains(fileExt)) {
            isExcel = true;
        }
        if (zipFileTypeList.contains(fileExt)) {
            isZip = true;
        }
        if (pdfFileTypeList.contains(fileExt)) {
            isPdf = true;
        }
        BufferedInputStream buffInputStream = new BufferedInputStream(in);
        if (!(isExcel || isZip || isPdf)) {
            String[] fileRealExtArr;
            String fileRealExt = fileExt;
            try {
                fileRealExt = FileTypeUtil.getFileType(buffInputStream);
            }
            catch (IOException e) {
                log.error("[\u9644\u4ef6\u5b89\u5168\u6821\u9a8c\uff1a\u83b7\u53d6\u771f\u5b9e\u6587\u4ef6\u7c7b\u578b\u9519\u8bef]" + e);
            }
            if (StringUtils.isEmpty((CharSequence)fileRealExt)) {
                return buffInputStream;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)fileRealExt, (CharSequence)fileExt)) {
                return buffInputStream;
            }
            for (String fileRealExtTmp : fileRealExtArr = fileRealExt.split(",")) {
                if (excelFileTypeList.contains(fileRealExtTmp)) {
                    isExcel = true;
                }
                if (zipFileTypeList.contains(fileRealExtTmp)) {
                    isZip = true;
                }
                if (!pdfFileTypeList.contains(fileRealExtTmp)) continue;
                isPdf = true;
            }
            if (!(isExcel || isZip || isPdf)) {
                return buffInputStream;
            }
        }
        FileCheckResult fileCheckResult = FileCheckResult.pass();
        if (isExcel) {
            bufferedInputStreams = new BufferedInputStream[]{buffInputStream};
            fileCheckResult = FileChecker.checkExcelFile(bufferedInputStreams, fileExt);
            buffInputStream = bufferedInputStreams[0];
        }
        if (isZip) {
            bufferedInputStreams = new BufferedInputStream[]{buffInputStream};
            fileCheckResult = FileChecker.checkZipFile(bufferedInputStreams, fileName);
            buffInputStream = bufferedInputStreams[0];
        }
        if (isPdf) {
            fileCheckResult = FileChecker.checkPdfFile(buffInputStream);
        }
        if (!fileCheckResult.isCheckReuslt()) {
            throw new KDException(new ErrorCode("CHECK_FILE_ERROR", fileCheckResult.getErrorMsg()), new Object[0]);
        }
        return buffInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileCheckResult checkPdfFile(BufferedInputStream in) {
        Map securityParam = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_filesecurityparam");
        Boolean checkPdf = securityParam.size() == 0 ? SystemPropertyUtils.getBoolean((String)RequestContext.get().getTenantId(), (String)"check.file.pdf", (Boolean)Boolean.FALSE) : Boolean.parseBoolean(String.valueOf(securityParam.get("pdfsecurity")));
        if (!checkPdf.booleanValue()) {
            return FileCheckResult.pass();
        }
        in.mark(Integer.MAX_VALUE);
        PDDocument document = null;
        try {
            document = PDDocument.load((InputStream)in);
            Collection cosBases = document.getDocumentCatalog().getCOSObject().getValues();
            for (COSBase curCosBase : cosBases) {
                String toStringValue = curCosBase.toString();
                if (curCosBase instanceof COSObject) {
                    toStringValue = ((COSObject)curCosBase).getObject().toString();
                }
                if (!toStringValue.contains("COSName{JS}") && !toStringValue.contains("COSName{JavaScript}")) continue;
                String errMsg = ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u4e2d\u5b58\u5728\u6076\u610f\u4fe1\u606f\uff0c\u5b89\u5168\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"FileChecker_0", (String)"bos-attachment", (Object[])new Object[0]);
                FileCheckResult fileCheckResult = FileCheckResult.refuse(errMsg);
                return fileCheckResult;
            }
        }
        catch (Exception e) {
            log.error("checkPdfFile bufferedInputStream error is ", (Throwable)e);
            FileCheckResult fileCheckResult = FileCheckResult.pass();
            return fileCheckResult;
        }
        finally {
            try {
                in.reset();
            }
            catch (IOException e) {
                log.error("checkPdfFile bufferedInputStream reset error is ", (Throwable)e);
            }
        }
        return FileCheckResult.pass();
    }

    private static File writeToTempFile(InputStream sourceInputStream, String fileExt) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile(UUID.randomUUID().toString(), ".zip");
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            FileUtils.copyInputStreamToFile((InputStream)sourceInputStream, (File)tempFile);
        }
        catch (IOException e) {
            log.error("excelSecurityVerification writeToTempFile error is " + e);
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileCheckResult checkExcelFile(BufferedInputStream[] in, String fileExt) {
        Map securityParam = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_filesecurityparam");
        Boolean checkExcel = securityParam.size() == 0 ? SystemPropertyUtils.getBoolean((String)RequestContext.get().getTenantId(), (String)"check.file.security", (Boolean)Boolean.FALSE) : Boolean.parseBoolean(String.valueOf(securityParam.get("excelsecurity")));
        log.debug("check.file.security is " + checkExcel);
        if (!checkExcel.booleanValue()) {
            return FileCheckResult.pass();
        }
        FileCheckResult fileCheckResult = FileCheckResult.pass();
        in[0].mark(Integer.MAX_VALUE);
        log.debug("zipEntry checkExcelFile ---- isCsvOrXls begin ");
        if (FileChecker.isCsvOrXls(in[0])) {
            return FileChecker.checkCsvAndXlsFile(in[0], fileExt);
        }
        log.debug("zipEntry checkExcelFile ---- isCsvOrXls end ");
        int byteCount = 0x6400000;
        File tempFile = null;
        try {
            tempFile = File.createTempFile(UUID.randomUUID().toString(), "zip");
            FileUtils.copyInputStreamToFile((InputStream)in[0], (File)tempFile);
            in[0] = new BufferedInputStream(Files.newInputStream(tempFile.toPath(), new OpenOption[0]));
            ZipFile zipFile = new ZipFile(tempFile);
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                String sheetFileContent;
                BufferedReader bufferedReader;
                InputStreamReader reader;
                ZipEntry zipEntry = (ZipEntry)entries.nextElement();
                long size = zipEntry.getSize();
                if (size >= (long)byteCount) continue;
                String fileName = zipEntry.getName();
                InputStream zipIn = zipFile.getInputStream(zipEntry);
                log.debug("zipEntry begin ---- fileName is " + fileName + " , zipEntry size is " + size);
                if (!zipEntry.isDirectory() && fileName.contains("xl/externalLinks/externalLink") && fileName.endsWith(".xml")) {
                    String externalLinkFileContent;
                    reader = new InputStreamReader(zipIn, "UTF-8");
                    bufferedReader = new BufferedReader(reader);
                    while ((externalLinkFileContent = bufferedReader.readLine()) != null) {
                        if (!externalLinkFileContent.contains("ddeService=\"cmd\"") && !externalLinkFileContent.contains("ddeService=\"calc\"")) continue;
                        FileCheckResult fileCheckResult2 = FileCheckResult.commonRefuse();
                        return fileCheckResult2;
                    }
                } else if (!zipEntry.isDirectory() && fileName.contains("xl/worksheets/sheet") && fileName.endsWith(".xml")) {
                    reader = new InputStreamReader(zipIn, "UTF-8");
                    bufferedReader = new BufferedReader(reader);
                    while ((sheetFileContent = bufferedReader.readLine()) != null) {
                        if (!sheetFileContent.contains("<f>HYPERLINK") && !sheetFileContent.contains("<f ca=\"1\">IMPORTXML")) continue;
                        FileCheckResult fileCheckResult3 = FileCheckResult.commonRefuse();
                        return fileCheckResult3;
                    }
                } else if (!zipEntry.isDirectory() && fileName.equals("xl/workbook.xml")) {
                    reader = new InputStreamReader(zipIn, "UTF-8");
                    bufferedReader = new BufferedReader(reader);
                    while ((sheetFileContent = bufferedReader.readLine()) != null) {
                        if (!sheetFileContent.contains("onerror=alert(")) continue;
                        FileCheckResult fileCheckResult4 = FileCheckResult.commonRefuse();
                        return fileCheckResult4;
                    }
                }
                zipIn.close();
            }
        }
        catch (Exception e) {
            log.error("checkExcelFile bufferedInputStream read excel error is ", (Throwable)e);
            FileCheckResult fileCheckResult5 = fileCheckResult;
            return fileCheckResult5;
        }
        finally {
            try {
                if (tempFile != null && !tempFile.delete()) {
                    log.error("delete error");
                }
                in[0].reset();
            }
            catch (IOException e) {
                log.error("checkExcelFile bufferedInputStream reset error is ", (Throwable)e);
            }
        }
        return fileCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCsvOrXls(BufferedInputStream in) {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(in);
            java.util.zip.ZipEntry nextEntry = zipInputStream.getNextEntry();
            boolean bl = nextEntry == null;
            return bl;
        }
        catch (IOException e) {
            log.warn("checkExcelFile bufferedInputStream isCsvOrXls error is ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                in.reset();
            }
            catch (IOException e) {
                log.error("checkExcelFile bufferedInputStream reset error is ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileCheckResult checkCsvAndXlsFile(BufferedInputStream in, String fileExt) {
        try {
            String content;
            int readByte;
            int byteCount = 0x500000;
            int len = 0;
            byte[] bufArr = new byte[byteCount];
            while ((readByte = in.read()) != -1) {
                bufArr[len] = (byte)readByte;
                if (++len != byteCount) continue;
                content = new String(bufArr, 0, len, StandardCharsets.UTF_8);
                if (FileChecker.checkCsvAndXlsFormula(fileExt, content)) {
                    FileCheckResult fileCheckResult = FileCheckResult.commonRefuse();
                    return fileCheckResult;
                }
                bufArr = new byte[byteCount];
                len = 0;
            }
            content = new String(bufArr, 0, len, StandardCharsets.UTF_8);
            if (FileChecker.checkCsvAndXlsFormula(fileExt, content)) {
                FileCheckResult fileCheckResult = FileCheckResult.commonRefuse();
                return fileCheckResult;
            }
        }
        catch (Exception e) {
            log.warn("checkExcelFile checkCsvFile error is ", (Throwable)e);
            FileCheckResult fileCheckResult = FileCheckResult.pass();
            return fileCheckResult;
        }
        finally {
            try {
                in.reset();
            }
            catch (IOException e) {
                log.error("checkExcelFile bufferedInputStream reset error is ", (Throwable)e);
            }
        }
        return FileCheckResult.pass();
    }

    private static boolean checkCsvAndXlsFormula(String fileExt, String content) {
        for (String csvFormula : FileChecker.getCsvFormulaList()) {
            if ("xls".equals(fileExt) && FileChecker.contentContainFormulaKeyForXls(content)) {
                log.debug("checkExcelFile .xls file contains csvFormula : " + csvFormula);
                return true;
            }
            if (!"csv".equals(fileExt)) continue;
            if (!FileChecker.contentContainFormulaKeyForCsv(content)) {
                return false;
            }
            String[] cellValues = content.contains(",") ? content.split(",") : new String[]{content};
            for (int i = 0; i < cellValues.length; ++i) {
                boolean startWithFormulaTag;
                String cellValue = cellValues[i];
                boolean bl = startWithFormulaTag = (cellValue = NotPrintCharPattern.matcher(cellValue).replaceAll("").trim()).startsWith("+") || cellValue.startsWith("-") || cellValue.startsWith("=") || cellValue.startsWith("@") || cellValue.startsWith("<");
                if (!startWithFormulaTag || !FileChecker.contentContainFormulaKeyForCsv(cellValue)) continue;
                log.debug("checkExcelFile .csv file contains csvFormula : " + cellValue);
                return true;
            }
        }
        return false;
    }

    private static boolean contentContainFormulaKeyForXls(String content) {
        return content.contains("cmd") || content.contains("_PID_HLINKS") || content.contains("IMPORTXML") || content.contains("onerror=alert(");
    }

    private static boolean contentContainFormulaKeyForCsv(String content) {
        String contentUpperCase = content.toUpperCase();
        return contentUpperCase.contains("CMD") || contentUpperCase.contains("HYPERLINK") || contentUpperCase.contains("IMPORTXML") || content.contains("onerror=alert(");
    }

    private static List<String> getCsvFormulaList() {
        String csvFormulaString = SystemPropertyUtils.getProptyByTenant((String)"csv.formula.list", (String)RequestContext.get().getTenantId());
        if (csvFormulaString != null && csvFormulaString.contains(",")) {
            String[] csvFormulaArray = csvFormulaString.split(",");
            csvFormulaList.addAll(Arrays.asList(csvFormulaArray));
        }
        return csvFormulaList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileCheckResult checkZipFile(BufferedInputStream[] in, String zipFileName) {
        Map securityParam = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_filesecurityparam");
        boolean checkZip = securityParam.size() == 0 ? SystemPropertyUtils.getBoolean((String)RequestContext.get().getTenantId(), (String)"check.file.zip", (Boolean)Boolean.TRUE) : Boolean.parseBoolean(String.valueOf(securityParam.get("compresssecurity")));
        Map customParameterFromCache = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        boolean closeBoomZipCheck = Boolean.parseBoolean((String)customParameterFromCache.get("CLOSE_BOOM_ZIP_CHECK"));
        if (!checkZip && closeBoomZipCheck) {
            return FileCheckResult.pass();
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile(UUID.randomUUID().toString(), "zip");
            FileUtils.copyInputStreamToFile((InputStream)in[0], (File)tempFile);
            in[0] = new BufferedInputStream(new FileInputStream(tempFile));
            ZipFile zipFile = new ZipFile(tempFile);
            FileCheckResult fileCheckResult = FileChecker.checkZipSubFiles(zipFile, zipFileName, checkZip, closeBoomZipCheck);
            if (!fileCheckResult.isCheckReuslt()) {
                FileCheckResult fileCheckResult2 = fileCheckResult;
                return fileCheckResult2;
            }
        }
        catch (IOException e) {
            log.error("checkZipFile bufferedInputStream error is ", (Throwable)e);
            FileCheckResult fileCheckResult = FileCheckResult.pass();
            return fileCheckResult;
        }
        finally {
            if (tempFile != null && !tempFile.delete()) {
                log.error("delete error");
            }
            try {
                in[0].reset();
            }
            catch (IOException e) {
                log.error("checkPdfFile bufferedInputStream reset error is ", (Throwable)e);
            }
        }
        return FileCheckResult.pass();
    }

    private static FileCheckResult checkZipSubFiles(ZipFile zipFile, String zipFileName, boolean checkZip, boolean closeBoomZipCheck) throws IOException {
        long originalSize = 0L;
        long compressedSize = 0L;
        Enumeration entries = zipFile.getEntries();
        while (entries.hasMoreElements()) {
            int bufferSize;
            ZipEntry zipEntry = (ZipEntry)entries.nextElement();
            String zipSubFileName = zipEntry.getName();
            if (zipEntry.isDirectory()) continue;
            long zipEntrySize = zipEntry.getSize();
            if (!closeBoomZipCheck && zipEntrySize != 0L) {
                boolean compressedRatio;
                boolean bl = compressedRatio = (originalSize += zipEntrySize) / (compressedSize += zipEntry.getCompressedSize()) > 100L;
                if (compressedRatio) {
                    log.debug("checkZipFile find zipboom : file originalSize is " + originalSize + " , compressedSize is " + compressedSize);
                    return FileCheckResult.boomZipFileRefuse();
                }
            }
            if (!checkZip) continue;
            if (zipEntrySize == 0L) {
                return FileCheckResult.zipEmptyFileRefuse(zipSubFileName);
            }
            if (zipEntrySize >= Integer.MAX_VALUE) {
                return FileCheckResult.pass();
            }
            InputStream zipSubFileInputStream = zipFile.getInputStream(zipEntry);
            BufferedInputStream bufferedZipSubFileInputStream = new BufferedInputStream(zipSubFileInputStream, bufferSize = Integer.parseInt(String.valueOf(zipEntrySize)) + 1);
            FileCheckResult fileCheckResult = FileChecker.isForbidUpload(bufferedZipSubFileInputStream, null, zipSubFileName, true);
            if (!fileCheckResult.isCheckReuslt()) {
                return FileCheckResult.zipSubFileRefuse(zipFileName, fileCheckResult.getRealFileName());
            }
            String fileExt = zipSubFileName.substring(zipSubFileName.lastIndexOf(".") + 1);
            if (zipFileTypeList.contains(fileExt) && !(fileCheckResult = FileChecker.checkZipFile(new BufferedInputStream[]{bufferedZipSubFileInputStream}, zipFileName)).isCheckReuslt()) {
                return fileCheckResult;
            }
            zipSubFileInputStream.close();
            bufferedZipSubFileInputStream.close();
        }
        return FileCheckResult.pass();
    }

    public static FileCheckResult isForbidUpload(BufferedInputStream buffInputStream, List<String> controlWhiteTypeList, String fileName, boolean zipSubFile) {
        FileCheckResult fileCheckResult = FileChecker.isForbidUpload(controlWhiteTypeList, fileName, zipSubFile);
        if (!fileCheckResult.isCheckReuslt()) {
            return fileCheckResult;
        }
        String[] splits = fileName.trim().split("\\.");
        if (splits.length < 2) {
            return FileCheckResult.pass();
        }
        try {
            fileName = FileTypeUtil.getFileRealName(fileName, buffInputStream);
        }
        catch (IOException e) {
            log.error("FileTypeUtil.getFileRealName error : " + e);
            return FileCheckResult.pass();
        }
        if ("errorfile.errorfile".equals(fileName)) {
            return FileCheckResult.refuse(ResManager.loadKDString((String)"\u7981\u6b62\u4e0a\u4f20\u975e\u6cd5\u6587\u4ef6\u3002", (String)"AttachmentAction_18", (String)"bos-webactions", (Object[])new Object[0]));
        }
        return FileChecker.isForbidUpload(controlWhiteTypeList, fileName, zipSubFile);
    }

    private static FileCheckResult isForbidUpload(List<String> controlWhiteTypeList, String fileName, boolean zipSubFile) {
        String[] splits;
        List forbiddenFileTpyeList = new ArrayList();
        List<Object> whiteTypeList = new ArrayList();
        Object setting = DispatchServiceHelper.invokeBOSService((String)"IAttachmentService", (String)"getAttSetting", (Object[])new Object[0]);
        if (setting instanceof Map) {
            forbiddenFileTpyeList = (List)((Map)setting).get("forbidfiletype");
            List<Object> list = whiteTypeList = ((Map)setting).get("whitelist") != null ? (List)((Map)setting).get("whitelist") : new ArrayList();
        }
        if (CollectionUtils.isNotEmpty(controlWhiteTypeList)) {
            whiteTypeList.retainAll(controlWhiteTypeList);
            if (whiteTypeList.isEmpty()) {
                whiteTypeList = controlWhiteTypeList;
            }
        }
        if (zipSubFile) {
            whiteTypeList = new ArrayList();
        }
        if ((splits = fileName.trim().split("\\.")).length < 2) {
            return FileCheckResult.pass();
        }
        String fileType = splits[splits.length - 1];
        long occurCounts = forbiddenFileTpyeList.stream().filter(s -> s.equalsIgnoreCase(fileType)).count();
        boolean enableUplod = false;
        if (occurCounts == 0L) {
            if (whiteTypeList.isEmpty()) {
                enableUplod = true;
            } else {
                boolean bl = enableUplod = whiteTypeList.stream().filter(s -> s.equalsIgnoreCase(fileType)).count() > 0L;
            }
        }
        if (!enableUplod) {
            return FileCheckResult.forbidTypeRefuse(fileName);
        }
        return FileCheckResult.pass();
    }

    public static InputStream addSecurityWaterMark(String fileName, InputStream inputStream) throws IOException {
        log.debug("before cache.saveAsUrl InputStream.available() " + inputStream.available());
        Boolean checkPic = SystemPropertyUtils.getBoolean((String)RequestContext.get().getTenantId(), (String)"check.file.picture", (Boolean)Boolean.FALSE);
        if (!checkPic.booleanValue()) {
            return inputStream;
        }
        if (!fileName.contains(".")) {
            return inputStream;
        }
        String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (!supportPicTypeList.contains(fileExt = fileExt.toLowerCase(Locale.ENGLISH))) {
            return inputStream;
        }
        WatermarkService watermarkService = new WatermarkService();
        WatermarkParameter.Builder builder = new WatermarkParameter.Builder(Integer.valueOf(1), ResManager.loadKDString((String)"\u5b89\u5168\u6c34\u5370", (String)"WaterMarker_1", (String)"bos-attachment", (Object[])new Object[0]));
        WatermarkParameter watermarkParameter = builder.setColor(Color.BLACK).setAlpha(Float.valueOf(0.0f)).setSize(Integer.valueOf(12)).setRotation(Integer.valueOf(0)).setPosition("").build();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put(PreviewParams.STATUS.getEnumName(), PreviewParams.SUCCESS.getEnumName());
        result.put(PreviewParams.RESULT.getEnumName(), inputStream);
        try {
            watermarkService.addWatermark(result, fileName, watermarkParameter);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        inputStream = (InputStream)result.get(PreviewParams.RESULT.getEnumName());
        return inputStream;
    }

    static {
        excelFileTypeList.add("xls");
        excelFileTypeList.add("xlsx");
        excelFileTypeList.add("xlsm");
        excelFileTypeList.add("xlsb");
        excelFileTypeList.add("csv");
        zipFileTypeList.add("zip");
        zipFileTypeList.add("rar");
        pdfFileTypeList.add("pdf");
        csvFormulaList.add("=1+cmd|' /C calc'!A0");
    }
}

