/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.attachment;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Vector;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.EncryptUtils;

public class EncryptFilePlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(EncryptFilePlugin.class);
    private static final String LABEL_DOWNLOAD = "labeldownload";
    private static final String LABEL_EXPORT = "labelexport";
    private static final String LABEL_EXPORT_EX = "labelexportex";
    private static final String BOS_ATTACHMENT = "bos-attachment";
    private static final String SPECIAL_CHAR = "!@#$%^&*.";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "setpw", "confirmpw", "vectorsetpw", "vectorsetpwshow", "vectorconfirmpw", "vectorconfirmpwshow"});
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Vector) {
            String key = ((Vector)evt.getSource()).getKey();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"vectorsetpw")) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexsetpwshow"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexsetpw"});
                Object password = ((Button)evt.getSource()).getModel().getDataEntity().get(0);
                this.getView().getModel().setValue("setpwshow", password);
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)"vectorsetpwshow")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexsetpwshow"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexsetpw"});
                Object password = ((Button)evt.getSource()).getModel().getDataEntity().get(2);
                this.getView().getModel().setValue("setpw", password);
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)"vectorconfirmpw")) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexconfirmpwshow"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexconfirmpw"});
                Object password = ((Button)evt.getSource()).getModel().getDataEntity().get(1);
                this.getView().getModel().setValue("confirmpwshow", password);
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)"vectorconfirmpwshow")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexconfirmpwshow"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexconfirmpw"});
                Object password = ((Button)evt.getSource()).getModel().getDataEntity().get(3);
                this.getView().getModel().setValue("confirmpw", password);
            }
            return;
        }
        FormShowParameter currShowParameter = this.getView().getFormShowParameter();
        String encryptType = (String)currShowParameter.getCustomParam("encryptType");
        Object password = ((Button)evt.getSource()).getModel().getDataEntity().get(0);
        Object repeatPassword = ((Button)evt.getSource()).getModel().getDataEntity().get(1);
        String index1 = this.getView().getPageCache().get("setpasswordIndex");
        String index2 = this.getView().getPageCache().get("confirmpasswordIndex");
        if (StringUtils.isNotEmpty((CharSequence)index1)) {
            password = ((Button)evt.getSource()).getModel().getDataEntity().get(Integer.parseInt(index1));
        }
        if (StringUtils.isNotEmpty((CharSequence)index2)) {
            repeatPassword = ((Button)evt.getSource()).getModel().getDataEntity().get(Integer.parseInt(index2));
        }
        if (StringUtils.isBlank((Object)password)) {
            if (StringUtils.equals((CharSequence)encryptType, (CharSequence)"1")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u5f3a\u5236\u542f\u7528\u5bfc\u51fa\u6587\u4ef6\u52a0\u5bc6\uff0c\u8bf7\u8bbe\u7f6e\u5bfc\u51fa\u6587\u4ef6\u5bc6\u7801\u3002", (String)"AttachmentEnc_1", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u5f3a\u5236\u542f\u7528\u4e0b\u8f7d\u6587\u4ef6\u52a0\u5bc6\uff0c\u8bf7\u8bbe\u7f6e\u4e0b\u8f7d\u6587\u4ef6\u5bc6\u7801\u3002", (String)"AttachmentEnc_2", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
            }
            return;
        }
        if (!password.equals(repeatPassword)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"AttachmentEnc_3", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
            return;
        }
        if (password.toString().length() < 4 || !this.checkPasswordRight(((String)password).toCharArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u53ea\u80fd\u4e3a\u5b57\u6bcd+\u6570\u5b57+\u7279\u6b8a\u7b26\u53f7(!@#$%^&*.)\u76844\u81f316\u4f4d\u5b57\u7b26\u7ec4\u5408\u3002", (String)"AttachmentEnc_4", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
            return;
        }
        try {
            password = URLEncoder.encode(EncryptUtils.encrypt((String)"", (String)password.toString()), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("encode password failed", (Throwable)e);
        }
        if (StringUtils.equals((CharSequence)encryptType, (CharSequence)"1")) {
            String exportLogUrl;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("password", password);
            Object tempId = this.getView().getFormShowParameter().getCustomParam("templateId");
            if (null != tempId) {
                Long templateId = Long.parseLong(String.valueOf(tempId));
                params.put("templateId", templateId);
            }
            if (StringUtils.isNotBlank((CharSequence)(exportLogUrl = (String)this.getView().getFormShowParameter().getCustomParam("exportLogUrl")))) {
                params.put("exportLogUrl", exportLogUrl);
            }
            this.getView().returnDataToParent(params);
        } else if (StringUtils.equals((CharSequence)encryptType, (CharSequence)"0")) {
            String uid = (String)currShowParameter.getCustomParam("uid");
            String key = (String)currShowParameter.getCustomParam("methodKey");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("uid", uid);
            params.put("password", password);
            params.put("methodKey", key);
            this.getView().returnDataToParent(params);
        } else if (StringUtils.equals((CharSequence)encryptType, (CharSequence)"2")) {
            String formId = (String)this.getView().getFormShowParameter().getCustomParam("billFormId");
            String batchDownloadAttDtoList = (String)this.getView().getFormShowParameter().getCustomParam("batchDownloadAttDtoList");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("password", password);
            params.put("billFormId", formId);
            params.put("batchDownloadAttDtoList", batchDownloadAttDtoList);
            this.getView().returnDataToParent(params);
        } else if (StringUtils.equals((CharSequence)encryptType, (CharSequence)"3")) {
            String key = (String)currShowParameter.getCustomParam("methodKey");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("password", password);
            params.put("downloadAll", true);
            params.put("methodKey", key);
            this.getView().returnDataToParent(params);
        }
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)changeName, (CharSequence)"setpw")) {
            this.getView().getPageCache().put("setpasswordIndex", "0");
        } else if (StringUtils.equals((CharSequence)changeName, (CharSequence)"setpwshow")) {
            this.getView().getPageCache().put("setpasswordIndex", "2");
        } else if (StringUtils.equals((CharSequence)changeName, (CharSequence)"confirmpw")) {
            this.getView().getPageCache().put("confirmpasswordIndex", "1");
        } else if (StringUtils.equals((CharSequence)changeName, (CharSequence)"confirmpwshow")) {
            this.getView().getPageCache().put("confirmpasswordIndex", "3");
        }
    }

    public void beforeBindData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexsetpwshow"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexconfirmpwshow"});
        FormShowParameter currShowParameter = this.getView().getFormShowParameter();
        String encryptType = (String)currShowParameter.getCustomParam("encryptType");
        if (StringUtils.equals((CharSequence)encryptType, (CharSequence)"0") || StringUtils.equals((CharSequence)encryptType, (CharSequence)"2") || StringUtils.equals((CharSequence)encryptType, (CharSequence)"3")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LABEL_EXPORT});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LABEL_EXPORT_EX});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btncancelexport"});
        } else if (StringUtils.equals((CharSequence)encryptType, (CharSequence)"1")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LABEL_DOWNLOAD});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btncancel"});
        }
    }

    private boolean checkPasswordRight(char[] pwd) {
        boolean flag = false;
        StringBuilder sb = new StringBuilder();
        int specialCount = 0;
        for (int i = 0; i < pwd.length; ++i) {
            char c = pwd[i];
            if (SPECIAL_CHAR.contains(String.valueOf(c))) {
                flag = true;
                ++specialCount;
                continue;
            }
            sb.append(c);
        }
        if (flag) {
            int length = pwd.length - specialCount;
            if (length <= 0) {
                return false;
            }
            String regex = "^(?![0-9]+$)(?![a-zA-Z]+$)[a-zA-Z0-9]{2,16}$";
            Pattern p = Pattern.compile(regex);
            Matcher matcher = p.matcher(sb.toString());
            Arrays.fill(pwd, ' ');
            return matcher.matches();
        }
        Arrays.fill(pwd, ' ');
        return false;
    }
}

