/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.param;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.param.util.ParamDealUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AttachmentServerParamPlugin
extends AbstractFormPlugin {
    private static final String FIELD_MAXUPLOADSIZE = "maxuploadsize";
    private static final String FIELD_FORBIDFILETYPE = "forbidfiletype";
    private static final String FORM_FORBIDFILETYPE = "bos_forbidfiletype";
    private static final String FIELD_PREVIEWCONFIG = "previewconfig";
    private static final String FIELD_PREVIEWCONFIG_SHOWINFO = "previewconfig_show";
    private static final String FORM_PREVIEWCONFIG = "bos_attach_previewconfig";
    private static final String FIELD_MANAGERSERVICE = "managerservice";
    private static final String FORM_MANAGERSERVICE = "bos_attach_managerservice";
    private static final String FIELD_UPLOADLIMIT = "uploadlimit";
    private static final String FIELD_UPLOADLIMIT_CONTENT = "uploadlimitcontent";
    private static final String FORM_UPLOADLIMIT = "bos_attach_uploadlimit";
    private static final String FIELD_DOWNLOADLIMIT = "downloadlimit";
    private static final String FIELD_DOWNLOADLIMIT_CONTENT = "downloadlimitcontent";
    private static final String FORM_DOWNLOADLIMIT = "bos_attach_downloadlimit";
    private static final String FIELD_SECONDLIMIT = "secondlimit";
    private static final String FIELD_MINUTELIMIT = "minutelimit";
    private static final String FIELD_HOURLIMIT = "hourlimit";
    private static final String FIELD_DAYLIMIT = "daylimit";
    private static final String BOS_ATTACHMENT = "bos-attachment";
    private static final int FILE_SIZE_DIVISOR = 0x100000;
    private static final long DEFAULT_SIZE = 50L;
    private static final Log log = LogFactory.getLog(AttachmentServerParamPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{FIELD_FORBIDFILETYPE, FIELD_PREVIEWCONFIG, FIELD_MANAGERSERVICE, FIELD_UPLOADLIMIT, FIELD_DOWNLOADLIMIT, FIELD_PREVIEWCONFIG_SHOWINFO});
    }

    public void afterCreateNewData(EventObject e) {
        String configTipsUpload;
        String uploadLimitContent;
        this.hideUploadLimitFork();
        int maxSize = (Integer)this.getModel().getValue(FIELD_MAXUPLOADSIZE);
        if (maxSize == 0) {
            Long kb = FileServiceFactory.getAttachmentFileService().maxUploadSize();
            long mb = kb <= 0L ? 50L : kb / 0x100000L;
            this.getModel().setValue(FIELD_MAXUPLOADSIZE, (Object)((int)mb));
        }
        if (StringUtils.isNotBlank((CharSequence)(uploadLimitContent = (String)this.getModel().getValue(FIELD_UPLOADLIMIT_CONTENT)))) {
            configTipsUpload = this.formatConfigTips("upload", (Map)SerializationUtils.fromJsonString((String)uploadLimitContent, Map.class));
        } else {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put(FIELD_SECONDLIMIT, "");
            config.put(FIELD_MINUTELIMIT, "");
            config.put(FIELD_HOURLIMIT, "");
            config.put(FIELD_DAYLIMIT, "150000");
            this.getModel().setValue(FIELD_UPLOADLIMIT_CONTENT, (Object)SerializationUtils.toJsonString(config));
            configTipsUpload = this.formatConfigTips("upload", config);
        }
        this.getModel().setValue(FIELD_UPLOADLIMIT, (Object)configTipsUpload);
        String downloadLimitContent = (String)this.getModel().getValue(FIELD_DOWNLOADLIMIT_CONTENT);
        if (StringUtils.isNotBlank((CharSequence)downloadLimitContent)) {
            String configTips = this.formatConfigTips("download", (Map)SerializationUtils.fromJsonString((String)downloadLimitContent, Map.class));
            this.getModel().setValue(FIELD_DOWNLOADLIMIT, (Object)configTips);
        }
    }

    private void hideUploadLimitFork() {
        HashMap meta = new HashMap();
        HashMap<String, Boolean> itemMap = new HashMap<String, Boolean>();
        itemMap.put("showClearButton", false);
        meta.put("item", itemMap);
        this.getView().updateControlMetadata(FIELD_UPLOADLIMIT, meta);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (FIELD_UPLOADLIMIT.equals(fieldName) && StringUtils.isBlank((Object)changeSet[0].getNewValue())) {
            this.getModel().setValue(FIELD_UPLOADLIMIT_CONTENT, null);
        }
        if (FIELD_DOWNLOADLIMIT.equals(fieldName) && StringUtils.isBlank((Object)changeSet[0].getNewValue())) {
            this.getModel().setValue(FIELD_DOWNLOADLIMIT_CONTENT, null);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if (FIELD_FORBIDFILETYPE.equals(c.getKey())) {
            this.showAttahConfigFrom(FORM_FORBIDFILETYPE, FIELD_MAXUPLOADSIZE);
            return;
        }
        if (FIELD_PREVIEWCONFIG_SHOWINFO.equals(c.getKey())) {
            this.showAttahConfigFrom(FORM_PREVIEWCONFIG, FIELD_PREVIEWCONFIG);
            return;
        }
        if (FIELD_MANAGERSERVICE.equals(c.getKey())) {
            this.showAttahConfigFrom(FORM_MANAGERSERVICE, FIELD_MANAGERSERVICE);
            return;
        }
        if (FIELD_UPLOADLIMIT.equals(c.getKey())) {
            this.showAttahConfigFrom(FORM_UPLOADLIMIT, FIELD_UPLOADLIMIT_CONTENT);
            return;
        }
        if (FIELD_DOWNLOADLIMIT.equals(c.getKey())) {
            this.showAttahConfigFrom(FORM_DOWNLOADLIMIT, FIELD_DOWNLOADLIMIT_CONTENT);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (FORM_FORBIDFILETYPE.equals(e.getActionId()) && null != e.getReturnData()) {
            String forbidfiletype = (String)e.getReturnData();
            this.getModel().setValue(FIELD_FORBIDFILETYPE, (Object)forbidfiletype);
            return;
        }
        if (FORM_PREVIEWCONFIG.equals(e.getActionId()) && e.getReturnData() != null) {
            if (null != e.getReturnData()) {
                ParamDealUtil.setValue4PreviewConfig(this.getModel(), e.getReturnData());
            }
            this.getModel().setValue(FIELD_PREVIEWCONFIG, (Object)SerializationUtils.toJsonString((Object)e.getReturnData()));
            return;
        }
        if (FORM_MANAGERSERVICE.equals(e.getActionId())) {
            Map returnData = (Map)e.getReturnData();
            if (returnData != null) {
                this.getModel().setValue(FIELD_MANAGERSERVICE, (Object)(returnData.size() == 0 ? "" : SerializationUtils.toJsonString((Object)e.getReturnData())));
            }
            return;
        }
        if (FORM_UPLOADLIMIT.equals(e.getActionId())) {
            this.setUserConfig(e, FIELD_UPLOADLIMIT, FIELD_UPLOADLIMIT_CONTENT);
            return;
        }
        if (FORM_DOWNLOADLIMIT.equals(e.getActionId())) {
            this.setUserConfig(e, FIELD_DOWNLOADLIMIT, FIELD_DOWNLOADLIMIT_CONTENT);
        }
    }

    private void showAttahConfigFrom(String formId, String fieldKey) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        Object fieldKeyValue = this.getModel().getValue(fieldKey);
        if (StringUtils.isNotBlank((Object)fieldKeyValue)) {
            Map params = (Map)SerializationUtils.fromJsonString((String)fieldKeyValue.toString(), Map.class);
            parameter.setCustomParams(params);
        }
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, formId);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void setUserConfig(ClosedCallBackEvent e, String showFieldKey, String contentFieldKey) {
        Map returnData = (Map)e.getReturnData();
        if (returnData != null) {
            this.getModel().setValue(contentFieldKey, (Object)(returnData.size() == 0 ? "" : SerializationUtils.toJsonString((Object)returnData)));
            String tipsType = FIELD_UPLOADLIMIT.equals(showFieldKey) ? "upload" : "download";
            String configTips = this.formatConfigTips(tipsType, returnData);
            this.getModel().setValue(showFieldKey, (Object)configTips);
        }
    }

    private String formatConfigTips(String tipsType, Map<String, String> configContentMap) {
        StringBuilder configTips = new StringBuilder();
        String secondlimit = configContentMap.get(FIELD_SECONDLIMIT);
        String minutelimit = configContentMap.get(FIELD_MINUTELIMIT);
        String hourlimit = configContentMap.get(FIELD_HOURLIMIT);
        String daylimit = configContentMap.get(FIELD_DAYLIMIT);
        if (StringUtils.isNotBlank((CharSequence)(secondlimit + minutelimit + hourlimit + daylimit))) {
            if (StringUtils.isNotBlank((CharSequence)secondlimit) && Long.parseLong(secondlimit) > 0L) {
                configTips.append(String.format(ResManager.loadKDString((String)"%1$s\u6b21/\u79d2%2$s", (String)"AttachUploadLimitPlugin_1", (String)BOS_ATTACHMENT, (Object[])new Object[0]), secondlimit, "\uff0c"));
            }
            if (StringUtils.isNotBlank((CharSequence)minutelimit) && Long.parseLong(minutelimit) > 0L) {
                configTips.append(String.format(ResManager.loadKDString((String)"%1$s\u6b21/\u5206\u949f%2$s", (String)"AttachUploadLimitPlugin_2", (String)BOS_ATTACHMENT, (Object[])new Object[0]), minutelimit, "\uff0c"));
            }
            if (StringUtils.isNotBlank((CharSequence)hourlimit) && Long.parseLong(hourlimit) > 0L) {
                configTips.append(String.format(ResManager.loadKDString((String)"%1$s\u6b21/\u5c0f\u65f6%2$s", (String)"AttachUploadLimitPlugin_3", (String)BOS_ATTACHMENT, (Object[])new Object[0]), hourlimit, "\uff0c"));
            }
            if (StringUtils.isNotBlank((CharSequence)daylimit) && Long.parseLong(daylimit) > 0L) {
                configTips.append(String.format(ResManager.loadKDString((String)"%1$s\u6b21/\u5929%2$s", (String)"AttachUploadLimitPlugin_4", (String)BOS_ATTACHMENT, (Object[])new Object[0]), daylimit, "\uff0c"));
            }
            if (configTips.length() != 0) {
                configTips.deleteCharAt(configTips.length() - 1);
            }
        }
        log.debug("kd.bos.form.plugin.param.AttachmentServerParamPlugin.formatConfigTips --- 5" + configTips);
        return configTips.toString();
    }
}

